/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironment;
import de.aristaflow.adept2.model.runtimeenvironment.SessionContext;

public class WaitComponent
extends ExecutionEnvironment {
    public static final String EC_NAME = "de.aristaflow.tools.Wait";
    public static final String CONF_DURATION = "Duration";
    public static final String PARAM_IN_ENDTIME = "EndTime";
    protected static final float WAKE_UP_ADVANCE = 0.3f;
    protected static final int SUSPEND_THRESHOLD = 60;
    protected long endTime = Long.MAX_VALUE;
    protected int signal;

    public WaitComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void init(SessionContext sessionContext) {
        super.init(sessionContext);
        ProcessModelParameter endTimeParam = this.activityInstance.getParameter(PARAM_IN_ENDTIME, ActivityConstants.AccessType.READ);
        if (endTimeParam != null) {
            try {
                this.endTime = sessionContext.getDataContext().retrieveDateParameterValue(PARAM_IN_ENDTIME).getTime();
            }
            catch (NoSuchParameterException noSuchParameterException) {
            }
            catch (InvalidDataTypeException ex) {
                String msg = "The input parameter '%s' does not have the expected data type %s!";
                msg = String.format(msg, new Object[]{endTimeParam.getName(), endTimeParam.getDataType()});
                throw new ApplicationEnvironmentException(msg, 0L, ex);
            }
        }
        if (this.endTime == Long.MAX_VALUE) {
            long duration = this.getDualInputParameterValue(CONF_DURATION, ProcessConstants.AdeptDataType.INTEGER, Long.class);
            this.endTime = System.currentTimeMillis() + duration * 1000L;
        }
    }

    @Override
    public void initResume(int savePointID, SessionContext sessionContext) {
        super.init(sessionContext);
        byte[] state = sessionContext.getRuntimeEnvironment().getApplicationState(1);
        long time = 0L;
        int i = 0;
        while (i < 8) {
            time <<= 8;
            time ^= (long)state[i] & 0xFFL;
            ++i;
        }
        this.endTime = time;
    }

    protected void saveState(long endTime) {
        byte[] state = new byte[8];
        int i = 0;
        while (i < 8) {
            state[7 - i] = (byte)(endTime >>> i * 8);
            ++i;
        }
        this.sessionContext.getRuntimeEnvironment().setApplicationState(1, state);
    }

    @Override
    public void run() {
        long earlyWakeUp = 18000L;
        long suspendDuration = this.endTime - earlyWakeUp - System.currentTimeMillis();
        if (suspendDuration > 60000L) {
            this.saveState(this.endTime);
            this.sessionContext.getRuntimeEnvironment().applicationSuspended(suspendDuration);
            String msg = String.format("Needing to wait for %d. This is above threshold. Suspending activity '%s'.", suspendDuration / 1000L, this.activityInstance.getName());
            this.logger.fine(msg);
        } else {
            String msg;
            long currentTime = System.currentTimeMillis();
            while (currentTime < this.endTime) {
                try {
                    suspendDuration = this.endTime - currentTime;
                    msg = String.format("Activity '%s' will sleep for %d seconds.", this.activityInstance.getName(), suspendDuration / 1000L);
                    this.logger.fine(msg);
                    Thread.sleep(suspendDuration);
                    currentTime = System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {
                    if (!this.sessionContext.getRuntimeEnvironment().dispatch()) continue;
                    RuntimeEnvironment environment = this.sessionContext.getRuntimeEnvironment();
                    suspendDuration = this.endTime - System.currentTimeMillis();
                    switch (this.signal) {
                        case 7: {
                            environment.applicationClosed();
                            msg = String.format("Activity '%s' is externally closed. It will not wait any longer although it should still wait %d seconds.", this.activityInstance.getName(), suspendDuration / 1000L);
                            this.logger.info(msg);
                            break;
                        }
                        case 14336: {
                            msg = String.format("Activity '%s' is externally aborted. It is set to fail. It should have waited %d seconds.", this.activityInstance.getName(), suspendDuration / 1000L);
                            this.logger.info(msg);
                            throw new ApplicationFailedException("Runtime signalled KILL!", "ADEPT2:WaitComponent:Runtime:ApplicationKilled", 1400000L);
                        }
                        case 28: {
                            environment.applicationReset();
                            msg = String.format("Activity '%s' is externally reset. It would have had %d seconds to wait. When restarted, it will wait the complete duration again.", this.activityInstance.getName(), suspendDuration / 1000L);
                            this.logger.info(msg);
                            break;
                        }
                        case 14: {
                            this.saveState(this.endTime);
                            suspendDuration = this.endTime - earlyWakeUp - System.currentTimeMillis();
                            msg = String.format("Activity '%s' is externally suspended. It will register for automatic resume in %d seconds.", this.activityInstance.getName(), suspendDuration / 1000L);
                            this.logger.info(msg);
                            environment.applicationSuspended(suspendDuration);
                            break;
                        }
                        default: {
                            msg = String.format("Unsupported signal '%s'!", this.signal);
                            this.logger.warning(msg);
                        }
                    }
                    currentTime = Long.MAX_VALUE;
                }
            }
            if (currentTime < Long.MAX_VALUE) {
                msg = String.format("Activity '%s' has completed waiting and finished normally.", this.activityInstance.getName());
                this.logger.info(msg);
                this.sessionContext.getRuntimeEnvironment().applicationClosed();
            }
        }
    }

    @Override
    public boolean close() {
        return this.signal(7);
    }

    @Override
    public boolean reset() {
        return this.signal(28);
    }

    @Override
    public boolean signal(int signal) {
        this.signal = signal;
        return true;
    }

    @Override
    public boolean suspend() {
        return this.signal(14);
    }

    @Override
    public boolean kill() {
        return this.signal(14336);
    }
}

