/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class XSLTComponent
extends ExecutionEnvironment {
    public static final String EC_NAME = "de.aristaflow.xml.XSLT";
    public static final String ATC_STYLESHEET = "Stylesheet";
    public static final String ATC_STYLESHEET_URI = "StylesheetURI";
    public static final String PARAM_IN_XML = "inputXML";
    public static final String PARAM_OUT_XML = "outputXML";

    public XSLTComponent(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void run() {
        Document xmlInput;
        StreamSource xslInput;
        ActivityConfiguration atc = this.activityInstance.getConfiguration();
        String stylesheet = atc.getString(ATC_STYLESHEET);
        String stylesheetUri = atc.getString(ATC_STYLESHEET_URI);
        if (stylesheet != null) {
            byte[] stylesheetBytes = Base64.decode(stylesheet);
            xslInput = new StreamSource(new ByteArrayInputStream(stylesheetBytes));
        } else if (stylesheetUri != null) {
            try {
                xslInput = new StreamSource(new URL(stylesheetUri).openStream());
            }
            catch (MalformedURLException malformedURLException) {
                String msg = "The specified URL for the XSLT stylesheet is not valid!";
                throw new ApplicationEnvironmentException(msg, 0L);
            }
            catch (IOException iOException) {
                String msg = "Could not load the XSLT stylesheet!";
                throw new ApplicationEnvironmentException(msg, 0L);
            }
        } else {
            String msg = "No XSLT stylesheet specified!";
            throw new ApplicationEnvironmentException(msg, 0L);
        }
        DataContext dataContext = this.sessionContext.getDataContext();
        ProcessModelParameter xmlInputParam = this.activityInstance.getParameter(PARAM_IN_XML, ActivityConstants.AccessType.READ);
        try {
            switch (xmlInputParam.getDataType()) {
                case STRING: {
                    Object xml = dataContext.retrieveStringParameterValue(PARAM_IN_XML);
                    xmlInput = XMLHelperTools.getDocumentFromString((String)xml, null);
                    break;
                }
                case USERDEFINED: {
                    Object xml = dataContext.retrieveUDTParameterValue(PARAM_IN_XML);
                    xmlInput = XMLHelperTools.getDocumentFromStream(xml.getValueAsStream());
                    break;
                }
                default: {
                    String msg = "XML parameter has illegal type: %s";
                    msg = String.format(msg, new Object[]{xmlInputParam.getDataType()});
                    throw new ApplicationEnvironmentException(msg, 0L);
                }
            }
        }
        catch (InvalidDataTypeException ex) {
            String msg = "Unexpected data type %s of input parameter '%s'!";
            msg = String.format(msg, new Object[]{ex.getActualDataType(), xmlInputParam.getName()});
            throw new ApplicationEnvironmentException(msg, -401001L, ex);
        }
        catch (NoSuchParameterException ex) {
            String msg = "The expected input parameter '%s' is missing!";
            msg = String.format(msg, xmlInputParam.getName());
            throw new ApplicationEnvironmentException(msg, -401000L, ex);
        }
        catch (XMLFormatException e) {
            String msg = "An XMLFormatException occurred while trying to retrieve the value of input parameter '%s'!";
            msg = String.format(msg, xmlInputParam.getName());
            throw new ApplicationEnvironmentException(msg, 123009L, e);
        }
        catch (IOException e) {
            String msg = "An IOException occurred while trying to retrieve the value of input parameter '%s'!";
            msg = String.format(msg, xmlInputParam.getName());
            throw new ApplicationEnvironmentException(msg, 123003L, e);
        }
        ProcessModelParameter xmlOutputParam = this.activityInstance.getParameter(PARAM_OUT_XML, ActivityConstants.AccessType.WRITE);
        try {
            ByteArrayOutputStream xmlOutput = XMLHelperTools.getOutputStreamForDocument(xmlInput, xslInput);
            switch (xmlOutputParam.getDataType()) {
                case STRING: {
                    String outputString = XMLHelperTools.getXMLStringForInputStream(new ByteArrayInputStream(xmlOutput.toByteArray()));
                    dataContext.storeStringParameterValue(PARAM_OUT_XML, outputString);
                    break;
                }
                case USERDEFINED: {
                    ADEPT2UDTValue udt = new ADEPT2UDTValue(xmlOutputParam.getUDTName(), xmlOutput.toByteArray());
                    dataContext.storeUDTParameterValue(PARAM_OUT_XML, udt);
                    break;
                }
                default: {
                    String msg = "Transformation output parameter has illegal type: %s";
                    msg = String.format(msg, new Object[]{xmlOutputParam.getDataType()});
                    throw new ApplicationEnvironmentException(msg, 0L);
                }
            }
        }
        catch (IOException e) {
            String msg = "An IOException occurred while trying to store the value of output parameter '%s'!";
            msg = String.format(msg, xmlOutputParam.getName());
            throw new ApplicationEnvironmentException(msg, 123003L, e);
        }
        catch (InvalidDataTypeException ex) {
            String msg = "Unexpected data type %s of output parameter '%s'!";
            msg = String.format(msg, new Object[]{ex.getActualDataType(), xmlOutputParam.getName()});
            throw new ApplicationEnvironmentException(msg, -401001L, ex);
        }
        catch (NoSuchParameterException ex) {
            String msg = "The expected output parameter '%s' is missing!";
            msg = String.format(msg, xmlOutputParam.getName());
            throw new ApplicationEnvironmentException(msg, -401000L, ex);
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }
}

