/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.wssupport;

import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.extensions.javasupport.AbstractBundleCreator;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.ConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginDataContainer;
import de.aristaflow.adept2.util.LoggerTools;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import sun.tools.jar.Main;

public class WSDLBundleCreator
extends AbstractBundleCreator {
    private String portName;
    private String uri;
    private String portTypeName;
    private CompilationUnit compilationUnit;
    private String generatedWebServiceJarPath;
    private Map<String, String> activityConfiguration = new HashMap<String, String>();

    public WSDLBundleCreator(ActivityModelFactory amf, String wsdlFileName, String jarDirName, Operation wsOperation, ConfigurationSet configurationSet) {
        super(amf, false, wsOperation, configurationSet);
        String serviceName;
        String directory = this.getDirectoryForFileName(wsdlFileName);
        File dirFile = new File(directory);
        String stubPackageName = null;
        try {
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            Definition def = reader.readWSDL(wsdlFileName);
            Set<QName> services = this.getServices(def);
            if (services.size() != 1) {
                throw new RuntimeException("WSDLBundleCreator: More than one service!");
            }
            QName serviceQName = services.iterator().next();
            serviceName = serviceQName.getLocalPart();
            this.initialiseSoapBinding(def, serviceQName);
        }
        catch (WSDLException e) {
            throw new RuntimeException("A WSDLException occurred while trying to read the wsdl file!", e);
        }
        String axisDir = String.valueOf(SystemProperties.getLibDir()) + File.separator + "axis-1_4" + File.separator;
        String commonsDir = String.valueOf(SystemProperties.getLibDir()) + File.separator + "commons" + File.separator;
        String classpathString = String.valueOf(axisDir) + "axis.jar" + File.pathSeparator + commonsDir + "commons-discovery-0.4.jar" + File.pathSeparator + commonsDir + "commons-logging-1.1.1.jar" + File.pathSeparator + axisDir + "jaxrpc.jar" + File.pathSeparator + axisDir + "log4j-1.2.8.jar" + File.pathSeparator + axisDir + "saaj.jar" + File.pathSeparator + axisDir + "wsdl4j-1.5.1.jar";
        try {
            String[] wsdl2javaCommand = new String[]{"java", "-classpath", classpathString, "org.apache.axis.wsdl.WSDL2Java", "-o" + directory, wsdlFileName};
            System.out.println("wsdl2javaClassPath: " + classpathString);
            Process p = Runtime.getRuntime().exec(wsdl2javaCommand);
            StreamReader inputReader = new StreamReader(p.getInputStream(), null, Level.FINEST);
            new Thread((Runnable)inputReader, "WSDL2Java.INPUT").start();
            StreamReader errorReader = new StreamReader(p.getErrorStream(), null, Level.WARNING);
            new Thread((Runnable)errorReader, "WSDL2Java.ERROR").start();
            if (p.waitFor() != 0) {
                throw new RuntimeException("Axis could not extract java files from the wsdl file. See log for the more information.");
            }
            inputReader.setTerminated();
            errorReader.setTerminated();
        }
        catch (IOException e) {
            throw new RuntimeException("Axis could not extract java files from the wsdl file! An IOException occurred!", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Axis could not extract java files from the wsdl file! An InterruptedException occurred!", e);
        }
        Set<File> files = this.getAllFilesInDir(dirFile);
        File classDir = new File(String.valueOf(directory) + "/classes");
        if (!classDir.mkdir()) {
            throw new RuntimeException("Could not create a temporary directory for the class files.");
        }
        String classDirectory = classDir.getPath();
        for (File f : files) {
            String fileName = f.getPath();
            if (fileName.endsWith(String.valueOf(this.portTypeName) + ".java") || fileName.endsWith(String.valueOf(this.portTypeName) + "_PortType.java")) {
                if (fileName.endsWith(String.valueOf(this.portTypeName) + "_PortType.java")) {
                    this.portTypeName = this.portTypeName.concat("_PortType");
                }
                try {
                    this.compilationUnit = JavaParser.parse((File)f);
                }
                catch (ParseException e) {
                    throw new RuntimeException("A ParseException occurred while trying to get the parameter naming information from a java source file!", e);
                }
                StringBuilder buf = new StringBuilder(fileName);
                buf.delete(0, directory.length() + 1);
                buf.delete(buf.length() - 6 - this.portTypeName.length(), buf.length());
                int i = buf.lastIndexOf(File.separator);
                while (i != -1) {
                    int start = i;
                    int end = i + 1;
                    buf.replace(start, end, ".");
                    i = buf.lastIndexOf(File.separator);
                }
                stubPackageName = buf.toString();
            } else if (fileName.endsWith(String.valueOf(serviceName) + "_Service.java")) {
                serviceName = serviceName.concat("_Service");
            }
            String[] command = new String[]{"-classpath", classpathString, "-sourcepath", directory, "-d", classDirectory, fileName};
            com.sun.tools.javac.Main.compile(command);
        }
        String jarFilePath = String.valueOf(jarDirName) + "/" + directory + ".jar";
        String[] jarCommand = new String[]{"cf", jarFilePath, "-C", classDirectory, "."};
        this.generatedWebServiceJarPath = "${arflow:arflow.libdir}/extensions/" + directory + ".jar";
        if (!new Main(System.out, System.err, "jar").run(jarCommand)) {
            throw new RuntimeException("An error occured during the creation of the jar file containing the interfaces & classes for the web service call!");
        }
        this.activityConfiguration.put("ServiceName", serviceName);
        this.activityConfiguration.put("PortName", this.portName);
        this.activityConfiguration.put("WebServiceURI", this.uri);
        this.activityConfiguration.put("PortTypeName", this.portTypeName);
        this.activityConfiguration.put("StubPackageName", stubPackageName);
        try {
            URL[] urlsArray = new URL[]{new File(jarFilePath).getCanonicalFile().toURL()};
            this.classLoader = AccessController.doPrivileged(new PrivilegedActionImpl(urlsArray));
            Class<?> clazz = this.classLoader.loadClass(String.valueOf(stubPackageName) + "." + this.portTypeName);
            this.addClass(clazz);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("A MalformedURLException occurred while trying to create the operations from the jar file!", e);
        }
        catch (IOException e) {
            throw new RuntimeException("An IOException occurred while trying to create the operations from the jar file!", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("A ClassNotFoundException occurred while trying to create the operations from the jar file!", e);
        }
        if (!this.deleteAllFilesInDir(dirFile)) {
            System.out.println("Could not delete " + dirFile.getAbsolutePath());
        }
    }

    @Override
    protected ActivityTemplateDefinition createATDFromMethod(Method method) {
        UUID id = this.getNextActivityTemplateDefinitionID();
        String name = method.getName();
        String description = "";
        String developerDescription = "";
        ParameterChangePolicy parameterChangePolicy = ParameterChangePolicy.FIXED;
        Collection<ActivityModelParameter> inputParameters = this.createInputParameters(method);
        Collection<ActivityModelParameter> outputParameters = this.createOutputParameters(method);
        this.addVirtualParameters(method, inputParameters, outputParameters);
        String staffAssignmentRule = "Agent(id=8)";
        String guiContextID = "NullContext";
        ExecutionControlProperties ecp = new ExecutionControlProperties(false, false, false);
        DefaultPluginDataContainer pdc = new DefaultPluginDataContainer(null, null, null);
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        this.activityConfiguration.put("MethodName", name);
        long revision = 0L;
        State state = State.IN_DEVELOPMENT;
        ArrayList<String> classPath = new ArrayList<String>();
        classPath.add(this.generatedWebServiceJarPath);
        Boolean isSingleton = false;
        boolean supportsViewOnly = false;
        boolean supportsTestExecution = false;
        String licenceInformation = "";
        HashSet<String> fixedForChildren = new HashSet<String>(this.activityConfiguration.keySet());
        InheritedActivityConfiguration configuration = this.amf.createInheritedActivityConfiguration(null, this.activityConfiguration, null, null, fixedForChildren);
        HashSet<ParameterTemplate> parameterTemplates = new HashSet<ParameterTemplate>();
        ActivityTemplateDefinition atd = this.amf.createActivityTemplateDefinition(this.operation, this.configurationSet, id, name, description, developerDescription, revision, state, null, classPath, isSingleton, null, guiContextID, ecp, supportsViewOnly, supportsTestExecution, null, licenceInformation, null, configuration, null, parameterChangePolicy, inputParameters, outputParameters, parameterTemplates, staffAssignmentRule, pdc, userAttributes);
        return atd;
    }

    @Override
    protected String getParameterName(Method method, int index) {
        Object o;
        String name = "";
        if (this.compilationUnit.types.size() == 1) {
            o = this.compilationUnit.types.get(0);
            if (!(o instanceof ClassOrInterfaceDeclaration)) {
                throw new RuntimeException("The only type found is not an interface and not a class! " + o);
            }
        } else {
            throw new RuntimeException("More than one interface or class found in the source file!");
        }
        ClassOrInterfaceDeclaration decl = (ClassOrInterfaceDeclaration)o;
        for (Object o2 : decl.members) {
            if (!(o2 instanceof MethodDeclaration)) {
                throw new RuntimeException("No method declaration found!");
            }
            MethodDeclaration methDecl = (MethodDeclaration)o2;
            if (!methDecl.name.equals(method.getName())) continue;
            name = ((Parameter)methDecl.parameters.get((int)index)).id.name;
        }
        return name;
    }

    @Override
    protected String getResultName(Method method) {
        return String.valueOf(method.getName()) + "Result";
    }

    private Set<QName> getServices(Definition def) {
        HashSet<QName> services = new HashSet<QName>();
        for (Object serviceName : def.getServices().keySet()) {
            services.add((QName)serviceName);
        }
        return services;
    }

    private void initialiseSoapBinding(Definition def, QName serviceName) {
        HashSet<String> ports = new HashSet<String>();
        Service service = (Service)def.getServices().get(serviceName);
        for (Object port : service.getPorts().values()) {
            if (!(port instanceof Port)) {
                throw new RuntimeException("Service.getPorts() does not return objects of the type 'Port'!");
            }
            Port p = (Port)port;
            if (p.getExtensibilityElements().size() != 1) {
                throw new RuntimeException("More than one extensibility element found!");
            }
            if (!(p.getExtensibilityElements().get(0) instanceof SOAPAddress)) continue;
            SOAPAddress address = (SOAPAddress)p.getExtensibilityElements().get(0);
            this.portName = p.getName().replaceAll("-", "");
            this.uri = address.getLocationURI();
            this.portTypeName = p.getBinding().getPortType().getQName().getLocalPart();
            ports.add(this.portName);
        }
        if (ports.size() != 1) {
            throw new RuntimeException("More than one port with soap binding found!");
        }
    }

    private String getDirectoryForFileName(String fileName) {
        Date now = new Date();
        String date = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(now);
        String directory = fileName.substring(fileName.lastIndexOf(File.separator) + 1, fileName.lastIndexOf("."));
        directory = directory.replace('-', '_');
        return String.valueOf(directory) + "_" + date;
    }

    private Set<File> getAllFilesInDir(File dir) {
        HashSet<File> files = new HashSet<File>();
        if (dir.isDirectory()) {
            File[] list = dir.listFiles();
            int i = 0;
            while (i < list.length) {
                files.addAll(this.getAllFilesInDir(list[i]));
                ++i;
            }
        } else {
            files.add(dir);
        }
        return files;
    }

    private boolean deleteAllFilesInDir(File file) {
        boolean ret;
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            int i = 0;
            while (i < list.length) {
                this.deleteAllFilesInDir(list[i]);
                ++i;
            }
            ret = file.delete();
        } else {
            ret = file.delete();
        }
        return ret;
    }

    private static final class PrivilegedActionImpl
    implements PrivilegedAction<URLClassLoader> {
        private final URL[] urlsArray;

        PrivilegedActionImpl(URL[] urlsArray) {
            this.urlsArray = urlsArray;
        }

        @Override
        public URLClassLoader run() {
            return new URLClassLoader(this.urlsArray, this.getClass().getClassLoader());
        }
    }

    private static class StreamReader
    implements Runnable {
        private final Logger logger = LoggerTools.getLogger(this);
        private final InputStream in;
        private final String name;
        private final Level level;
        private boolean terminated;

        public StreamReader(InputStream in, String name, Level level) {
            this.in = in;
            this.name = name;
            this.level = level;
            this.terminated = false;
        }

        public void setTerminated() {
            this.terminated = true;
        }

        @Override
        public void run() {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
            try {
                try {
                    String line = br.readLine();
                    while (!this.terminated) {
                        if (line == null) continue;
                        StringBuilder sb = new StringBuilder();
                        if (this.name != null) {
                            sb.append(this.name);
                            sb.append("> ");
                        }
                        sb.append(line);
                        line = br.readLine();
                        this.logger.log(this.level, sb.toString());
                    }
                    br.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.WARNING, "An IOException occurred while trying to access the BufferedReader.", e);
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e2) {
                        this.logger.log(Level.WARNING, "An IOException occurred while trying to close the BufferedReader.", e2);
                    }
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    this.logger.log(Level.WARNING, "An IOException occurred while trying to close the BufferedReader.", e);
                }
            }
        }
    }
}

