/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.wssupport.environments;

import de.aristaflow.adept2.extensions.javasupport.environments.GenericJavaMethodExecutionEnvironment;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.RuntimeEnvironment;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import javax.xml.rpc.holders.ByteHolder;
import javax.xml.rpc.holders.ByteWrapperHolder;
import javax.xml.rpc.holders.DoubleHolder;
import javax.xml.rpc.holders.DoubleWrapperHolder;
import javax.xml.rpc.holders.FloatHolder;
import javax.xml.rpc.holders.FloatWrapperHolder;
import javax.xml.rpc.holders.Holder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.IntegerWrapperHolder;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.LongWrapperHolder;
import javax.xml.rpc.holders.ObjectHolder;
import javax.xml.rpc.holders.ShortHolder;
import javax.xml.rpc.holders.ShortWrapperHolder;
import javax.xml.rpc.holders.StringHolder;

public class GenericWebServiceExecutionEnvironment
extends GenericJavaMethodExecutionEnvironment {
    public static final String GENERIC_WS_OPERATTION_NAME = "Generic WebService Operation";
    private final String serviceName;
    private final String stubPackageName;
    private final String operationName;
    private final URL portAddress;
    private String serviceDefinitionInterfaceName;
    private String portName;
    private String portTypeName;

    public GenericWebServiceExecutionEnvironment(ActivityInstance activityInstance) {
        super(activityInstance);
        ActivityConfiguration configuration = activityInstance.getConfiguration();
        this.serviceName = configuration.getString("ServiceName");
        if (this.serviceName == null || this.serviceName.equals("")) {
            String errorMessage = String.format("The meta data entry '%1s' is not set or is empty for activity '%2s'!", "ServiceName", activityInstance.getName());
            this.logger.log(Level.SEVERE, errorMessage);
            throw new ApplicationEnvironmentException(errorMessage, 1200000L);
        }
        this.stubPackageName = configuration.getString("StubPackageName");
        if (this.stubPackageName == null) {
            String errorMessage = String.format("The meta data entry '%1s' is not set for activity '%2s'!", "StubPackageName", activityInstance.getName());
            this.logger.log(Level.SEVERE, errorMessage);
            throw new ApplicationEnvironmentException(errorMessage, 1200001L);
        }
        this.portName = configuration.getString("PortName");
        if (this.portName == null || this.portName.equals("")) {
            String errorMessage = String.format("The meta data entry '%1s' is not set or empty for activity '%2s'!", "PortName", activityInstance.getName());
            this.logger.log(Level.SEVERE, errorMessage);
            throw new ApplicationEnvironmentException(errorMessage, 1200002L);
        }
        this.portTypeName = configuration.getString("PortTypeName");
        if (this.portTypeName == null || this.portTypeName.equals("")) {
            String errorMessage = String.format("The meta data entry '%1s' is not set or empty for activity '%2s'!", "PortTypeName", activityInstance.getName());
            this.logger.log(Level.SEVERE, errorMessage);
            throw new ApplicationEnvironmentException(errorMessage, 1200003L);
        }
        this.serviceDefinitionInterfaceName = String.valueOf(this.stubPackageName) + "." + this.portTypeName;
        String methodName = configuration.getString("MethodName");
        this.operationName = methodName != null ? methodName : activityInstance.getOperationName();
        if (this.operationName == null || this.operationName.equals("")) {
            String errorMessage = String.format("The name of the operation of the webservice '%s' to be executed isn't specified for activity '%s'!", "ServiceName", activityInstance.getName());
            this.logger.log(Level.SEVERE, errorMessage);
            throw new ApplicationEnvironmentException(errorMessage, 1200004L);
        }
        String portAddressAsURI = configuration.getString("WebServiceURI");
        try {
            this.portAddress = new URL(portAddressAsURI);
        }
        catch (MalformedURLException e) {
            String errorMessage = String.format("The port address %s specified in the activity %s is not a valid URL!", portAddressAsURI, activityInstance.getName());
            this.logger.log(Level.SEVERE, errorMessage, e);
            throw new ApplicationEnvironmentException(errorMessage, 1200005L, e);
        }
    }

    @Override
    public void run() {
        Object port;
        Object locator;
        String fullqualifiedWSName;
        String locatorInterfaceName = fullqualifiedWSName = String.valueOf(this.stubPackageName) + "." + this.serviceName;
        String locatorName = String.valueOf(fullqualifiedWSName) + "Locator";
        ClassLoader loader = this.getClass().getClassLoader();
        Class<?> locatorInterface = this.getLocatorInterface(locatorInterfaceName, loader);
        if (!locatorInterface.isAssignableFrom((locator = this.getLocatorInstance(locatorName, loader)).getClass())) {
            String errorMessage = "The loaded locator does not implement the Locator Interface!";
            this.logger.log(Level.SEVERE, errorMessage);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:INVALID_LOCATOR_LOCATOR_INTERFACE_NOT_IMPLEMENTED", 1200101L);
        }
        Class<?> serviceDefinitionInterface = this.getServiceDefinitionInterface(loader);
        if (!serviceDefinitionInterface.isAssignableFrom((port = this.getPort(locatorName, locator)).getClass())) {
            String errorMessage = "The port returned by the locator \"" + locatorName + "\" does not implement the Service Definition Interface +\"" + this.serviceDefinitionInterfaceName + "\"!";
            this.logger.log(Level.SEVERE, errorMessage);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:INVALID_PORT_SDI_NOT_IMPLEMENTED", 1200102L);
        }
        Class<?>[] operationParameterTypes = this.determineOperationParameterTypes(loader);
        int numberOfOperationParameters = operationParameterTypes.length;
        Object[] operationParameterValues = new Object[numberOfOperationParameters];
        this.determineInputParameterValues(operationParameterValues);
        this.initialiseOutputParameters(operationParameterTypes, operationParameterValues);
        Object returnValue = this.invokeTheWebService(serviceDefinitionInterface, port, operationParameterTypes, operationParameterValues);
        this.extractHolders(operationParameterValues);
        this.writeOutputValues(returnValue, operationParameterValues);
        RuntimeEnvironment runtimeEnvironment = this.sessionContext.getRuntimeEnvironment();
        runtimeEnvironment.applicationClosed();
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }

    protected void initialiseOutputParameters(Class<?>[] operationParameterTypes, Object[] operationParameterValues) {
        Set<ProcessModelParameter> outputParameters = this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE);
        Object value = null;
        for (ProcessModelParameter outputParameter : outputParameters) {
            String pos = outputParameter.getConfiguration().getString("position");
            if (pos == null) {
                this.logger.info("No position set for parameter " + outputParameter.getName());
                continue;
            }
            int position = Integer.parseInt(pos);
            if (position <= 0) continue;
            Class<?> expectedType = operationParameterTypes[position - 1];
            if (Holder.class.isAssignableFrom(expectedType)) {
                Class<?> holderClass = expectedType;
                Class<?> nativeOutputParameterType = this.getCorrespondingJavaClass(outputParameter, true);
                value = operationParameterValues[position - 1];
                value = this.getHolder(nativeOutputParameterType, value, holderClass);
            }
            operationParameterValues[position - 1] = value;
        }
    }

    protected void determineInputParameterValues(Object[] operationParameterValues) {
        Set<ProcessModelParameter> inputParameters = this.activityInstance.getParameters(ActivityConstants.AccessType.READ);
        DataContext dataContext = this.sessionContext.getDataContext();
        for (ProcessModelParameter parameter : inputParameters) {
            Object value;
            block15: {
                String pos = parameter.getConfiguration().getString("position");
                if (pos == null) {
                    this.logger.info("No position set for parameter " + parameter.getName());
                    continue;
                }
                int position = Integer.parseInt(pos);
                String parameterName = parameter.getName();
                ProcessConstants.AdeptDataType type = parameter.getDataType();
                if (position <= 0 || position > operationParameterValues.length) continue;
                value = null;
                try {
                    if (dataContext.isNull(parameterName)) break block15;
                    switch (type) {
                        case BOOLEAN: {
                            value = dataContext.retrieveBooleanParameterValue(parameterName);
                            value = this.booleanToNativeTypedValue((Boolean)value, parameter, false);
                            break;
                        }
                        case INTEGER: {
                            value = dataContext.retrieveIntegerParameterValue(parameterName);
                            value = this.integerToNativeTypedValue((Long)value, parameter, false);
                            break;
                        }
                        case FLOAT: {
                            value = dataContext.retrieveFloatParameterValue(parameterName);
                            value = this.floatToNativeTypedValue((Double)value, parameter, false);
                            break;
                        }
                        case STRING: {
                            value = dataContext.retrieveStringParameterValue(parameterName);
                            value = this.stringToNativeTypedValue((String)value, parameter, false);
                            break;
                        }
                        case DATE: {
                            value = dataContext.retrieveDateParameterValue(parameterName);
                            value = this.dateToNativeTypedValue((Date)value, parameter, false);
                            break;
                        }
                        case USERDEFINED: {
                            value = dataContext.retrieveUDTParameterValue(parameterName);
                            value = this.userdefinedToNativeTypedValue((UDTValue)value, parameter, false);
                            break;
                        }
                        case URI: {
                            value = dataContext.retrieveURIParameterValue(parameterName);
                            value = this.uriToNativeTypedValue((URI)value, parameter, false);
                            break;
                        }
                        default: {
                            assert (false) : "Data type '" + (Object)((Object)type) + "' of parameter '" + parameterName + "' not supported.";
                            break;
                        }
                    }
                }
                catch (NoSuchParameterException noSuchParameterException) {
                    this.logger.warning("There is no input parameter of name '" + parameterName + "' in the data context of activity '" + this.activityInstance.getName() + "'.");
                }
                catch (InvalidDataTypeException idte) {
                    this.logger.warning("The input parameter '" + parameterName + "' is of type '" + (Object)((Object)idte.getActualDataType()) + "' in the data context of activity '" + this.activityInstance.getName() + "'.");
                }
            }
            operationParameterValues[position - 1] = value;
        }
    }

    protected Class<?>[] determineOperationParameterTypes(ClassLoader loader) {
        int position;
        String pos;
        Set<ProcessModelParameter> inputParameters = this.activityInstance.getParameters(ActivityConstants.AccessType.READ);
        Set<ProcessModelParameter> outputParameters = this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE);
        Class[] tmp = new Class[inputParameters.size() + outputParameters.size()];
        int numberOfParameters = 0;
        for (ProcessModelParameter inputParameter : inputParameters) {
            pos = inputParameter.getConfiguration().getString("position");
            if (pos == null) {
                this.logger.info("No position set for parameter " + inputParameter.getName());
                continue;
            }
            position = Integer.parseInt(pos);
            if (position == 0) {
                String errorMessage = "Position 0 was assigned to the input parameter '" + inputParameter.getName() + "', but the position 0 is reserved for the return value of the operation!";
                this.logger.log(Level.SEVERE, errorMessage);
                throw new ApplicationEnvironmentException(errorMessage, 1200006L);
            }
            if (position < 0) continue;
            if (numberOfParameters < position) {
                numberOfParameters = position;
            }
            tmp[position - 1] = this.getCorrespondingJavaClass(inputParameter, false);
        }
        for (ProcessModelParameter outputParameter : outputParameters) {
            Class<?> holderType;
            pos = outputParameter.getConfiguration().getString("position");
            if (pos == null) {
                this.logger.info("No position set for parameter " + outputParameter.getName());
                continue;
            }
            position = Integer.parseInt(pos);
            if (position <= 0) continue;
            if (numberOfParameters < position) {
                numberOfParameters = position;
            }
            Class<?> parameterType = this.getCorrespondingJavaClass(outputParameter, true);
            tmp[position - 1] = holderType = this.getHolderType(parameterType, loader);
        }
        Class[] operationParameterTypes = new Class[numberOfParameters];
        System.arraycopy(tmp, 0, operationParameterTypes, 0, numberOfParameters);
        return operationParameterTypes;
    }

    protected Class<?> getHolderType(Class<?> parameterType, ClassLoader loader) {
        if (parameterType.equals(String.class)) {
            return StringHolder.class;
        }
        if (parameterType.equals(Integer.TYPE)) {
            return IntHolder.class;
        }
        if (parameterType.equals(Integer.class)) {
            return IntegerWrapperHolder.class;
        }
        if (parameterType.equals(Long.TYPE)) {
            return LongHolder.class;
        }
        if (parameterType.equals(Long.class)) {
            return LongWrapperHolder.class;
        }
        if (parameterType.equals(Short.TYPE)) {
            return ShortHolder.class;
        }
        if (parameterType.equals(Short.class)) {
            return ShortWrapperHolder.class;
        }
        if (parameterType.equals(Boolean.TYPE)) {
            return BooleanHolder.class;
        }
        if (parameterType.equals(Boolean.class)) {
            return BooleanWrapperHolder.class;
        }
        if (parameterType.equals(Byte.TYPE)) {
            return ByteHolder.class;
        }
        if (parameterType.equals(Byte.class)) {
            return ByteWrapperHolder.class;
        }
        if (parameterType.equals(Double.TYPE)) {
            return DoubleHolder.class;
        }
        if (parameterType.equals(Double.class)) {
            return DoubleWrapperHolder.class;
        }
        if (parameterType.equals(Float.TYPE)) {
            return FloatHolder.class;
        }
        if (parameterType.equals(Float.class)) {
            return FloatWrapperHolder.class;
        }
        String holdersPackageName = String.valueOf(this.stubPackageName) + ".holders";
        String holderName = String.valueOf(parameterType.getSimpleName()) + "Holder";
        String holderClassName = String.valueOf(holdersPackageName) + "." + holderName;
        try {
            Class<?> holderClass = loader.loadClass(holderClassName);
            if (Holder.class.isAssignableFrom(holderClass)) {
                return holderClass;
            }
            String errorMessage = "The loaded native Holder of type \"" + holderClassName + "\" is not an instance of the required type javax.xml.rpc.holders.Holder!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:INVALID_HOLDER_WRONG_SUPERTYPE", 1200103L);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return ObjectHolder.class;
        }
    }

    protected Holder getHolder(Class<?> parameterType, Object parameterValue, Class<?> holderClass) {
        Object holder = null;
        try {
            Field valueField;
            if (parameterValue == null && (valueField = holderClass.getDeclaredField("value")).getType().isPrimitive()) {
                holder = holderClass.newInstance();
            }
            if (parameterValue != null || holder == null) {
                Constructor<?> holderConstructor = holderClass.getConstructor(parameterType);
                holder = holderConstructor.newInstance(parameterValue);
            }
        }
        catch (SecurityException securityException) {
            String errorMessage = String.format("Security violation occurred at instantiating the holder of type '%s'", holderClass);
            this.logger.log(Level.SEVERE, errorMessage, securityException);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:HOLDER_INSTANTIATION_ERROR_SECURITY_EXCEPTION", 1200104L);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String errorMessage = String.format("Holders of type '%1s' don't provide any constructors expecting values of type '%2s'!", holderClass, parameterType);
            this.logger.log(Level.SEVERE, errorMessage, noSuchMethodException);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:HOLDER_INSTANTIATION_ERROR_NO_SUCH_METHOD_EXCEPTION", 1200104L);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String errorMessage = String.format("The parameter passed to the constructor of the holder of type '%1s' is illegal within this context!", holderClass);
            this.logger.log(Level.SEVERE, errorMessage, illegalArgumentException);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:HOLDER_INSTANTIATION_ERROR_ILLEGAL_ARGUMENT_EXCEPTION", 1200104L);
        }
        catch (InstantiationException instantiationException) {
            String errorMessage = String.format("The holder of type '%1s' is not instantiable!", holderClass);
            this.logger.log(Level.SEVERE, errorMessage, instantiationException);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:HOLDER_INSTANTIATION_ERROR_INSTANTIATION_EXCEPTION", 1200104L);
        }
        catch (IllegalAccessException illegalAccessException) {
            String errorMessage = String.format("The specified constructor of the holder of type '%1s' cannot be accessed by this execution environment!", holderClass);
            this.logger.log(Level.SEVERE, errorMessage, illegalAccessException);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:HOLDER_INSTANTIATION_ERROR_ILLEGAL_ACCESS_EXCEPTION", 1200104L);
        }
        catch (InvocationTargetException e) {
            String errorMessage = String.format("The called constructor of the holder of type '%1s' threw an exception!", holderClass);
            this.logger.log(Level.SEVERE, errorMessage, e.getTargetException());
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:HOLDER_INSTANTIATION_ERROR_INVOCATION_TARGET_EXCEPTION", 1200104L);
        }
        catch (NoSuchFieldException e) {
            String errorMessage = String.format("Trying to determine if the holder of type '%1s' expects an atomic value failed because there is no field called 'value'!", holderClass);
            this.logger.log(Level.SEVERE, errorMessage, e);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:INVALID_HOLDER_NO_VALUE_FIELD", 1200103L);
        }
        return holder;
    }

    protected Object extractWrappedParameterValue(Object parameterValueHolder) {
        Object returnValue;
        if (!(parameterValueHolder instanceof Holder)) {
            String errorMessage = "The parameter of type \"" + parameterValueHolder.getClass() + "\" to unwrap is not a subtype of the required type javax.xml.rpc.holders.Holder!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:INVALID_HOLDER_WRONG_SUPERTYPE", 1200103L);
        }
        try {
            Field valueClassField = parameterValueHolder.getClass().getField("value");
            returnValue = valueClassField.get(parameterValueHolder);
        }
        catch (SecurityException securityException) {
            String errorMessage = "The value field of the Holder cannot be accessed, a SecurityException was thrown: " + securityException.getLocalizedMessage() + "!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:HOLDER_ACCESS_ERROR_SECURITY_EXCEPTION", 1200105L);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            String errorMessage = "The value field of the Holder does not exist, a NoSuchFieldException was thrown: " + noSuchFieldException.getLocalizedMessage() + "!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:INVALID_HOLDER_NO_VALUE_FIELD", 1200105L);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String errorMessage = "The value cannot be extracted from the passed Holder, a IllegalArgumentException was thrown: " + illegalArgumentException.getLocalizedMessage() + "!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:HOLDER_ACCESS_ERROR_ILLEGAL_ARGUMENT_EXCEPTION", 1200105L);
        }
        catch (IllegalAccessException illegalAccessException) {
            String errorMessage = "The value field of the Holder cannot be accessed, a IllegalAccessException was thrown: " + illegalAccessException.getLocalizedMessage() + "!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:HOLDER_ACCESS_ERROR_ILLEGAL_ACCESS_EXCEPTION", 1200105L);
        }
        return returnValue;
    }

    protected void extractHolders(Object[] outputParameterValues) {
        Set<ProcessModelParameter> outputParameters = this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE);
        for (ProcessModelParameter outputParameter : outputParameters) {
            String pos = outputParameter.getConfiguration().getString("position");
            if (pos == null) {
                this.logger.info("No position set for parameter " + outputParameter.getName());
                continue;
            }
            int position = Integer.parseInt(pos);
            if (position <= 0) continue;
            outputParameterValues[position - 1] = this.extractWrappedParameterValue(outputParameterValues[position - 1]);
        }
    }

    protected Object invokeTheWebService(Class<?> serviceDefinitionInterface, Object port, Class<?>[] operationParameterTypes, Object[] operationParameterValues) {
        Object returnValue;
        try {
            Method operationToInvoke = serviceDefinitionInterface.getMethod(this.operationName, operationParameterTypes);
            returnValue = operationToInvoke.invoke(port, operationParameterValues);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String errorMessage = "The specified webservice  \"" + this.serviceName + "\" does not provide the requested operation \"" + this.operationName + "\", a NoSuchMethodException was thrown: " + noSuchMethodException.getLocalizedMessage() + "!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:SERVICE_INVOCATION_ERROR_NO_SUCH_OPERATION", 1200109L, noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String errorMessage = String.format("Execution of the webservice operation '%1s' failed due to illegal arguments passed to the operation!", this.operationName);
            this.logger.log(Level.SEVERE, errorMessage, illegalArgumentException);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:SERVICE_INVOCATION_ERROR_ILLEGAL_ARGUMENT_EXCEPTION", 1200109L, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String errorMessage = String.format("Execution of the webservice operation '%1s' failed due to illegal access exception!", this.operationName);
            this.logger.log(Level.SEVERE, errorMessage, illegalAccessException);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:SERVICE_INVOCATION_ERROR_ILLEGAL_ACCESS_EXCEPTION", 1200109L, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            String errorMessage = String.format("Execution of the webservice operation '%1s' failed!", this.operationName);
            this.logger.log(Level.SEVERE, errorMessage, invocationTargetException);
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:SERVICE_INVOCATION_ERROR_INVOCATION_TARGET_EXCEPTION", 1200109L, invocationTargetException);
        }
        return returnValue;
    }

    protected Object getPort(String locatorName, Object locator) {
        Object port;
        try {
            Method locatorMethod = locator.getClass().getMethod("get" + this.portName, URL.class);
            port = locatorMethod.invoke(locator, this.portAddress);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String errorMessage = "The specified locator \"" + locatorName + "\" does not provide the method that returns a reference to the requested web service, " + "a NoSuchMethodException was thrown: " + noSuchMethodException.getLocalizedMessage() + "!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:LOCATOR_ACCESS_ERROR_NO_SUCH_METHOD_EXCEPTION", 1200107L);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String errorMessage = "The passed parameter for the locator method that returns a reference to the requested web service is illegal, an IllegalArgumentException was thrown: " + illegalArgumentException.getLocalizedMessage() + "!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:LOCATOR_ACCESS_ERROR_ILLEGAL_ARGUMENT_EXCEPTION", 1200107L);
        }
        catch (IllegalAccessException illegalAccessException) {
            String errorMessage = "The locator method that returns a reference to the requested web service cannot be accessed, an IllegalAccessException was thrown: " + illegalAccessException.getLocalizedMessage() + "!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:LOCATOR_ACCESS_ERROR_ILLEGAL_ACCESS_EXCEPTION", 1200107L);
        }
        catch (InvocationTargetException invocationTargetException) {
            String errorMessage = "The locator method that returns a reference to the requested web service cannot be accessed, an InvocationTargetException was thrown: " + invocationTargetException.getLocalizedMessage() + "!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:LOCATOR_ACCESS_ERROR_INVOCATION_TARGET_EXCEPTION", 1200107L);
        }
        return port;
    }

    protected Class<?> getLocatorInterface(String locatorInterfaceName, ClassLoader loader) {
        Class<?> locatorInterface;
        try {
            locatorInterface = loader.loadClass(locatorInterfaceName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String errorMessage = "Could not load the locator interface \"" + locatorInterfaceName + "\", a ClassNotFoundException was thrown: " + classNotFoundException.getLocalizedMessage() + ".";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:LOCATOR_INSTANTIATION_ERROR_INTERFACE_NOT_FOUND_EXCEPTION", 1200106L);
        }
        return locatorInterface;
    }

    protected Class<?> getServiceDefinitionInterface(ClassLoader loader) {
        Class<?> serviceDefinitionInterface;
        try {
            serviceDefinitionInterface = loader.loadClass(this.serviceDefinitionInterfaceName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String errorMessage = "Could not load the service definition interface \"" + this.serviceDefinitionInterfaceName + "\", a ClassNotFoundException was thrown: " + classNotFoundException.getLocalizedMessage() + ".";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:SERVICE_INSTANTIATION_ERROR_INTERFACE_NOT_FOUND_EXCEPTION", 1200108L);
        }
        return serviceDefinitionInterface;
    }

    protected Object getLocatorInstance(String locatorName, ClassLoader loader) {
        Object locator;
        Class<?> locatorClass;
        try {
            locatorClass = loader.loadClass(locatorName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String errorMessage = "Could not load the locator class \"" + locatorName + "\", a ClassNotFoundException was thrown: " + classNotFoundException.getLocalizedMessage() + ".";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:LOCATOR_INSTANTIATION_ERROR_LOCATOR_NOT_FOUND_EXCEPTION", 1200106L);
        }
        try {
            locator = locatorClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            String errorMessage = "Could not instantiate the locator \"" + locatorName + "\", an InstantiationException was thrown: " + instantiationException.getLocalizedMessage() + "!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:HOLDER_INSTANTIATION_ERROR_INSTANTIATION_EXCEPTION", 1200106L);
        }
        catch (IllegalAccessException illegalAccessException) {
            String errorMessage = "Could not instantiate the locator \"" + locatorName + "\", an IllegalAccessException was thrown: " + illegalAccessException.getLocalizedMessage() + "!";
            throw new ApplicationFailedException(errorMessage, "ADEPT2:GenericWebServiceExecutionEnvironment:HOLDER_INSTANTIATION_ERROR_ILLEGAL_ACCESS_EXCEPTION", 1200106L);
        }
        return locator;
    }

    @Override
    protected Object userdefinedToNativeTypedValue(UDTValue value, ProcessModelParameter parameter, boolean output) {
        return super.userdefinedToNativeTypedValue(value, parameter, output);
    }
}

