/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.codegen.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.core.codegen.PredicateEvaluationStub;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.CodeGenerator;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.UUIDTools;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DNEG;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IOR;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LDC_W;
import org.apache.bcel.generic.LDIV;
import org.apache.bcel.generic.LMUL;
import org.apache.bcel.generic.LNEG;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class DefaultCodeGenerator
implements CodeGenerator {
    protected static final Map<Class<?>, Type> typeMapping = new HashMap();
    protected static final Map<Class<?>, Class<?>> primitiveTypeMapping;
    protected InstructionList instructions;
    protected InstructionFactory factory;
    protected ClassGen classGenerator;
    protected MethodGen methodGenerator;
    protected ConstantPoolGen constants;
    protected String className;
    protected InstructionHandle lastFirstInstruction = null;

    static {
        typeMapping.put(Short.TYPE, (Type)Type.INT);
        typeMapping.put(Integer.TYPE, (Type)Type.INT);
        typeMapping.put(Long.TYPE, (Type)Type.LONG);
        typeMapping.put(Float.TYPE, (Type)Type.FLOAT);
        typeMapping.put(Double.TYPE, (Type)Type.DOUBLE);
        typeMapping.put(Byte.TYPE, (Type)Type.BYTE);
        typeMapping.put(Character.TYPE, (Type)Type.CHAR);
        typeMapping.put(Boolean.TYPE, (Type)Type.BOOLEAN);
        typeMapping.put(Short.class, (Type)new ObjectType(Integer.class.getName()));
        typeMapping.put(Integer.class, (Type)new ObjectType(Integer.class.getName()));
        typeMapping.put(Long.class, (Type)new ObjectType(Long.class.getName()));
        typeMapping.put(Float.class, (Type)new ObjectType(Float.class.getName()));
        typeMapping.put(Double.class, (Type)new ObjectType(Double.class.getName()));
        typeMapping.put(String.class, (Type)Type.STRING);
        typeMapping.put(Object.class, (Type)Type.OBJECT);
        primitiveTypeMapping = new HashMap();
        primitiveTypeMapping.put(Short.TYPE, Short.class);
        primitiveTypeMapping.put(Integer.TYPE, Integer.class);
        primitiveTypeMapping.put(Long.TYPE, Long.class);
        primitiveTypeMapping.put(Float.TYPE, Float.class);
        primitiveTypeMapping.put(Double.TYPE, Double.class);
        primitiveTypeMapping.put(Byte.TYPE, Byte.class);
        primitiveTypeMapping.put(Character.TYPE, Character.class);
        primitiveTypeMapping.put(Boolean.TYPE, Boolean.class);
        primitiveTypeMapping.put(Short.class, Short.TYPE);
        primitiveTypeMapping.put(Integer.class, Integer.TYPE);
        primitiveTypeMapping.put(Long.class, Long.TYPE);
        primitiveTypeMapping.put(Float.class, Float.TYPE);
        primitiveTypeMapping.put(Double.class, Double.TYPE);
        primitiveTypeMapping.put(Byte.class, Byte.TYPE);
        primitiveTypeMapping.put(Character.class, Character.TYPE);
        primitiveTypeMapping.put(Boolean.class, Boolean.TYPE);
    }

    public DefaultCodeGenerator() {
        ClassParser p = new ClassParser(PredicateEvaluationStub.class.getResourceAsStream("PredicateEvaluationStub.class"), "de.aristaflow.adept2.extensions.xorsupport.core.codegen.PredicateEvaluationStub");
        this.className = "PredicateEvaluation" + UUIDTools.createRandomUUID().toString().replace('-', '_');
        try {
            JavaClass c = p.parse();
            this.classGenerator = new ClassGen(c);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.constants = this.classGenerator.getConstantPool();
        this.classGenerator.setClassName(this.className);
        this.factory = new InstructionFactory(this.classGenerator);
    }

    protected static Type getType(Class<?> c) {
        if (c == null) {
            return Type.VOID;
        }
        if (typeMapping.containsKey(c)) {
            return typeMapping.get(c);
        }
        ObjectType type = new ObjectType(c.getCanonicalName());
        typeMapping.put(c, (Type)type);
        return type;
    }

    @Override
    public void addGetDataType(Class<?> type) {
        try {
            if (type.equals(Long.class)) {
                this.addGetField(CoverableDataType.class.getDeclaredField("INTEGER"));
            } else if (type.equals(Double.class)) {
                this.addGetField(CoverableDataType.class.getDeclaredField("REAL"));
            } else if (type.equals(String.class)) {
                this.addGetField(CoverableDataType.class.getDeclaredField("STRING"));
            } else if (type.equals(Boolean.class)) {
                this.addGetField(CoverableDataType.class.getDeclaredField("BOOLEAN"));
            } else if (type.equals(Date.class)) {
                this.addGetField(CoverableDataType.class.getDeclaredField("DATE"));
            } else {
                this.lastFirstInstruction = this.instructions.append((Instruction)new LDC_W(this.constants.addClass((ObjectType)DefaultCodeGenerator.getType(type))));
                this.addMethodCall(GenericUserObjectDataType.class.getDeclaredMethod("lookupDataType", Class.class));
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Method not found", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Field not found", e);
        }
    }

    @Override
    public void addGetField(Field field) {
        Object i = Modifier.isStatic(field.getModifiers()) ? this.factory.createGetStatic(field.getDeclaringClass().getCanonicalName(), field.getName(), DefaultCodeGenerator.getType(field.getType())) : this.factory.createGetField(field.getDeclaringClass().getCanonicalName(), field.getName(), DefaultCodeGenerator.getType(field.getType()));
        this.lastFirstInstruction = this.instructions.append((Instruction)i);
    }

    @Override
    public void addLoadConstant(Constant c) {
        this.addLoadConstant(c, c.getDataType().getJavaDataType());
    }

    @Override
    public void addLoadConstant(Constant c, Class<?> desiredType) {
        Class stackType = null;
        if (desiredType.equals(String.class)) {
            this.lastFirstInstruction = this.instructions.append((CompoundInstruction)new PUSH(this.constants, (String)c.getValue()));
            stackType = String.class;
        } else if (desiredType.equals(Short.TYPE) || desiredType.equals(Short.class)) {
            this.lastFirstInstruction = this.instructions.append((CompoundInstruction)new PUSH(this.constants, ((Number)c.getValue()).intValue()));
            stackType = Short.TYPE;
        } else if (desiredType.equals(Integer.TYPE) || desiredType.equals(Integer.class)) {
            this.lastFirstInstruction = this.instructions.append((CompoundInstruction)new PUSH(this.constants, ((Number)c.getValue()).intValue()));
            stackType = Integer.TYPE;
        } else if (desiredType.equals(Long.TYPE) || desiredType.equals(Long.class)) {
            this.lastFirstInstruction = this.instructions.append((CompoundInstruction)new PUSH(this.constants, ((Number)c.getValue()).longValue()));
            stackType = Long.TYPE;
        } else if (desiredType.equals(Float.TYPE) || desiredType.equals(Float.class)) {
            this.lastFirstInstruction = this.instructions.append((CompoundInstruction)new PUSH(this.constants, ((Number)c.getValue()).floatValue()));
            stackType = Float.TYPE;
        } else if (desiredType.equals(Double.TYPE) || desiredType.equals(Double.class)) {
            this.lastFirstInstruction = this.instructions.append((CompoundInstruction)new PUSH(this.constants, ((Number)c.getValue()).doubleValue()));
            stackType = Double.TYPE;
        } else if (desiredType.equals(Boolean.TYPE) || desiredType.equals(Boolean.class)) {
            this.lastFirstInstruction = this.instructions.append((CompoundInstruction)new PUSH(this.constants, ((Boolean)c.getValue()).booleanValue()));
            stackType = Boolean.TYPE;
        } else if (desiredType.equals(c.getDataType().getJavaDataType())) {
            try {
                DataType dataType = c.getDataType();
                String serial = dataType.serializeValue(c.getValue());
                this.addGetDataType(dataType.getJavaDataType());
                InstructionHandle res = this.lastFirstInstruction;
                this.instructions.append((CompoundInstruction)new PUSH(this.constants, serial));
                this.addMethodCall(DataType.class.getDeclaredMethod("deserializeValue", String.class));
                this.lastFirstInstruction = res;
                stackType = Object.class;
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        this.addCast(stackType, desiredType);
    }

    @Override
    public void addLoadVariable(Variable variable, Class<?> desiredType) {
        InstructionHandle res = this.instructions.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        this.instructions.append((CompoundInstruction)new PUSH(this.constants, variable.getName()));
        this.instructions.append((Instruction)this.factory.createInvoke(this.classGenerator.getClassName(), "getVariable", (Type)Type.OBJECT, new Type[]{Type.STRING}, (short)182));
        this.addCast(Object.class, desiredType);
        this.lastFirstInstruction = res;
    }

    @Override
    public void addCast(Class fromType, Class toType) {
        block15: {
            if (toType.isAssignableFrom(fromType)) {
                return;
            }
            if (fromType.isPrimitive()) {
                if (!toType.isPrimitive()) {
                    Class callClass;
                    Class<?> mapped = primitiveTypeMapping.get(toType);
                    if (mapped != null) {
                        this.addCast(fromType, mapped);
                        callClass = toType;
                    } else {
                        callClass = primitiveTypeMapping.get(fromType);
                        if (!toType.isAssignableFrom(callClass)) {
                            throw new IllegalArgumentException("Cannot box to this type!");
                        }
                    }
                    this.instructions.append((Instruction)this.factory.createInvoke(callClass.getCanonicalName(), "valueOf", DefaultCodeGenerator.getType(callClass), new Type[]{DefaultCodeGenerator.getType(fromType)}, (short)184));
                } else {
                    this.instructions.append(this.factory.createCast(DefaultCodeGenerator.getType(fromType), DefaultCodeGenerator.getType(toType)));
                }
            } else if (!toType.isPrimitive()) {
                this.instructions.append((Instruction)this.factory.createCheckCast((ReferenceType)DefaultCodeGenerator.getType(toType)));
            } else {
                try {
                    if (toType.equals(Integer.TYPE) || toType.equals(Long.TYPE) || toType.equals(Double.TYPE) || toType.equals(Short.TYPE) || toType.equals(Byte.TYPE)) {
                        this.addCast(fromType, Number.class);
                        InstructionHandle res = this.lastFirstInstruction;
                        this.addMethodCall(Number.class.getMethod(String.valueOf(toType.getName()) + "Value", new Class[0]));
                        this.lastFirstInstruction = res;
                        break block15;
                    }
                    if (toType.equals(Boolean.TYPE)) {
                        this.addCast(fromType, Boolean.class);
                        InstructionHandle res = this.lastFirstInstruction;
                        this.addMethodCall(Boolean.class.getMethod("booleanValue", new Class[0]));
                        this.lastFirstInstruction = res;
                        break block15;
                    }
                    throw new IllegalArgumentException("Unboxing for this data type not supported.");
                }
                catch (SecurityException securityException) {
                    throw new IllegalArgumentException("Unboxing for this data type not supported.");
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalArgumentException("Unboxing for this data type not supported.");
                }
            }
        }
    }

    @Override
    public void addMethodCall(Method m) {
        Class<?>[] params = m.getParameterTypes();
        Type[] convParams = new Type[params.length];
        short invokeMethod = 182;
        if ((m.getModifiers() & 8) != 0) {
            invokeMethod = 184;
        } else if (m.getDeclaringClass().isInterface()) {
            invokeMethod = 185;
        }
        int i = 0;
        while (i < params.length) {
            convParams[i] = DefaultCodeGenerator.getType(params[i]);
            ++i;
        }
        this.lastFirstInstruction = this.instructions.append((Instruction)this.factory.createInvoke(m.getDeclaringClass().getName(), m.getName(), DefaultCodeGenerator.getType(m.getReturnType()), convParams, invokeMethod));
    }

    @Override
    public Class<?> addPrepareOperation(DataType dataType, int times) {
        Class<?> c = dataType.getJavaDataType();
        if (c.equals(Long.class)) {
            return Long.TYPE;
        }
        if (c.equals(Double.class)) {
            return Double.TYPE;
        }
        if (c.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        this.addGetDataType(c);
        int i = 1;
        while (i < times) {
            this.instructions.append((Instruction)InstructionConstants.DUP);
            ++i;
        }
        return c;
    }

    @Override
    public void addBinaryOperation(Class<?> operandType, OperatorType opType) {
        if (!operandType.isPrimitive()) {
            InstructionHandle res = this.instructions.append((Instruction)this.factory.createGetStatic(OperatorType.class.getName(), opType.name(), DefaultCodeGenerator.getType(OperatorType.class)));
            this.instructions.append((Instruction)this.factory.createInvoke(DataType.class.getName(), "applyBinaryOperator", (Type)Type.OBJECT, new Type[]{Type.OBJECT, Type.OBJECT, DefaultCodeGenerator.getType(OperatorType.class)}, (short)182));
            this.addCast(Object.class, operandType);
            this.lastFirstInstruction = res;
        } else {
            switch (opType) {
                case OP_PLUS: {
                    if (operandType.equals(Long.TYPE)) {
                        this.lastFirstInstruction = this.instructions.append((Instruction)new LADD());
                        break;
                    }
                    if (!operandType.equals(Double.TYPE)) break;
                    this.lastFirstInstruction = this.instructions.append((Instruction)new DADD());
                    break;
                }
                case OP_MINUS: {
                    if (operandType.equals(Long.TYPE)) {
                        this.lastFirstInstruction = this.instructions.append((Instruction)new LSUB());
                        break;
                    }
                    if (!operandType.equals(Double.TYPE)) break;
                    this.lastFirstInstruction = this.instructions.append((Instruction)new DSUB());
                    break;
                }
                case OP_MULT: {
                    if (operandType.equals(Long.TYPE)) {
                        this.lastFirstInstruction = this.instructions.append((Instruction)new LMUL());
                        break;
                    }
                    if (!operandType.equals(Double.TYPE)) break;
                    this.lastFirstInstruction = this.instructions.append((Instruction)new DMUL());
                    break;
                }
                case OP_DIV: {
                    if (operandType.equals(Long.TYPE)) {
                        this.lastFirstInstruction = this.instructions.append((Instruction)new LDIV());
                        break;
                    }
                    if (!operandType.equals(Double.TYPE)) break;
                    this.lastFirstInstruction = this.instructions.append((Instruction)new DDIV());
                    break;
                }
                case OP_AND: {
                    this.lastFirstInstruction = this.instructions.append((Instruction)new IAND());
                    break;
                }
                case OP_OR: {
                    this.lastFirstInstruction = this.instructions.append((Instruction)new IOR());
                    break;
                }
                default: {
                    String msg = String.format("Unsupported operator type '%s'!", opType);
                    LoggerTools.getLogger(this).warning(msg);
                }
            }
        }
    }

    @Override
    public void addUnaryOperation(Class<?> stackType, OperatorType opType) {
        if (!stackType.isPrimitive()) {
            InstructionHandle res = this.instructions.append((Instruction)this.factory.createGetStatic(OperatorType.class.getName(), opType.name(), DefaultCodeGenerator.getType(OperatorType.class)));
            this.instructions.append((Instruction)this.factory.createInvoke(DataType.class.getName(), "applyUnaryOperator", (Type)Type.OBJECT, new Type[]{Type.OBJECT, DefaultCodeGenerator.getType(OperatorType.class)}, (short)182));
            this.addCast(Object.class, stackType);
            this.lastFirstInstruction = res;
        } else {
            switch (opType) {
                case OP_PLUS: {
                    break;
                }
                case OP_MINUS: {
                    if (stackType.equals(Long.TYPE)) {
                        this.lastFirstInstruction = this.instructions.append((Instruction)new LNEG());
                        break;
                    }
                    if (!stackType.equals(Double.TYPE)) break;
                    this.lastFirstInstruction = this.instructions.append((Instruction)new DNEG());
                    break;
                }
                case OP_NOT: {
                    this.lastFirstInstruction = this.instructions.append((Instruction)new ICONST(1));
                    this.instructions.append((Instruction)new IXOR());
                    break;
                }
                default: {
                    String msg = String.format("Unsupported operator type '%s'!", opType);
                    LoggerTools.getLogger(this).warning(msg);
                }
            }
        }
    }

    @Override
    public InstructionHandle addBranchInstruction(BranchInstruction bi) {
        return this.instructions.append(bi);
    }

    @Override
    public void addReturn(int value) {
        this.lastFirstInstruction = this.instructions.append((CompoundInstruction)new PUSH(this.constants, value));
        this.instructions.append((Instruction)InstructionFactory.createReturn((Type)Type.INT));
    }

    @Override
    public int createLocalVariable(Class<?> type, String name) {
        LocalVariableGen lvg = this.methodGenerator.addLocalVariable(name, DefaultCodeGenerator.getType(type), null, null);
        return lvg.getIndex();
    }

    @Override
    public void addGetArray(int index, Class<?> type) {
        this.lastFirstInstruction = this.instructions.append((CompoundInstruction)new PUSH(this.constants, index));
        this.instructions.append((Instruction)InstructionFactory.createArrayLoad((Type)DefaultCodeGenerator.getType(type)));
    }

    @Override
    public void addGetLocalVariable(int variableIndex, Class<?> type) {
        this.lastFirstInstruction = this.instructions.append((Instruction)InstructionFactory.createLoad((Type)DefaultCodeGenerator.getType(type), (int)variableIndex));
    }

    @Override
    public void addSetLocalVariable(int variableIndex, Class<?> type) {
        this.lastFirstInstruction = this.instructions.append((Instruction)InstructionFactory.createStore((Type)DefaultCodeGenerator.getType(type), (int)variableIndex));
    }

    @Override
    public void addNOP() {
        this.lastFirstInstruction = this.instructions.append(InstructionConstants.NOP);
    }

    @Override
    public BranchInstruction addNullCheck(Variable var) {
        this.addLoadVariable(var, Object.class);
        IFNULL rv = new IFNULL(null);
        this.instructions.append((BranchInstruction)rv);
        return rv;
    }

    @Override
    public void writeEvaluateLeftHandSide(List<Expression> expressions) {
        org.apache.bcel.classfile.Method leftSide = null;
        org.apache.bcel.classfile.Method[] methodArray = this.classGenerator.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.apache.bcel.classfile.Method m = methodArray[n2];
            if (m.getName().equals("evaluateLeftHandSide")) {
                leftSide = m;
                break;
            }
            ++n2;
        }
        if (leftSide == null) {
            throw new RuntimeException("Cannot find evaluateLeftHandSide method");
        }
        this.classGenerator.removeMethod(leftSide);
        this.methodGenerator = new MethodGen(leftSide, this.classGenerator.getClassName(), this.constants);
        this.instructions = new InstructionList();
        this.methodGenerator.setInstructionList(this.instructions);
        this.instructions.append((CompoundInstruction)new PUSH(this.constants, expressions.size()));
        this.instructions.append(this.factory.createNewArray((Type)Type.OBJECT, (short)1));
        ArrayList<BranchInstruction> nullHandlerJumps = new ArrayList<BranchInstruction>();
        int i = 0;
        while (i < expressions.size()) {
            this.instructions.append((Instruction)InstructionConstants.DUP);
            this.instructions.append((CompoundInstruction)new PUSH(this.constants, i));
            Expression ex = expressions.get(i);
            nullHandlerJumps.clear();
            for (Variable var : ex.getLHSVariables()) {
                nullHandlerJumps.add(this.addNullCheck(var));
            }
            ex.getLeftHandSide().makeRunnable().writeCode(this, ex.getDataType().getJavaDataType());
            GOTO storeJump = new GOTO(null);
            this.instructions.append((BranchInstruction)storeJump);
            InstructionHandle ih = this.instructions.append(InstructionConstants.ACONST_NULL);
            for (BranchInstruction bi : nullHandlerJumps) {
                bi.setTarget(ih);
            }
            ih = this.instructions.append((Instruction)InstructionConstants.AASTORE);
            storeJump.setTarget(ih);
            ++i;
        }
        this.instructions.append((Instruction)InstructionFactory.createReturn((Type)DefaultCodeGenerator.getType(Object[].class)));
        this.methodGenerator.stripAttributes(true);
        this.methodGenerator.setMaxStack();
        this.methodGenerator.setMaxLocals();
        this.classGenerator.addMethod(this.methodGenerator.getMethod());
        this.instructions.dispose();
        this.instructions = null;
        this.methodGenerator = null;
    }

    @Override
    public void writeEvaluateDecisionID(BranchTreeManager treeManager) {
        org.apache.bcel.classfile.Method leftSide = null;
        org.apache.bcel.classfile.Method[] methodArray = this.classGenerator.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.apache.bcel.classfile.Method m = methodArray[n2];
            if (m.getName().equals("evaluateDecisionID")) {
                leftSide = m;
                break;
            }
            ++n2;
        }
        if (leftSide == null) {
            throw new RuntimeException("Cannot find evaluateDecisionID method");
        }
        this.classGenerator.removeMethod(leftSide);
        this.methodGenerator = new MethodGen(leftSide, this.classGenerator.getClassName(), this.constants);
        this.instructions = new InstructionList();
        this.methodGenerator.setInstructionList(this.instructions);
        treeManager.writeCode(this);
        this.methodGenerator.stripAttributes(true);
        this.methodGenerator.setMaxStack();
        this.methodGenerator.setMaxLocals();
        this.classGenerator.addMethod(this.methodGenerator.getMethod());
        this.instructions.dispose();
        this.instructions = null;
        this.methodGenerator = null;
    }

    @Override
    public void finalizeClass(OutputStream out) {
        try {
            this.classGenerator.getJavaClass().dump(out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public InstructionHandle getLastFirstInstruction() {
        return this.lastFirstInstruction;
    }
}

