/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.covercheck;

import de.aristaflow.adept2.extensions.xorsupport.core.covercheck.CoverageError;
import de.aristaflow.adept2.extensions.xorsupport.core.covercheck.CoverageErrorType;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.AtomicElement;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Interval;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ExpressionType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class CoverCheck {
    public static List<CoverageError> checkCoverage(Expression ex) {
        CoverableDataType dataType;
        ArrayList<CoverageError> result = new ArrayList<CoverageError>();
        if (!CoverCheck.arePredicatesConsistent(ex, result)) {
            return result;
        }
        BranchTreeManager.VariableOrderResult orderResult = ex.getTreeManager().calculateGlobalVariableOrdering();
        if (!orderResult.success) {
            result.add(new CoverageError(null, null, CoverageErrorType.CYCLIC_VARIABLE_ORDERING));
        }
        boolean checkVarConstraint = (dataType = ex.getDataType()).getSupportedPredicateMap().get((Object)ex.getType()).contains((Object)PredicateType.CONSTRAINT_NOT_SATISFIED) && ex.getVariableOrder().size() > 1;
        ArrayList<Predicate> varConstraintCoveringPredicates = new ArrayList<Predicate>();
        ArrayList<Predicate> nullCoveringPredicates = new ArrayList<Predicate>();
        LinkedList<InternalInterval> coveredIntervals = new LinkedList<InternalInterval>();
        coveredIntervals.add(new InternalInterval(dataType.getMinValue(), true));
        coveredIntervals.add(new InternalInterval(dataType.getMaxValue(), false));
        Comparator<Object> comp = dataType.getComparator();
        for (Predicate pred : ex.getPredicates()) {
            if (pred.getType() == PredicateType.IS_NULL) {
                nullCoveringPredicates.add(pred);
                continue;
            }
            if (pred.getType() == PredicateType.CONSTRAINT_NOT_SATISFIED) {
                varConstraintCoveringPredicates.add(pred);
                continue;
            }
            Interval[] intervalArray = pred.getCoveredIntervals();
            int n = intervalArray.length;
            int n2 = 0;
            while (n2 < n) {
                Interval intvl = intervalArray[n2];
                ListIterator<InternalInterval> iter = coveredIntervals.listIterator();
                InternalInterval I_j = (InternalInterval)iter.next();
                AtomicElement lowerBound = intvl.getLowerBound();
                AtomicElement upperBound = intvl.getUpperBound();
                boolean intvl_lowerBoundIncluded = intvl.isLowerBoundIncluded();
                while (true) {
                    InternalInterval I_j1 = (InternalInterval)iter.next();
                    int lbComp = comp.compare(I_j.leftBorder.getValue(), lowerBound.getValue());
                    int comp2 = comp.compare(I_j1.leftBorder.getValue(), lowerBound.getValue());
                    if (lbComp <= 0 && (comp2 > 0 || comp2 == 0 && intvl_lowerBoundIncluded && !I_j1.isBorderIncluded)) {
                        boolean I_j_upperBoundIncluded;
                        iter.previous();
                        iter.previous();
                        iter.next();
                        if (lbComp < 0 || lbComp == 0 && !intvl_lowerBoundIncluded && I_j.isBorderIncluded) {
                            iter.add(new InternalInterval(lowerBound, intvl_lowerBoundIncluded, pred, I_j.coveredBy));
                        } else if (lbComp == 0 && intvl_lowerBoundIncluded == I_j.isBorderIncluded) {
                            iter.set(new InternalInterval(lowerBound, I_j.isBorderIncluded, pred, I_j.coveredBy));
                        } else assert (false);
                        int ubComp = comp.compare(I_j1.leftBorder.getValue(), upperBound.getValue());
                        boolean bl = I_j_upperBoundIncluded = !I_j1.isBorderIncluded;
                        if (ubComp > 0 || ubComp == 0 && I_j_upperBoundIncluded && !intvl.isUpperBoundIncluded()) {
                            iter.add(new InternalInterval(upperBound, !intvl.isUpperBoundIncluded(), null, I_j.coveredBy));
                            break;
                        }
                        if (ubComp == 0 && I_j_upperBoundIncluded == intvl.isUpperBoundIncluded()) break;
                        lowerBound = I_j1.leftBorder;
                        intvl_lowerBoundIncluded = I_j1.isBorderIncluded;
                        iter.next();
                    }
                    I_j = I_j1;
                }
                ++n2;
            }
        }
        ListIterator li = coveredIntervals.listIterator();
        InternalInterval ii = (InternalInterval)li.next();
        while (li.hasNext()) {
            Interval covered;
            InternalInterval ii_next = (InternalInterval)li.next();
            int coverSize = ii.coveredBy.size();
            if (coverSize != 1 && (covered = dataType.makeInterval(ii.leftBorder, ii_next.leftBorder, ii.isBorderIncluded, !ii_next.isBorderIncluded)) != null) {
                if (coverSize == 0) {
                    result.add(new CoverageError(covered, null, CoverageErrorType.INTERVAL_NOT_COVERED));
                } else if (coverSize > 1) {
                    result.add(new CoverageError(covered, ii.coveredBy.toArray(new Predicate[coverSize]), CoverageErrorType.INTERVAL_COVERED_TWICE));
                }
            }
            ii = ii_next;
        }
        boolean exprCanBeNull = ex.getLeftHandSide().canBeNull();
        if (exprCanBeNull) {
            if (nullCoveringPredicates.size() == 0) {
                result.add(new CoverageError(null, null, CoverageErrorType.NULL_NOT_COVERED));
            } else if (nullCoveringPredicates.size() > 1) {
                result.add(new CoverageError(null, nullCoveringPredicates.toArray(new Predicate[nullCoveringPredicates.size()]), CoverageErrorType.NULL_COVERED_TWICE));
            }
        } else if (nullCoveringPredicates.size() > 0) {
            result.add(new CoverageError(null, nullCoveringPredicates.toArray(new Predicate[nullCoveringPredicates.size()]), CoverageErrorType.NULL_CHECK_NOT_NECESSARY));
        }
        if (checkVarConstraint) {
            if (varConstraintCoveringPredicates.size() == 0) {
                result.add(new CoverageError(null, null, CoverageErrorType.VARCONSTRAINT_NOT_COVERED));
            } else if (varConstraintCoveringPredicates.size() > 1) {
                result.add(new CoverageError(null, varConstraintCoveringPredicates.toArray(new Predicate[varConstraintCoveringPredicates.size()]), CoverageErrorType.VARCONSTRAINT_COVERED_TWICE));
            }
        } else if (varConstraintCoveringPredicates.size() > 0) {
            result.add(new CoverageError(null, varConstraintCoveringPredicates.toArray(new Predicate[varConstraintCoveringPredicates.size()]), CoverageErrorType.VARCONSTRAINT_NOT_NECESSARY));
        }
        return result;
    }

    protected static boolean arePredicatesConsistent(Expression ex, List<CoverageError> resultList) {
        if (ex == null) {
            resultList.add(new CoverageError(null, null, CoverageErrorType.INVALID_EXPRESSION_TYPE));
            return false;
        }
        CoverableDataType dataType = ex.getDataType();
        Comparator<Object> comp = dataType.getComparator();
        ExpressionType eType = ex.getType();
        if (!dataType.getSupportedExpressionTypes().contains((Object)eType)) {
            resultList.add(new CoverageError(null, null, CoverageErrorType.INVALID_EXPRESSION_TYPE));
            return false;
        }
        Set<PredicateType> supportedPreds = dataType.getSupportedPredicateMap().get((Object)eType);
        ArrayList<Predicate> invalidPreds = new ArrayList<Predicate>();
        block6: for (Predicate pred : ex.getPredicates()) {
            PredicateType predType = pred.getType();
            if (supportedPreds.contains((Object)predType)) {
                AtomicElement lBound = pred.getLowerBound();
                AtomicElement uBound = pred.getUpperBound();
                if (!eType.isConstantComparison()) {
                    if (predType.getNumberOfConstants() >= 1) {
                        if (lBound == null) {
                            invalidPreds.add(pred);
                            continue;
                        }
                        if (!(lBound instanceof Variable) && !lBound.equals(dataType.getMinValue())) {
                            invalidPreds.add(pred);
                            continue;
                        }
                        if (!dataType.isDataTypeCompatible(lBound.getDataType())) {
                            invalidPreds.add(pred);
                            continue;
                        }
                    }
                    if (predType.getNumberOfConstants() >= 2) {
                        if (uBound == null) {
                            invalidPreds.add(pred);
                            continue;
                        }
                        if (!(uBound instanceof Variable) && !uBound.equals(dataType.getMaxValue())) {
                            invalidPreds.add(pred);
                            continue;
                        }
                        if (!dataType.isDataTypeCompatible(uBound.getDataType())) {
                            invalidPreds.add(pred);
                            continue;
                        }
                    }
                    switch (predType) {
                        case IN_INTERVAL: 
                        case NOTIN_INTERVAL: {
                            Variable var1 = (Variable)lBound;
                            Variable var2 = (Variable)uBound;
                            if (var1.getName().equals(var2.getName())) {
                                if (pred.isLowerBoundIncluded() && pred.isUpperBoundIncluded()) continue block6;
                                invalidPreds.add(pred);
                                break;
                            }
                            if (var1.getTopologicalPosition() <= var2.getTopologicalPosition()) continue block6;
                            resultList.add(new CoverageError(null, null, CoverageErrorType.INVALID_VARIABLE_POS));
                            return false;
                        }
                    }
                    continue;
                }
                if (predType.getNumberOfConstants() >= 1) {
                    if (lBound == null || !(lBound instanceof Constant)) {
                        invalidPreds.add(pred);
                        continue;
                    }
                    if (!dataType.isDataTypeCompatible(lBound.getDataType())) {
                        invalidPreds.add(pred);
                        continue;
                    }
                }
                if (predType.getNumberOfConstants() >= 2) {
                    if (uBound == null || !(uBound instanceof Constant)) {
                        invalidPreds.add(pred);
                        continue;
                    }
                    if (!dataType.isDataTypeCompatible(uBound.getDataType())) {
                        invalidPreds.add(pred);
                        continue;
                    }
                }
                switch (predType) {
                    case IN_INTERVAL: 
                    case NOTIN_INTERVAL: {
                        int compRes = comp.compare(lBound.getValue(), uBound.getValue());
                        if (compRes <= 0 && (compRes != 0 || pred.isLowerBoundIncluded() && pred.isUpperBoundIncluded())) continue block6;
                        invalidPreds.add(pred);
                        break;
                    }
                    default: {
                        String msg = String.format("Unused predicate type '%s'!", new Object[]{predType});
                        LoggerTools.getLogger(CoverCheck.class).finer(msg);
                        break;
                    }
                }
                continue;
            }
            invalidPreds.add(pred);
        }
        if (invalidPreds.size() > 0) {
            resultList.add(new CoverageError(null, invalidPreds.toArray(new Predicate[invalidPreds.size()]), CoverageErrorType.INVALID_PREDICATES));
            return false;
        }
        return true;
    }

    private static class InternalInterval {
        public AtomicElement leftBorder;
        public boolean isBorderIncluded;
        public List<Predicate> coveredBy;

        public InternalInterval(AtomicElement leftBorder, boolean isBorderIncluded) {
            this.leftBorder = leftBorder;
            this.isBorderIncluded = isBorderIncluded;
            this.coveredBy = new ArrayList<Predicate>();
        }

        public InternalInterval(AtomicElement leftBorder, boolean isBorderIncluded, Predicate newPredicate, List<Predicate> oldPredicates) {
            this(leftBorder, isBorderIncluded);
            this.coveredBy.addAll(oldPredicates);
            if (newPredicate != null) {
                this.coveredBy.add(newPredicate);
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            if (this.isBorderIncluded) {
                s.append("[");
            } else {
                s.append("(");
            }
            s.append(this.leftBorder);
            return s.toString();
        }
    }
}

