/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.covercheck;

import de.aristaflow.adept2.extensions.xorsupport.core.covercheck.CoverageErrorType;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Interval;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;

public class CoverageError {
    protected Interval affectedInterval;
    protected Predicate[] affectedPredicates;
    protected CoverageErrorType errorType;

    public CoverageError(Interval affectedInterval, Predicate[] affectedPredicates, CoverageErrorType type) {
        this.affectedInterval = affectedInterval;
        if (affectedPredicates != null) {
            this.affectedPredicates = (Predicate[])affectedPredicates.clone();
        }
        this.errorType = type;
        if (affectedInterval != null && affectedInterval.getLowerBound().getValue().equals(affectedInterval.getUpperBound().getValue())) {
            if (type == CoverageErrorType.INTERVAL_NOT_COVERED) {
                this.errorType = CoverageErrorType.VALUE_NOT_COVERED;
            } else if (type == CoverageErrorType.INTERVAL_COVERED_TWICE) {
                this.errorType = CoverageErrorType.VALUE_COVERED_TWICE;
            }
        }
    }

    public Interval getAffectedInterval() {
        return this.affectedInterval;
    }

    public CoverageErrorType getErrorType() {
        return this.errorType;
    }

    public Predicate[] getAffectedPredicates() {
        Predicate[] ret = null;
        if (this.affectedPredicates != null) {
            ret = (Predicate[])this.affectedPredicates.clone();
        }
        return ret;
    }

    public String getErrorMessage() {
        return String.format(this.errorType.getMessage(), this.affectedInterval, this.affectedPredicates == null ? Integer.valueOf(0) : Integer.valueOf(this.affectedPredicates.length));
    }

    public String toString() {
        return this.getErrorMessage();
    }
}

