/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultConstant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.ArithmeticExpression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.CodeGenerator;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.SubExpression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.bcel.generic.InstructionHandle;

public class DefaultArithmeticExpression
implements ArithmeticExpression {
    protected static boolean updatePrecedences = true;
    protected List<OperatorType> operators = new ArrayList<OperatorType>();
    protected List<SubExpression> subExpressions = new ArrayList<SubExpression>();

    @Override
    public SubExpression makeRunnable() {
        int index = 0;
        int exprStart = -1;
        SubExpression newSubExpression = null;
        if (updatePrecedences) {
            while (index <= this.operators.size()) {
                SubExpression ex = this.subExpressions.get(index);
                ex = ex.makeRunnable();
                this.subExpressions.set(index, ex);
                if (index < this.operators.size()) {
                    OperatorType op = this.operators.get(index);
                    if (op == OperatorType.OP_MULT || op == OperatorType.OP_DIV || op == OperatorType.OP_AND) {
                        if (newSubExpression == null) {
                            newSubExpression = new DefaultArithmeticExpression();
                            exprStart = index;
                            newSubExpression.getSubExpressions().add(ex);
                        }
                        newSubExpression.getSubExpressions().add(this.subExpressions.get(index + 1));
                        newSubExpression.getOperators().add(op);
                        this.subExpressions.remove(index + 1);
                        this.operators.remove(index);
                        continue;
                    }
                    ++index;
                    if (newSubExpression != null) {
                        updatePrecedences = false;
                        this.subExpressions.set(exprStart, newSubExpression.makeRunnable());
                        updatePrecedences = true;
                    }
                    newSubExpression = null;
                    continue;
                }
                ++index;
            }
            if (newSubExpression != null) {
                updatePrecedences = false;
                this.subExpressions.set(exprStart, newSubExpression.makeRunnable());
                updatePrecedences = true;
            }
        }
        index = 1;
        int lastConstantIdx = -1;
        if (this.subExpressions.get(0) instanceof Constant) {
            lastConstantIdx = 0;
        }
        while (index <= this.operators.size()) {
            SubExpression ex = this.subExpressions.get(index);
            if (ex instanceof Constant) {
                OperatorType op = this.operators.get(index - 1);
                if (op != OperatorType.OP_DIV) {
                    if (lastConstantIdx == -1) {
                        lastConstantIdx = index++;
                        continue;
                    }
                    this.subExpressions.set(lastConstantIdx, new DefaultConstant((CoverableDataType)this.getDataType(), this.getDataType().applyBinaryOperator(this.subExpressions.get(lastConstantIdx).getValue(), ex.getValue(), op)));
                    this.subExpressions.remove(index);
                    this.operators.remove(index - 1);
                    continue;
                }
                lastConstantIdx = -1;
                ++index;
                continue;
            }
            ++index;
        }
        if (this.subExpressions.size() == 1) {
            return this.subExpressions.get(0);
        }
        return this;
    }

    @Override
    public List<OperatorType> getOperators() {
        return this.operators;
    }

    @Override
    public List<SubExpression> getSubExpressions() {
        return this.subExpressions;
    }

    @Override
    public DataType getDataType() {
        if (this.subExpressions.size() > 0) {
            return this.subExpressions.get(0).getDataType();
        }
        return null;
    }

    @Override
    public int getNumberOfElements() {
        return this.subExpressions.size();
    }

    @Override
    public Object getValue() {
        if (this.subExpressions.size() == 0) {
            return null;
        }
        Object value = this.subExpressions.get(0).getValue();
        int i = 1;
        while (i < this.subExpressions.size()) {
            value = this.getDataType().applyBinaryOperator(value, this.subExpressions.get(i).getValue(), this.operators.get(i - 1));
            ++i;
        }
        return value;
    }

    public String toString() {
        if (this.subExpressions.size() == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < this.subExpressions.size()) {
            SubExpression ex = this.subExpressions.get(i);
            if (ex instanceof ArithmeticExpression) {
                s.append("(");
            }
            s.append(ex);
            if (ex instanceof ArithmeticExpression) {
                s.append(")");
            }
            if (i < this.subExpressions.size() - 1) {
                s.append(this.operators.get(i));
            }
            ++i;
        }
        return s.toString();
    }

    @Override
    public void determineUsedVariables(Set<Variable> vars) {
        for (SubExpression ex : this.subExpressions) {
            ex.determineUsedVariables(vars);
        }
    }

    @Override
    public InstructionHandle writeCode(CodeGenerator gen, Class<?> desiredReturnType) {
        if (this.subExpressions.size() == 0) {
            return null;
        }
        Class<?> stackType = gen.addPrepareOperation(this.getDataType(), this.operators.size());
        InstructionHandle ih = gen.getLastFirstInstruction();
        this.subExpressions.get(0).writeCode(gen, stackType);
        int i = 1;
        while (i < this.subExpressions.size()) {
            this.subExpressions.get(i).writeCode(gen, stackType);
            gen.addBinaryOperation(stackType, this.operators.get(i - 1));
            ++i;
        }
        gen.addCast(stackType, desiredReturnType);
        return ih;
    }

    @Override
    public boolean canBeNull() {
        for (SubExpression ex : this.subExpressions) {
            if (!ex.canBeNull()) continue;
            return true;
        }
        return false;
    }
}

