/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.core.covercheck.CoverCheck;
import de.aristaflow.adept2.extensions.xorsupport.core.covercheck.CoverageError;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultBranchTreeNode;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultDecisionID;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultExpression;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultVariableManager;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.ExpressionList;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.RootTreeNode;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.ParserException;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeNode;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.CodeGenerator;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.DecisionID;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.TreeChangeListener;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.VariableManager;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ExpressionType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.xml.DeserializeException;
import de.aristaflow.adept2.extensions.xorsupport.model.xml.XORXMLConstants;
import de.aristaflow.adept2.extensions.xorsupport.util.Graph;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.InstructionHandle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultBranchTreeManager
implements BranchTreeManager {
    protected static final String E_UNASSIGNED_DECISION_PATHS = "There is 1 decision path that is not associated with a decision ID";
    protected static final String E_UNASSIGNED_DECISION_PATH = "There are %s decision path that are not associated with a decision ID";
    protected static final String E_DECISION_IDS_WITHOUT_PREDICATE = "%s decision IDs are not assigned to any predicate combination.";
    protected static final String E_DECISION_ID_WITHOUT_PREDICATE = "1 decision ID is not assigned to any predicate combination.";
    protected static final String W_UNUSED_INPUT_PARAMETER = "The input parameter %s is never used in the decision activity";
    protected static final String E_COVERAGE_ERROR = "Coverage error in dimension %s: %s";
    protected static final String E_UNKNOWN_DATA_TYPE = "Unknown variable data type: %s";
    protected static final String E_SYNTAX_ERROR = "Syntax error in left-hand side expression: %s";
    protected static final String CHECK_ID = "XOR decision check";
    protected static final String E_INVALID_XML = "The XML configuration is not valid:\n";
    protected static final String E_GENERAL_ERROR = "The XML configuration could not be read correctly:\n";
    public static final String STRING_EXCLUSION_PREDICATES = "Exclusion predicates";
    public static final String STRING_PREDICATES = "Predicates";
    protected DecisionActivity activity;
    protected Node node;
    protected List<Expression> expressionList = new ExpressionList(this);
    protected RootTreeNode overallRoot;
    protected RootTreeNode exclusionRoot;
    protected RootTreeNode branchTreeRoot;
    protected VariableManager variables = new DefaultVariableManager(this);
    protected List<TreeChangeListener> changeListeners;
    protected Set<DecisionID> availableDecisionIDs;
    protected long idCounter = 0L;
    protected int decisionIDCounter = 0;
    protected boolean noTreeUpdates = false;
    protected boolean hadLoadError = false;

    public DefaultBranchTreeManager(DecisionActivity activity, Node node, Template template) {
        this(activity, node, template, null);
    }

    public DefaultBranchTreeManager(DecisionActivity activity, Node node, Template template, CheckReport report) {
        this();
        this.activity = activity;
        this.node = node;
        if (activity != null) {
            for (ProcessModelParameter p : activity.getParameters(ActivityConstants.AccessType.READ)) {
                this.variables.addVariable(p.getName(), DataType.getDataTypeFromAdeptDataType(p.getDataType(), p.getUDTName()), p.isOptional());
            }
            long[] lArray = activity.getDecisionIDs();
            int n = lArray.length;
            int n2 = 0;
            while (n2 < n) {
                long id = lArray[n2];
                this.availableDecisionIDs.add(new DefaultDecisionID(this, (int)id, activity.getDecisionLabel(id)));
                ++n2;
            }
            if (activity.getConfiguration().getString("DECISION_XML") != null) {
                try {
                    this.deserializeFromXML(new StringReader(activity.getConfiguration().getString("DECISION_XML")), false, report);
                }
                catch (DeserializeException ex) {
                    if (report != null) {
                        report.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, E_GENERAL_ERROR + ex.getMessage(), ProcessElementIdentifierTools.getNodeIdentifier(report.getBase(), this.node));
                        this.hadLoadError = true;
                        return;
                    }
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public DefaultBranchTreeManager() {
        this.overallRoot = new RootTreeNode(this, null, "");
        this.exclusionRoot = new RootTreeNode(this, this.overallRoot, STRING_EXCLUSION_PREDICATES);
        this.branchTreeRoot = new RootTreeNode(this, this.overallRoot, STRING_PREDICATES);
        this.overallRoot.getChildren().add(this.exclusionRoot);
        this.overallRoot.getChildren().add(this.branchTreeRoot);
        this.changeListeners = new ArrayList<TreeChangeListener>();
        this.availableDecisionIDs = new TreeSet<DecisionID>();
    }

    @Override
    public List<Expression> getExpressionList() {
        return this.expressionList;
    }

    protected void buildDecisionTree(BranchTreeNode node, int exprIdx) {
        Expression ex = this.expressionList.get(exprIdx);
        boolean isLeaf = this.expressionList.size() == exprIdx + 1;
        for (Predicate p : ex.getPredicates()) {
            if (p.isExclusionPredicate()) continue;
            DefaultBranchTreeNode newNode = new DefaultBranchTreeNode(this, node, p, DecisionID.UNASSIGNED);
            node.getChildren().add(newNode);
            if (isLeaf) continue;
            this.buildDecisionTree(newNode, exprIdx + 1);
        }
    }

    protected void getNodesAtLevel(List<BranchTreeNode> resultList, Predicate filter, BranchTreeNode node, int levelRemaining) {
        if (levelRemaining == 0) {
            if (filter != null) {
                for (BranchTreeNode child : node.getChildren()) {
                    if (!filter.equals(child.getPredicate())) continue;
                    resultList.add(child);
                }
            } else {
                resultList.addAll(node.getChildren());
            }
        } else {
            for (BranchTreeNode child : node.getChildren()) {
                this.getNodesAtLevel(resultList, filter, child, levelRemaining - 1);
            }
        }
    }

    protected void insertPredicateAtLevel(BranchTreeNode node, List<BranchTreeNode> resultList, Predicate pred, int exprIdx, int level) {
        if (exprIdx == level) {
            DefaultBranchTreeNode newChild = new DefaultBranchTreeNode(this, node, pred, DecisionID.UNASSIGNED);
            node.getChildren().add(newChild);
            resultList.add(newChild);
            if (exprIdx + 1 != this.expressionList.size()) {
                this.buildDecisionTree(newChild, exprIdx + 1);
            }
        } else {
            for (BranchTreeNode child : node.getChildren()) {
                this.insertPredicateAtLevel(child, resultList, pred, exprIdx + 1, level);
            }
        }
    }

    protected void deletePredicateAtLevel(BranchTreeNode node, List<BranchTreeNode> resultList, Predicate pred, int exprIdx, int level) {
        if (exprIdx == level) {
            for (BranchTreeNode child : node.getChildren()) {
                if (pred != child.getPredicate()) continue;
                node.getChildren().remove(child);
                resultList.add(child);
                break;
            }
        } else {
            for (BranchTreeNode child : node.getChildren()) {
                this.deletePredicateAtLevel(child, resultList, pred, exprIdx + 1, level);
            }
        }
    }

    protected void getPredicatePaths(BranchTreeNode current, Stack<BranchTreeNode> path, List<BranchTreeNode[]> result, DecisionID id) {
        path.push(current);
        if (current.getChildren().size() == 0) {
            if (id == null || current.getDecisionID().equals(id)) {
                BranchTreeNode[] resultEntry = new BranchTreeNode[path.size()];
                path.toArray(resultEntry);
                result.add(resultEntry);
            }
        } else {
            for (BranchTreeNode c : current.getChildren()) {
                this.getPredicatePaths(c, path, result, id);
            }
        }
        path.pop();
    }

    protected void notifyChangeListeners(TreeChangeListener.TreeChangeKind changeKind, List<BranchTreeNode> affectedNodes) {
        for (TreeChangeListener cl : this.changeListeners) {
            cl.treeChanged(changeKind, affectedNodes);
        }
    }

    @Override
    public void addPredicate(Predicate p) {
        if (this.noTreeUpdates) {
            return;
        }
        ArrayList<BranchTreeNode> resultList = new ArrayList<BranchTreeNode>();
        if (!p.isExclusionPredicate()) {
            int level = this.expressionList.indexOf(p.getParent());
            this.insertPredicateAtLevel(this.branchTreeRoot, resultList, p, 0, level);
        } else {
            DefaultBranchTreeNode newChild = new DefaultBranchTreeNode(this, this.exclusionRoot, p, DecisionID.UNASSIGNED);
            this.exclusionRoot.getChildren().add(newChild);
            resultList.add(newChild);
        }
        this.notifyChangeListeners(TreeChangeListener.TreeChangeKind.SUBTREE_ADDED, resultList);
    }

    @Override
    public void deletePredicate(Predicate p) {
        if (this.noTreeUpdates) {
            return;
        }
        ArrayList<BranchTreeNode> resultList = new ArrayList<BranchTreeNode>();
        if (!p.isExclusionPredicate()) {
            int level = this.expressionList.indexOf(p.getParent());
            this.deletePredicateAtLevel(this.branchTreeRoot, resultList, p, 0, level);
        } else {
            for (BranchTreeNode n : this.exclusionRoot.getChildren()) {
                if (n.getPredicate() != p) continue;
                this.exclusionRoot.getChildren().remove(n);
                resultList.add(n);
                break;
            }
        }
        this.notifyChangeListeners(TreeChangeListener.TreeChangeKind.SUBTREE_REMOVED, resultList);
    }

    @Override
    public void swapExpressions(int[] newOrder) {
        ArrayList<BranchTreeNode[]> paths = new ArrayList<BranchTreeNode[]>();
        this.getPredicatePaths(this.branchTreeRoot, new Stack<BranchTreeNode>(), paths, null);
        Expression[] newList = new Expression[this.expressionList.size()];
        int i = 0;
        while (i < this.expressionList.size()) {
            newList[i] = this.expressionList.get(newOrder[i]);
            ++i;
        }
        this.noTreeUpdates = true;
        this.expressionList.clear();
        this.expressionList.addAll(Arrays.asList(newList));
        this.internalRebuildTree(false);
        for (BranchTreeNode[] path : paths) {
            BranchTreeNode current = this.branchTreeRoot;
            int i2 = 0;
            while (i2 <= newOrder.length) {
                if (current.getChildren().size() == 0) {
                    current.setDecisionID(path[path.length - 1].getDecisionID(), false);
                } else {
                    Predicate requestedPredicate = path[newOrder[i2] + 1].getPredicate();
                    for (BranchTreeNode child : current.getChildren()) {
                        if (child.getPredicate() != requestedPredicate) continue;
                        current = child;
                        break;
                    }
                }
                ++i2;
            }
        }
        this.noTreeUpdates = false;
        List<BranchTreeNode> emptyList = Collections.emptyList();
        this.notifyChangeListeners(TreeChangeListener.TreeChangeKind.TREE_REBUILT, emptyList);
    }

    @Override
    public List<BranchTreeNode[]> getBranchTreePaths(DecisionID id) {
        ArrayList<BranchTreeNode[]> result = new ArrayList<BranchTreeNode[]>();
        for (BranchTreeNode n : this.exclusionRoot.getChildren()) {
            if (!n.getDecisionID().equals(id)) continue;
            result.add(new BranchTreeNode[]{this.exclusionRoot, n});
        }
        this.getPredicatePaths(this.branchTreeRoot, new Stack<BranchTreeNode>(), result, id);
        return result;
    }

    @Override
    public void expressionUpdated(Expression expression) {
        if (this.noTreeUpdates) {
            return;
        }
        ArrayList<BranchTreeNode> resultList = new ArrayList<BranchTreeNode>();
        int level = this.expressionList.indexOf(expression);
        this.getNodesAtLevel(resultList, null, this.branchTreeRoot, level);
        for (BranchTreeNode btn : this.exclusionRoot.getChildren()) {
            if (btn.getPredicate().getParent() != expression) continue;
            resultList.add(btn);
        }
        this.notifyChangeListeners(TreeChangeListener.TreeChangeKind.NODE_UPDATED, resultList);
    }

    @Override
    public void predicateUpdated(Predicate predicate) {
        if (this.noTreeUpdates) {
            return;
        }
        ArrayList<BranchTreeNode> resultList = new ArrayList<BranchTreeNode>();
        if (predicate.isExclusionPredicate()) {
            this.getNodesAtLevel(resultList, predicate, this.exclusionRoot, 0);
        } else {
            int level = this.expressionList.indexOf(predicate.getParent());
            this.getNodesAtLevel(resultList, predicate, this.branchTreeRoot, level);
        }
        this.notifyChangeListeners(TreeChangeListener.TreeChangeKind.NODE_UPDATED, resultList);
    }

    protected void internalRebuildTree(boolean rebuildExclusion) {
        this.branchTreeRoot.getChildren().clear();
        if (this.expressionList.size() > 0) {
            this.buildDecisionTree(this.branchTreeRoot, 0);
        }
        if (rebuildExclusion) {
            this.exclusionRoot.getChildren().clear();
            for (Expression ex : this.expressionList) {
                for (Predicate p : ex.getPredicates()) {
                    if (!p.isExclusionPredicate()) continue;
                    DefaultBranchTreeNode newNode = new DefaultBranchTreeNode(this, this.exclusionRoot, p, DecisionID.UNASSIGNED);
                    this.exclusionRoot.getChildren().add(newNode);
                }
            }
        }
    }

    @Override
    public void rebuildTree() {
        if (this.noTreeUpdates) {
            return;
        }
        this.internalRebuildTree(true);
        List<BranchTreeNode> emptyList = Collections.emptyList();
        this.notifyChangeListeners(TreeChangeListener.TreeChangeKind.TREE_REBUILT, emptyList);
    }

    @Override
    public BranchTreeNode getBranchTreeRoot() {
        return this.branchTreeRoot;
    }

    @Override
    public BranchTreeNode getExclusionPredicatesRoot() {
        return this.exclusionRoot;
    }

    @Override
    public RootTreeNode getOverallRoot() {
        return this.overallRoot;
    }

    @Override
    public List<TreeChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    @Override
    public void nodeUpdated(BranchTreeNode node, boolean alsoSubtree) {
        if (this.noTreeUpdates) {
            return;
        }
        List<BranchTreeNode> res = Arrays.asList(node);
        this.notifyChangeListeners(alsoSubtree ? TreeChangeListener.TreeChangeKind.SUBTREE_UPDATED : TreeChangeListener.TreeChangeKind.NODE_UPDATED, res);
    }

    @Override
    public BranchTreeManager.VariableOrderResult calculateGlobalVariableOrdering() {
        Graph<Variable> sorter = new Graph<Variable>();
        for (Expression ex : this.expressionList) {
            List<Variable> varOrder = ex.getVariableOrder();
            if (varOrder.size() < 1) continue;
            Variable lastVar = varOrder.get(0);
            sorter.addNode(lastVar);
            int i = 1;
            while (i < varOrder.size()) {
                Variable var = varOrder.get(i);
                sorter.addNode(var);
                sorter.addEdge(lastVar, var);
                lastVar = var;
                ++i;
            }
        }
        if (sorter.sort()) {
            List result = sorter.getResult();
            int i = 0;
            while (i < result.size()) {
                ((Variable)result.get(i)).setTopologicalPosition(i);
                ++i;
            }
            return new BranchTreeManager.VariableOrderResult(true, null);
        }
        return new BranchTreeManager.VariableOrderResult(false, sorter.getCycleNodes());
    }

    @Override
    public Set<DecisionID> getAvailableDecisionIDs() {
        return this.availableDecisionIDs;
    }

    @Override
    public void loadFromXML(Element rootElement) throws DeserializeException {
        this.loadFromXML(rootElement, true, null);
    }

    public void loadFromXML(Element rootElement, boolean loadVarsAndIDs) throws DeserializeException {
        this.loadFromXML(rootElement, loadVarsAndIDs, null);
    }

    public void loadFromXML(Element rootElement, boolean loadVarsAndIDs, CheckReport report) throws DeserializeException {
        try {
            try {
                org.w3c.dom.Node node;
                this.noTreeUpdates = true;
                NodeList childNodes = rootElement.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    int j;
                    node = childNodes.item(i);
                    if (node.getNodeName().equals("expressions")) {
                        this.expressionList.clear();
                        NodeList expNodes = node.getChildNodes();
                        j = 0;
                        while (j < expNodes.getLength()) {
                            org.w3c.dom.Node expNode = expNodes.item(j);
                            if (expNode.getNodeName().equals("expression")) {
                                DefaultExpression exp = new DefaultExpression(ExpressionType.VAR_COMP_CONST, null, this);
                                try {
                                    exp.loadFromXML((Element)expNode);
                                    this.expressionList.add(exp);
                                }
                                catch (ParserException ex) {
                                    if (report == null) {
                                        throw ex;
                                    }
                                    report.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, String.format(E_SYNTAX_ERROR, ex.getMessage()), ProcessElementIdentifierTools.getNodeIdentifier(report.getBase(), this.node));
                                    this.hadLoadError = true;
                                }
                            }
                            ++j;
                        }
                    } else if (loadVarsAndIDs && node.getNodeName().equals("requiredVariables")) {
                        this.variables.getKnownVariables().clear();
                        NodeList varNodes = node.getChildNodes();
                        j = 0;
                        while (j < varNodes.getLength()) {
                            org.w3c.dom.Node varNode = varNodes.item(j);
                            if (varNode.getNodeName().equals("variable")) {
                                String varName = ((Element)varNode).getAttribute("name");
                                if (!this.variables.getKnownVariables().containsKey(varName)) {
                                    try {
                                        DataType dataType = GenericUserObjectDataType.lookupDataType(Class.forName(((Element)varNode).getAttribute("type")));
                                        this.variables.addVariable(varName, dataType, !"false".equals(((Element)varNode).getAttribute("canBeNull")));
                                    }
                                    catch (ClassNotFoundException ex) {
                                        if (report == null) {
                                            throw ex;
                                        }
                                        report.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, String.format(E_UNKNOWN_DATA_TYPE, ex.getMessage()), ProcessElementIdentifierTools.getNodeIdentifier(report.getBase(), this.node));
                                        this.hadLoadError = true;
                                    }
                                }
                            }
                            ++j;
                        }
                    } else if (loadVarsAndIDs && node.getNodeName().equals("decisionIDs")) {
                        this.availableDecisionIDs.clear();
                        NodeList idNodes = node.getChildNodes();
                        j = 0;
                        while (j < idNodes.getLength()) {
                            org.w3c.dom.Node idNode = idNodes.item(j);
                            if (idNode.getNodeName().equals("decisionID")) {
                                DefaultDecisionID id = new DefaultDecisionID(this, Integer.MIN_VALUE, null);
                                id.loadFromXML((Element)idNode);
                                this.availableDecisionIDs.add(id);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                this.internalRebuildTree(true);
                i = 0;
                while (i < childNodes.getLength()) {
                    node = childNodes.item(i);
                    if (node.getNodeName().equals("exclusionIDAssignment")) {
                        this.exclusionRoot.loadFromXML((Element)node);
                    } else if (node.getNodeName().equals("IDAssignment")) {
                        this.branchTreeRoot.loadFromXML((Element)node);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new DeserializeException("Error deserializing the tree manager.", e);
            }
        }
        finally {
            List<BranchTreeNode> emptyList = Collections.emptyList();
            this.notifyChangeListeners(TreeChangeListener.TreeChangeKind.TREE_REBUILT, emptyList);
            this.noTreeUpdates = false;
        }
    }

    @Override
    public void saveToXML(Element rootElement, Document parentDoc) {
        this.saveToXML(rootElement, parentDoc, true);
    }

    public void saveToXML(Element rootElement, Document parentDoc, boolean saveVarsAndIDs) {
        Element expElem;
        Element elem;
        if (saveVarsAndIDs) {
            elem = parentDoc.createElement("requiredVariables");
            for (Variable var : this.variables.getKnownVariables().values()) {
                expElem = parentDoc.createElement("variable");
                expElem.setAttributeNS(null, "name", var.getName());
                expElem.setAttributeNS(null, "type", var.getDataType().getJavaDataType().getName());
                expElem.setAttributeNS(null, "canBeNull", String.valueOf(var.canBeNull()));
                elem.appendChild(expElem);
            }
            rootElement.appendChild(elem);
            elem = parentDoc.createElement("decisionIDs");
            for (DecisionID id : this.availableDecisionIDs) {
                expElem = parentDoc.createElement("decisionID");
                id.saveToXML(expElem, parentDoc);
                elem.appendChild(expElem);
            }
            rootElement.appendChild(elem);
        }
        elem = parentDoc.createElement("expressions");
        for (Expression exp : this.expressionList) {
            expElem = parentDoc.createElement("expression");
            exp.saveToXML(expElem, parentDoc);
            elem.appendChild(expElem);
        }
        rootElement.appendChild(elem);
        elem = parentDoc.createElement("exclusionIDAssignment");
        this.exclusionRoot.saveToXML(elem, parentDoc);
        rootElement.appendChild(elem);
        elem = parentDoc.createElement("IDAssignment");
        this.branchTreeRoot.saveToXML(elem, parentDoc);
        rootElement.appendChild(elem);
    }

    @Override
    public void deserializeFromXML(Reader inReader, boolean loadVarsAndIDs) throws DeserializeException {
        this.deserializeFromXML(inReader, loadVarsAndIDs, null);
    }

    protected void deserializeFromXML(Reader inReader, boolean loadVarsAndIDs, CheckReport report) throws DeserializeException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", XORXMLConstants.class.getResourceAsStream("xordecision.xsd"));
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            DeserializeErrorHandler eh = new DeserializeErrorHandler();
            builder.setErrorHandler(eh);
            Document doc = builder.parse(new InputSource(inReader));
            if (eh.getErrorMessages().length() > 0) {
                throw new DeserializeException(E_INVALID_XML + eh.getErrorMessages());
            }
            Element root = doc.getDocumentElement();
            this.loadFromXML(root, loadVarsAndIDs, report);
        }
        catch (ParserConfigurationException e) {
            throw new DeserializeException("Error deserializing the tree", e);
        }
        catch (SAXException e) {
            throw new DeserializeException("Error deserializing the tree", e);
        }
        catch (IOException e) {
            throw new DeserializeException("Error deserializing the tree", e);
        }
    }

    @Override
    public void serializeToXML(Writer outWriter) throws Exception {
        this.serializeToXML(outWriter, false, true);
    }

    @Override
    public void serializeToXML(Writer outWriter, boolean prettyPrint, boolean saveVarsAndIDs) throws Exception {
        Document doc = XMLHelperTools.createDocument();
        Element root = doc.createElement("xordecision");
        doc.appendChild(root);
        this.saveToXML(root, doc, saveVarsAndIDs);
        root.normalize();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        if (prettyPrint) {
            tFactory.setAttribute("indent-number", "2");
        }
        Transformer transformer = tFactory.newTransformer();
        if (prettyPrint) {
            transformer.setOutputProperty("indent", "yes");
        }
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outWriter);
        transformer.transform(source, result);
    }

    @Override
    public long getNextPredicateID() {
        return this.idCounter++;
    }

    @Override
    public void predicateIDInUse(long id) {
        this.idCounter = Math.max(this.idCounter, id + 1L);
    }

    @Override
    public DecisionID lookupDecisionID(int id) {
        if (id != Integer.MIN_VALUE) {
            for (DecisionID bID : this.getAvailableDecisionIDs()) {
                if (bID.getIndex() != id) continue;
                return bID;
            }
            return null;
        }
        return DecisionID.UNASSIGNED;
    }

    @Override
    public int getNextDecisionIDIndex() {
        return this.decisionIDCounter++;
    }

    @Override
    public void decisionIDInUse(int id) {
        this.decisionIDCounter = Math.max(id + 1, this.decisionIDCounter);
    }

    @Override
    public void writeCode(CodeGenerator gen) {
        int varIdx = gen.createLocalVariable(Comparator.class, "comparator");
        List<BranchTreeNode> children = this.exclusionRoot.getChildren();
        Collections.sort(children);
        ArrayList<Object> jumpList1 = new ArrayList<BranchInstruction>();
        ArrayList<Object> jumpList2 = new ArrayList();
        ArrayList<BranchInstruction> matchJumps = new ArrayList<BranchInstruction>();
        Expression lastExpr = null;
        int lastExprIdx = -1;
        for (BranchTreeNode node : children) {
            InstructionHandle curPred = null;
            if (lastExpr != node.getPredicate().getParent()) {
                lastExpr = node.getPredicate().getParent();
                lastExprIdx = this.getExpressionList().indexOf(lastExpr);
                gen.addGetDataType(lastExpr.getDataType().getJavaDataType());
                gen.addCast(DataType.class, CoverableDataType.class);
                curPred = gen.getLastFirstInstruction();
                try {
                    gen.addMethodCall(CoverableDataType.class.getMethod("getComparator", new Class[0]));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                gen.addSetLocalVariable(varIdx, Comparator.class);
            }
            jumpList1.clear();
            matchJumps.clear();
            InstructionHandle tmpPred = node.getPredicate().writeCode(gen, lastExprIdx, varIdx, jumpList1, matchJumps);
            if (curPred == null) {
                curPred = tmpPred;
            }
            for (BranchInstruction branch : jumpList2) {
                branch.setTarget(curPred);
            }
            ArrayList tmp = jumpList2;
            jumpList2 = jumpList1;
            jumpList1 = tmp;
            InstructionHandle matchHandle = node.writeCode(gen, lastExprIdx + 1, varIdx);
            for (BranchInstruction branch : matchJumps) {
                branch.setTarget(matchHandle);
            }
        }
        InstructionHandle nextPred = this.branchTreeRoot.writeCode(gen, 0, varIdx);
        for (BranchInstruction branch : jumpList2) {
            branch.setTarget(nextPred);
        }
    }

    @Override
    public void removeDecisionID(DecisionID id) {
        this.availableDecisionIDs.remove(id);
        this.overallRoot.removeDecisionID(id);
    }

    @Override
    public VariableManager getVariables() {
        return this.variables;
    }

    @Override
    public DecisionActivity getActivity() {
        return this.activity;
    }

    @Override
    public boolean performConsistencyChecks(CheckReport report) {
        int dimIdx = 0;
        for (Expression ex : this.expressionList) {
            ++dimIdx;
            List<CoverageError> errors = CoverCheck.checkCoverage(ex);
            if (errors.size() <= 0) continue;
            for (CoverageError ce : errors) {
                report.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, String.format(E_COVERAGE_ERROR, dimIdx, ce.getErrorMessage()), ProcessElementIdentifierTools.getNodeIdentifier(report.getBase(), this.node));
            }
            this.hadLoadError = true;
        }
        HashSet<DecisionID> assignedIDs = new HashSet<DecisionID>();
        int numUnassigned = this.overallRoot.numberOfUnassignedDecisionIDs(assignedIDs);
        if (numUnassigned > 0) {
            if (numUnassigned > 1) {
                report.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, E_UNASSIGNED_DECISION_PATHS, ProcessElementIdentifierTools.getNodeIdentifier(report.getBase(), this.node));
                this.hadLoadError = true;
            } else if (numUnassigned == 1) {
                report.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, String.format(E_UNASSIGNED_DECISION_PATH, numUnassigned), ProcessElementIdentifierTools.getNodeIdentifier(report.getBase(), this.node));
                this.hadLoadError = true;
            }
        }
        if (assignedIDs.size() < this.availableDecisionIDs.size()) {
            numUnassigned = this.availableDecisionIDs.size() - assignedIDs.size();
            String msg = numUnassigned == 1 ? E_DECISION_ID_WITHOUT_PREDICATE : String.format(E_DECISION_IDS_WITHOUT_PREDICATE, numUnassigned);
            report.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, msg, ProcessElementIdentifierTools.getNodeIdentifier(report.getBase(), this.node));
        }
        HashSet<Variable> vars = new HashSet<Variable>(this.variables.getKnownVariables().values());
        for (Expression expr : this.expressionList) {
            vars.removeAll(expr.getLHSVariables());
            if (expr.getType().isConstantComparison()) continue;
            for (Predicate pred : expr.getPredicates()) {
                if (pred.getLowerBound() != null && pred.getLowerBound() instanceof Variable) {
                    vars.remove(pred.getLowerBound());
                }
                if (pred.getUpperBound() == null || !(pred.getUpperBound() instanceof Variable)) continue;
                vars.remove(pred.getUpperBound());
            }
        }
        if (vars.size() > 0) {
            for (Variable var : vars) {
                report.addReportEntry(CHECK_ID, CheckReport.ResultType.WARNING, String.format(W_UNUSED_INPUT_PARAMETER, var), ProcessElementIdentifierTools.getNodeIdentifier(report.getBase(), this.node));
            }
            this.hadLoadError = true;
        }
        return !this.hadLoadError;
    }

    protected static class DeserializeErrorHandler
    implements ErrorHandler {
        protected static final String XML_SCHEMA_ERROR_HEADER = "Line %s, Column %s: %s\n";
        protected String errorMessages = "";

        protected DeserializeErrorHandler() {
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            this.errorMessages = String.valueOf(this.errorMessages) + String.format(XML_SCHEMA_ERROR_HEADER, ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage());
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            this.errorMessages = String.valueOf(this.errorMessages) + String.format(XML_SCHEMA_ERROR_HEADER, ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage());
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
        }

        public String getErrorMessages() {
            return this.errorMessages;
        }
    }
}

