/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.RootTreeNode;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeNode;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.CodeGenerator;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.DecisionID;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import de.aristaflow.adept2.extensions.xorsupport.model.xml.DeserializeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.InstructionHandle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultBranchTreeNode
implements BranchTreeNode {
    protected Predicate predicate;
    protected BranchTreeNode parent;
    protected List<BranchTreeNode> children = new ArrayList<BranchTreeNode>();
    protected DecisionID decisionID;
    protected BranchTreeManager manager;

    public DefaultBranchTreeNode(BranchTreeManager manager, BranchTreeNode parent, Predicate predicate, DecisionID decisionID) {
        this.manager = manager;
        this.parent = parent;
        this.predicate = predicate;
        this.decisionID = decisionID;
    }

    @Override
    public List<BranchTreeNode> getChildren() {
        return this.children;
    }

    @Override
    public BranchTreeNode getParent() {
        return this.parent;
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public DecisionID getDecisionID() {
        return this.decisionID;
    }

    public String toString() {
        return this.predicate.toString();
    }

    @Override
    public int compareTo(BranchTreeNode o) {
        if (this.predicate == o.getPredicate()) {
            return 0;
        }
        if (this.predicate == null) {
            return -1;
        }
        if (o.getPredicate() == null) {
            return 1;
        }
        return this.predicate.compareTo(o.getPredicate());
    }

    protected void internalSetDecisionID(DecisionID newID, boolean updateSubtree) {
        if (!newID.equals(this.decisionID)) {
            this.decisionID = newID;
        }
        if (updateSubtree) {
            for (BranchTreeNode n : this.getChildren()) {
                if (n instanceof DefaultBranchTreeNode) {
                    ((DefaultBranchTreeNode)n).internalSetDecisionID(newID, updateSubtree);
                    continue;
                }
                n.setDecisionID(newID, updateSubtree);
            }
        }
    }

    @Override
    public void setDecisionID(DecisionID newID, boolean updateSubtree) {
        this.internalSetDecisionID(newID, updateSubtree);
        this.manager.nodeUpdated(this, updateSubtree);
    }

    @Override
    public DecisionID getSubtreeDecisionID() {
        if (this.getChildren().size() == 0) {
            return this.getDecisionID();
        }
        DecisionID result = null;
        for (BranchTreeNode child : this.getChildren()) {
            DecisionID childID = child.getSubtreeDecisionID();
            if (childID == null) {
                return null;
            }
            if (result == null) {
                result = childID;
                continue;
            }
            if (childID.equals(result)) continue;
            return null;
        }
        return result;
    }

    @Override
    public void loadFromXML(Element rootElement) throws DeserializeException {
        String decisionIDAttr = rootElement.getAttribute("decisionID");
        if (decisionIDAttr.length() > 0) {
            this.decisionID = this.manager.lookupDecisionID(Integer.parseInt(decisionIDAttr));
            if (this.decisionID == null) {
                throw new DeserializeException("Invalid decision ID.");
            }
        } else {
            this.decisionID = DecisionID.UNASSIGNED;
        }
        if (this.children.size() > 0) {
            NodeList childNodes = rootElement.getChildNodes();
            HashMap<Long, BranchTreeNode> predicateMap = new HashMap<Long, BranchTreeNode>();
            for (BranchTreeNode child : this.children) {
                predicateMap.put(child.getPredicate().getID(), child);
            }
            int i = 0;
            while (i < childNodes.getLength()) {
                Node node = childNodes.item(i);
                if (node.getNodeName().equals("node")) {
                    Element el = (Element)node;
                    String predID = el.getAttribute("predicate");
                    if (predID.length() == 0) {
                        throw new DeserializeException("No predicate ID found for a child.");
                    }
                    BranchTreeNode child = (BranchTreeNode)predicateMap.get(Long.valueOf(predID));
                    if (child == null) {
                        throw new DeserializeException("Invalid predicate ID found.");
                    }
                    child.loadFromXML(el);
                }
                ++i;
            }
        }
    }

    @Override
    public void saveToXML(Element rootElement, Document parentDoc) {
        if (this.predicate != null) {
            rootElement.setAttributeNS(null, "predicate", Long.toString(this.predicate.getID()));
        }
        if (this.decisionID != null && this.children.size() == 0 && !(this instanceof RootTreeNode)) {
            rootElement.setAttributeNS(null, "decisionID", Integer.toString(this.decisionID.getIndex()));
        }
        for (BranchTreeNode node : this.children) {
            Element elem = parentDoc.createElement("node");
            node.saveToXML(elem, parentDoc);
            rootElement.appendChild(elem);
        }
    }

    @Override
    public InstructionHandle writeCode(CodeGenerator gen, int expressionIndex, int comparatorVarIndex) {
        DecisionID treeID = this.getSubtreeDecisionID();
        if (treeID != null) {
            gen.addReturn(treeID.getIndex());
            return gen.getLastFirstInstruction();
        }
        Collections.sort(this.children);
        gen.addGetDataType(this.manager.getExpressionList().get(expressionIndex).getDataType().getJavaDataType());
        gen.addCast(DataType.class, CoverableDataType.class);
        InstructionHandle ih = gen.getLastFirstInstruction();
        try {
            gen.addMethodCall(CoverableDataType.class.getMethod("getComparator", new Class[0]));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        gen.addSetLocalVariable(comparatorVarIndex, Comparator.class);
        ArrayList<Object> jumpList1 = new ArrayList<BranchInstruction>();
        ArrayList<Object> jumpList2 = new ArrayList();
        ArrayList<BranchInstruction> matchJumps = new ArrayList<BranchInstruction>();
        for (BranchTreeNode node : this.children) {
            matchJumps.clear();
            jumpList1.clear();
            InstructionHandle curPred = node.getPredicate().writeCode(gen, expressionIndex, comparatorVarIndex, jumpList1, matchJumps);
            for (BranchInstruction branch : jumpList2) {
                branch.setTarget(curPred);
            }
            ArrayList tmp = jumpList2;
            jumpList2 = jumpList1;
            jumpList1 = tmp;
            InstructionHandle matchHandle = node.writeCode(gen, expressionIndex + 1, comparatorVarIndex);
            for (BranchInstruction branch : matchJumps) {
                branch.setTarget(matchHandle);
            }
        }
        gen.addReturn(Integer.MIN_VALUE);
        InstructionHandle dummyPred = gen.getLastFirstInstruction();
        for (BranchInstruction branch : jumpList2) {
            branch.setTarget(dummyPred);
        }
        return ih;
    }

    @Override
    public int numberOfUnassignedDecisionIDs(Set<DecisionID> assignedIDs) {
        if (this.children.size() == 0) {
            if (this.hasUnassignedDecisionID()) {
                return 1;
            }
            if (assignedIDs != null) {
                assignedIDs.add(this.decisionID);
            }
            return 0;
        }
        int res = 0;
        for (BranchTreeNode child : this.children) {
            res += child.numberOfUnassignedDecisionIDs(assignedIDs);
        }
        return res;
    }

    @Override
    public BranchTreeNode nextUnassignedDecisionID() {
        if (this.children.size() == 0) {
            if (this.hasUnassignedDecisionID()) {
                return this;
            }
            return null;
        }
        for (BranchTreeNode child : this.children) {
            BranchTreeNode res = child.nextUnassignedDecisionID();
            if (res == null) continue;
            return res;
        }
        return null;
    }

    protected boolean hasUnassignedDecisionID() {
        return this.decisionID == null || this.decisionID.equals(DecisionID.UNASSIGNED);
    }

    @Override
    public void removeDecisionID(DecisionID id) {
        if (this.decisionID != null && id.equals(this.decisionID)) {
            this.decisionID = DecisionID.UNASSIGNED;
            this.manager.nodeUpdated(this, false);
        }
        for (BranchTreeNode child : this.children) {
            child.removeDecisionID(id);
        }
    }
}

