/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeNode;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.DecisionID;
import de.aristaflow.adept2.extensions.xorsupport.model.xml.DeserializeException;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultDecisionID
implements DecisionID {
    protected static final String NO_STATEMENT = "<no statement> ";
    protected int index;
    protected String label;
    protected BranchTreeManager treeManager;

    public DefaultDecisionID(BranchTreeManager treeManager, int index, String label) {
        this.index = index;
        this.label = label;
        this.treeManager = treeManager;
        if (treeManager != null) {
            treeManager.decisionIDInUse(index);
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String toString() {
        if (this.label != null) {
            return this.label;
        }
        String stmt = this.calculateStatement();
        if (stmt != null) {
            return stmt;
        }
        return NO_STATEMENT + this.index;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof DecisionID && this.index == ((DecisionID)obj).getIndex() && (this.label == null && ((DecisionID)obj).getLabel() == null || this.label != null && this.label.equals(((DecisionID)obj).getLabel()));
    }

    @Override
    public void loadFromXML(Element rootElement) throws DeserializeException {
        this.index = rootElement.hasAttribute("id") ? Integer.parseInt(rootElement.getAttribute("id")) : Integer.parseInt(rootElement.getChildNodes().item(0).getNodeValue());
        Node labelNode = rootElement.getChildNodes().item(0);
        this.label = labelNode != null ? labelNode.getNodeValue() : null;
    }

    @Override
    public void saveToXML(Element rootElement, Document parentDoc) {
        rootElement.setAttributeNS(null, "id", Integer.toString(this.index));
        if (this.label != null) {
            rootElement.appendChild(parentDoc.createTextNode(this.label));
        }
    }

    @Override
    public int compareTo(DecisionID o) {
        if (this.index == Integer.MIN_VALUE) {
            return -1;
        }
        if (o.getIndex() == Integer.MIN_VALUE) {
            return 1;
        }
        int rv = 0;
        if (this.label != null && o.getLabel() != null) {
            rv = this.label.compareTo(o.getLabel());
        }
        if (rv != 0) {
            return rv;
        }
        if (o.getIndex() < this.index) {
            return 1;
        }
        if (o.getIndex() > this.index) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.index ^ (this.label != null ? this.label.hashCode() : 0);
    }

    @Override
    public String calculateStatement() {
        if (this.treeManager == null) {
            return null;
        }
        List<BranchTreeNode[]> paths = this.treeManager.getBranchTreePaths(this);
        if (paths.size() == 0) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (BranchTreeNode[] p : paths) {
            res.append('[');
            int i = 1;
            while (i < p.length) {
                res.append('{').append(p[i]).append('}').append(" && ");
                ++i;
            }
            res.delete(res.length() - " && ".length(), res.length());
            res.append(']');
            res.append(" || ");
            res.append('\n');
        }
        return res.substring(0, res.length() - " || ".length());
    }
}

