/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultPredicate;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.PredicateList;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.Parser;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.SubExpression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ExpressionType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import de.aristaflow.adept2.extensions.xorsupport.model.xml.DeserializeException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultExpression
implements Expression {
    protected SubExpression lhs;
    protected PredicateList predicates;
    protected ExpressionType type;
    protected BranchTreeManager treeManager;
    protected Set<Variable> lhsVariables = null;
    protected List<Variable> variableOrder;

    public DefaultExpression(ExpressionType type, SubExpression leftHandSide, BranchTreeManager treeManager) {
        this.type = type;
        this.lhs = leftHandSide;
        this.treeManager = treeManager;
        this.predicates = new PredicateList(this, treeManager);
        this.variableOrder = new ArrayList<Variable>();
    }

    @Override
    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    @Override
    public SubExpression getLeftHandSide() {
        return this.lhs;
    }

    @Override
    public ExpressionType getType() {
        return this.type;
    }

    @Override
    public void setType(ExpressionType value) {
        if (this.type != value) {
            if (this.lhs != null && !this.predicates.isPredicateListCompatibleTo(value, (CoverableDataType)this.lhs.getDataType())) {
                throw new IllegalArgumentException("New expression type not compatible to predicate list.");
            }
            this.type = value;
            this.treeManager.expressionUpdated(this);
        }
    }

    @Override
    public void setLeftHandSide(SubExpression newSide) {
        if (!this.predicates.isPredicateListCompatibleTo(this.type, (CoverableDataType)newSide.getDataType())) {
            throw new IllegalArgumentException("New data type not compatible to predicate list.");
        }
        this.lhs = newSide;
        this.lhsVariables = null;
        this.treeManager.expressionUpdated(this);
    }

    @Override
    public CoverableDataType getDataType() {
        if (this.lhs == null) {
            return null;
        }
        return (CoverableDataType)this.lhs.getDataType();
    }

    @Override
    public Set<Variable> getLHSVariables() {
        if (this.lhsVariables == null) {
            this.lhsVariables = new HashSet<Variable>();
            if (this.lhs != null) {
                this.lhs.determineUsedVariables(this.lhsVariables);
            }
        }
        return this.lhsVariables;
    }

    @Override
    public BranchTreeManager getTreeManager() {
        return this.treeManager;
    }

    @Override
    public int compareTo(Expression o) {
        return this.treeManager.getExpressionList().indexOf(this) - this.treeManager.getExpressionList().indexOf(o);
    }

    @Override
    public List<Variable> getVariableOrder() {
        return this.variableOrder;
    }

    @Override
    public void loadFromXML(Element rootElement) throws DeserializeException {
        this.type = ExpressionType.valueOf(rootElement.getAttribute("type"));
        NodeList childNodes = rootElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            int j;
            Node node = childNodes.item(i);
            if (node.getNodeName().equals("leftHandSide")) {
                this.lhs = Parser.parse(node.getChildNodes().item(0).getNodeValue(), this.treeManager.getVariables());
            } else if (node.getNodeName().equals("predicates")) {
                this.predicates.clear();
                NodeList predNodes = node.getChildNodes();
                j = 0;
                while (j < predNodes.getLength()) {
                    Node predNode = predNodes.item(j);
                    if (predNode.getNodeName().equals("predicate")) {
                        DefaultPredicate pred = new DefaultPredicate(PredicateType.IS_NULL, this);
                        pred.loadFromXML((Element)predNode);
                    }
                    ++j;
                }
            } else if (node.getNodeName().equals("variableOrder")) {
                this.variableOrder.clear();
                NodeList varNodes = node.getChildNodes();
                j = 0;
                while (j < varNodes.getLength()) {
                    Node varNode = varNodes.item(j);
                    if (varNode.getNodeName().equals("variable")) {
                        this.variableOrder.add(this.treeManager.getVariables().getKnownVariables().get(((Element)varNode).getAttribute("name")));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void saveToXML(Element rootElement, Document parentDoc) {
        rootElement.setAttributeNS(null, "type", this.type.name());
        Element elem = parentDoc.createElement("leftHandSide");
        elem.appendChild(parentDoc.createTextNode(this.lhs.toString()));
        rootElement.appendChild(elem);
        elem = parentDoc.createElement("variableOrder");
        for (Variable var : this.variableOrder) {
            Element varElem = parentDoc.createElement("variable");
            varElem.setAttributeNS(null, "name", var.getName());
            elem.appendChild(varElem);
        }
        rootElement.appendChild(elem);
        elem = parentDoc.createElement("predicates");
        for (Predicate pred : this.predicates) {
            Element predElem = parentDoc.createElement("predicate");
            pred.saveToXML(predElem, parentDoc);
            elem.appendChild(predElem);
        }
        rootElement.appendChild(elem);
    }
}

