/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultConstant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.CodeGenerator;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.FunctionCall;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.SubExpression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.bcel.generic.InstructionHandle;

public class DefaultFunctionCall
implements SubExpression,
FunctionCall {
    protected String funcName;
    protected List<SubExpression> parameters;
    protected DataType resultType;
    protected Method method;

    public DefaultFunctionCall(String name) {
        this.funcName = name;
        this.parameters = new ArrayList<SubExpression>();
    }

    @Override
    public DataType getDataType() {
        return this.resultType;
    }

    @Override
    public int getNumberOfElements() {
        return 1;
    }

    @Override
    public Object getValue() {
        ArrayList<Object> operands = new ArrayList<Object>();
        Class<?>[] params = this.method.getParameterTypes();
        int i = 0;
        while (i < this.parameters.size()) {
            Object val = this.parameters.get(i).getValue();
            if (params[i].equals(Integer.TYPE) || params[i].equals(Integer.class)) {
                val = ((Number)val).intValue();
            } else if (params[i].equals(Short.TYPE) || params[i].equals(Short.class)) {
                val = ((Number)val).shortValue();
            } else if (params[i].equals(Byte.TYPE) || params[i].equals(Byte.class)) {
                val = ((Number)val).byteValue();
            } else if (params[i].equals(Float.TYPE) || params[i].equals(Float.class)) {
                val = Float.valueOf(((Number)val).floatValue());
            }
            operands.add(val);
            ++i;
        }
        try {
            return this.method.invoke(null, operands.toArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Error calling function: " + e.getMessage());
        }
    }

    @Override
    public String getFuncName() {
        return this.funcName;
    }

    @Override
    public List<SubExpression> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.funcName);
        s.append("(");
        int i = 0;
        while (i < this.parameters.size()) {
            s.append(this.parameters.get(i));
            if (i < this.parameters.size() - 1) {
                s.append(", ");
            }
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public void setResultType(DataType d) {
        this.resultType = d;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(Method method) {
        this.method = method;
    }

    @Override
    public SubExpression makeRunnable() {
        boolean constantsOnly = true;
        int i = 0;
        while (i < this.parameters.size()) {
            SubExpression ex = this.parameters.get(i);
            ex = ex.makeRunnable();
            this.parameters.set(i, ex);
            constantsOnly &= ex instanceof Constant;
            ++i;
        }
        if (constantsOnly) {
            return new DefaultConstant((CoverableDataType)this.getDataType(), this.getValue());
        }
        return this;
    }

    @Override
    public void determineUsedVariables(Set<Variable> vars) {
        for (SubExpression ex : this.parameters) {
            ex.determineUsedVariables(vars);
        }
    }

    @Override
    public InstructionHandle writeCode(CodeGenerator gen, Class<?> desiredType) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        InstructionHandle ih = null;
        if (this.parameters.size() > 0) {
            ih = this.parameters.get(0).writeCode(gen, parameterTypes[0]);
            int i = 1;
            while (i < this.parameters.size()) {
                SubExpression ex = this.parameters.get(i);
                ex.writeCode(gen, parameterTypes[i]);
                ++i;
            }
        }
        gen.addMethodCall(this.method);
        if (ih == null) {
            ih = gen.getLastFirstInstruction();
        }
        gen.addCast(this.method.getReturnType(), desiredType);
        return ih;
    }

    @Override
    public boolean canBeNull() {
        return true;
    }
}

