/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.AtomicElement;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Interval;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import java.util.Comparator;

public class DefaultInterval
implements Interval {
    protected AtomicElement lowerBound;
    protected AtomicElement upperBound;
    protected boolean lowerBoundIncluded;
    protected boolean upperBoundIncluded;

    @Override
    public AtomicElement getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public AtomicElement getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean isLowerBoundIncluded() {
        return this.lowerBoundIncluded;
    }

    @Override
    public boolean isUpperBoundIncluded() {
        return this.upperBoundIncluded;
    }

    public String toString() {
        if (this.lowerBound.getValue().equals(this.upperBound.getValue())) {
            return this.lowerBound.toString();
        }
        StringBuilder s = new StringBuilder();
        if (this.lowerBoundIncluded) {
            s.append("[");
        } else {
            s.append("(");
        }
        s.append(this.lowerBound);
        s.append(",");
        s.append(this.upperBound);
        if (this.upperBoundIncluded) {
            s.append("]");
        } else {
            s.append(")");
        }
        return s.toString();
    }

    public DefaultInterval(AtomicElement lowerBound, AtomicElement upperBound, boolean lowerIncluded, boolean upperIncluded) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.lowerBoundIncluded = lowerIncluded;
        this.upperBoundIncluded = upperIncluded;
    }

    @Override
    public int compareTo(Interval o) {
        Comparator<Object> comp = ((CoverableDataType)this.getLowerBound().getDataType()).getComparator();
        int compRes = comp.compare(this.getLowerBound().getValue(), o.getLowerBound().getValue());
        if (compRes != 0) {
            return compRes;
        }
        if (!this.isLowerBoundIncluded() && o.isLowerBoundIncluded()) {
            return 1;
        }
        if (this.isLowerBoundIncluded() && !o.isLowerBoundIncluded()) {
            return -1;
        }
        compRes = comp.compare(this.getUpperBound().getValue(), o.getUpperBound().getValue());
        if (compRes != 0) {
            return compRes;
        }
        if (!this.isUpperBoundIncluded() && o.isUpperBoundIncluded()) {
            return -1;
        }
        if (this.isUpperBoundIncluded() && !o.isUpperBoundIncluded()) {
            return 1;
        }
        return 0;
    }
}

