/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.CodeGenerator;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.FunctionCall;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.MethodCall;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.MethodOwner;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.SubExpression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import java.util.ArrayList;
import java.util.Set;
import org.apache.bcel.generic.InstructionHandle;

public class DefaultMethodCall
implements MethodCall {
    protected FunctionCall method;
    protected MethodOwner owner;

    public DefaultMethodCall(FunctionCall method, MethodOwner owner) {
        this.method = method;
        this.owner = owner;
    }

    @Override
    public FunctionCall getMethod() {
        return this.method;
    }

    @Override
    public MethodOwner getOwner() {
        return this.owner;
    }

    @Override
    public DataType getDataType() {
        return this.method.getDataType();
    }

    @Override
    public int getNumberOfElements() {
        return 1;
    }

    @Override
    public Object getValue() {
        Object ownerObj = this.owner.getValue();
        ArrayList<Object> operands = new ArrayList<Object>();
        Class<?>[] params = this.method.getMethod().getParameterTypes();
        int i = 0;
        while (i < this.method.getParameters().size()) {
            Object val = this.method.getParameters().get(i).getValue();
            if (params[i].equals(Integer.TYPE) || params[i].equals(Integer.class)) {
                val = ((Number)val).intValue();
            } else if (params[i].equals(Short.TYPE) || params[i].equals(Short.class)) {
                val = ((Number)val).shortValue();
            }
            if (params[i].equals(Byte.TYPE) || params[i].equals(Byte.class)) {
                val = ((Number)val).byteValue();
            }
            if (params[i].equals(Float.TYPE) || params[i].equals(Float.class)) {
                val = Float.valueOf(((Number)val).floatValue());
            }
            operands.add(val);
            ++i;
        }
        try {
            return this.method.getMethod().invoke(ownerObj, operands.toArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Error calling method: " + e.getMessage());
        }
    }

    public String toString() {
        return String.valueOf(this.owner.toString()) + "." + this.method.toString();
    }

    @Override
    public SubExpression makeRunnable() {
        int i = 0;
        while (i < this.method.getParameters().size()) {
            SubExpression ex = this.method.getParameters().get(i);
            ex = ex.makeRunnable();
            this.method.getParameters().set(i, ex);
            ++i;
        }
        return this;
    }

    @Override
    public void determineUsedVariables(Set<Variable> vars) {
        for (SubExpression ex : this.method.getParameters()) {
            ex.determineUsedVariables(vars);
        }
    }

    @Override
    public InstructionHandle writeCode(CodeGenerator gen, Class<?> desiredType) {
        InstructionHandle ih = this.owner.writeCode(gen, this.owner.getDataType().getJavaDataType());
        this.method.writeCode(gen, desiredType);
        return ih;
    }

    @Override
    public boolean canBeNull() {
        return true;
    }
}

