/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultConstant;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultInterval;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultVariable;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.AtomicElement;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.CodeGenerator;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Interval;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import de.aristaflow.adept2.extensions.xorsupport.model.xml.DeserializeException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.InstructionHandle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultPredicate
implements Predicate {
    protected PredicateType type;
    protected AtomicElement lowerBound;
    protected AtomicElement upperBound;
    protected boolean upperBoundIncluded;
    protected boolean lowerBoundIncluded;
    protected Expression parent;
    protected boolean exclusionPredicate;
    protected long ID;

    public DefaultPredicate(PredicateType type, Expression parent, AtomicElement lowerBound, AtomicElement upperBound, boolean lowerBoundIncluded, boolean upperBoundIncluded) {
        this.type = type;
        this.parent = parent;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        this.upperBoundIncluded = upperBoundIncluded;
        this.lowerBoundIncluded = lowerBoundIncluded;
        this.ID = parent.getTreeManager().getNextPredicateID();
        parent.getPredicates().add(this);
    }

    public DefaultPredicate(PredicateType type, Expression parent, AtomicElement value) {
        this(type, parent, value, null, type.isIncludingLowerBound(), type.isIncludingUpperBound());
    }

    public DefaultPredicate(PredicateType type, Expression parent) {
        this(type, parent, null, null, type.isIncludingLowerBound(), type.isIncludingUpperBound());
    }

    protected boolean isNewTypeCompatible(PredicateType type) {
        return this.parent.getDataType().getSupportedPredicateMap().get((Object)this.parent.getType()).contains((Object)type);
    }

    @Override
    public Expression getParent() {
        return this.parent;
    }

    @Override
    public PredicateType getType() {
        return this.type;
    }

    @Override
    public AtomicElement getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public AtomicElement getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean isExclusionPredicate() {
        return this.exclusionPredicate;
    }

    @Override
    public boolean isLowerBoundIncluded() {
        return this.lowerBoundIncluded;
    }

    @Override
    public boolean isUpperBoundIncluded() {
        return this.upperBoundIncluded;
    }

    @Override
    public void setExclusionPredicate(boolean exclusionPredicate) {
        if (exclusionPredicate != this.exclusionPredicate) {
            this.parent.getTreeManager().deletePredicate(this);
            this.exclusionPredicate = exclusionPredicate;
            this.parent.getTreeManager().addPredicate(this);
        }
    }

    @Override
    public void setLowerBound(AtomicElement lowerBound) {
        if (!(lowerBound == this.lowerBound || lowerBound != null && lowerBound.equals(this.lowerBound))) {
            this.lowerBound = lowerBound;
            this.parent.getTreeManager().predicateUpdated(this);
        }
    }

    @Override
    public void setLowerBoundIncluded(boolean lowerBoundIncluded) {
        if (lowerBoundIncluded != this.lowerBoundIncluded) {
            this.lowerBoundIncluded = lowerBoundIncluded;
            this.parent.getTreeManager().predicateUpdated(this);
        }
    }

    @Override
    public void setUpperBound(AtomicElement upperBound) {
        if (!(upperBound == this.upperBound || upperBound != null && upperBound.equals(this.upperBound))) {
            this.upperBound = upperBound;
            this.parent.getTreeManager().predicateUpdated(this);
        }
    }

    @Override
    public void setUpperBoundIncluded(boolean upperBoundIncluded) {
        if (upperBoundIncluded != this.upperBoundIncluded) {
            this.upperBoundIncluded = upperBoundIncluded;
            this.parent.getTreeManager().predicateUpdated(this);
        }
    }

    @Override
    public void setType(PredicateType type) {
        if (!type.equals((Object)this.type)) {
            if (!this.isNewTypeCompatible(type)) {
                throw new IllegalArgumentException("New predicate type not compatible with expression.");
            }
            this.type = type;
            this.parent.getTreeManager().predicateUpdated(this);
        }
    }

    @Override
    public Interval[] getCoveredIntervals() {
        CoverableDataType parentType = this.parent.getDataType();
        switch (this.type) {
            case IS_NULL: 
            case CONSTRAINT_NOT_SATISFIED: {
                return new Interval[0];
            }
            case ISNOT_NULL: {
                return new Interval[]{new DefaultInterval(parentType.getMinValue(), parentType.getMaxValue(), true, true)};
            }
            case LESS_THAN: 
            case LESS_OR_EQUAL: {
                return new Interval[]{new DefaultInterval(parentType.getMinValue(), this.lowerBound, this.type.isIncludingLowerBound(), this.type.isIncludingUpperBound())};
            }
            case GREATER_OR_EQUAL: 
            case GREATER_THAN: {
                return new Interval[]{new DefaultInterval(this.lowerBound, parentType.getMaxValue(), this.type.isIncludingLowerBound(), this.type.isIncludingUpperBound())};
            }
            case EQUALS: {
                return new Interval[]{new DefaultInterval(this.lowerBound, this.lowerBound, this.type.isIncludingLowerBound(), this.type.isIncludingUpperBound())};
            }
            case NOT_EQUALS: {
                DefaultInterval intv = new DefaultInterval(this.lowerBound, parentType.getMaxValue(), false, true);
                if (parentType.getMinValue().equals(this.lowerBound)) {
                    return new Interval[]{intv};
                }
                return new Interval[]{new DefaultInterval(parentType.getMinValue(), this.lowerBound, true, false), intv};
            }
            case IN_INTERVAL: {
                return new Interval[]{new DefaultInterval(this.lowerBound, this.upperBound, this.lowerBoundIncluded, this.upperBoundIncluded)};
            }
            case NOTIN_INTERVAL: {
                return new Interval[]{new DefaultInterval(parentType.getMinValue(), this.lowerBound, true, !this.lowerBoundIncluded), new DefaultInterval(this.upperBound, parentType.getMaxValue(), !this.upperBoundIncluded, true)};
            }
            case IS_TRUE: {
                return new Interval[]{new DefaultInterval(CoverableDataType.BOOLEAN.TRUE, CoverableDataType.BOOLEAN.TRUE, this.type.isIncludingLowerBound(), this.type.isIncludingUpperBound())};
            }
            case IS_FALSE: {
                return new Interval[]{new DefaultInterval(CoverableDataType.BOOLEAN.FALSE, CoverableDataType.BOOLEAN.FALSE, this.type.isIncludingLowerBound(), this.type.isIncludingUpperBound())};
            }
        }
        throw new RuntimeException("Unrecognized predicate type");
    }

    public String toString() {
        switch (this.type) {
            case CONSTRAINT_NOT_SATISFIED: {
                return String.format(this.type.getFormatString(), DefaultVariable.variableListToString(this.parent.getVariableOrder(), "\u00e2\u2030\u00a4"));
            }
        }
        switch (this.type.getNumberOfConstants()) {
            case 0: {
                return String.format(this.type.getFormatString(), this.parent.getLeftHandSide());
            }
            case 1: {
                return String.format(this.type.getFormatString(), this.parent.getLeftHandSide(), this.lowerBound);
            }
        }
        return String.format(this.type.getFormatString(), this.parent.getLeftHandSide(), this.lowerBound, this.upperBound, this.lowerBoundIncluded ? "[" : "(", this.upperBoundIncluded ? "]" : ")");
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof Predicate) {
            ret = this.compareTo((Predicate)obj) == 0;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(Predicate o) {
        if (this.parent != o.getParent()) {
            return this.parent.compareTo(o.getParent());
        }
        if (o.getLowerBound() != null) {
            if (this.getLowerBound() == null) return -1;
            Comparator<Object> comp = this.getParent().getDataType().getComparator();
            int compRes = comp.compare(this.getLowerBound().getValue(), o.getLowerBound().getValue());
            if (compRes != 0) {
                return compRes;
            }
            if (!this.isLowerBoundIncluded() && o.isLowerBoundIncluded()) {
                return 1;
            }
            if (this.isLowerBoundIncluded() && !o.isLowerBoundIncluded()) {
                return -1;
            }
            if (o.getUpperBound() != null) {
                if (this.getUpperBound() == null) return -1;
                compRes = comp.compare(this.getUpperBound().getValue(), o.getUpperBound().getValue());
                if (compRes != 0) {
                    return compRes;
                }
                if (!this.isUpperBoundIncluded() && o.isUpperBoundIncluded()) {
                    return -1;
                }
                if (!this.isUpperBoundIncluded() || o.isUpperBoundIncluded()) return this.getType().compareTo(o.getType());
                return 1;
            }
            if (this.getUpperBound() == null) return this.getType().compareTo(o.getType());
            return 1;
        }
        if (this.getLowerBound() == null) return this.getType().compareTo(o.getType());
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void loadFromXML(Element rootElement) throws DeserializeException {
        try {
            this.type = PredicateType.valueOf(rootElement.getAttribute("type"));
            this.ID = Long.parseLong(rootElement.getAttribute("id"));
            this.parent.getTreeManager().predicateIDInUse(this.ID);
            this.exclusionPredicate = Boolean.parseBoolean(rootElement.getAttribute("exclusive"));
            NodeList childNodes = rootElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                String serializedValue;
                CoverableDataType dataType;
                String kind;
                Node node = childNodes.item(i);
                if (node.getNodeName().equals("lowerBound")) {
                    this.lowerBoundIncluded = Boolean.parseBoolean(((Element)node).getAttribute("included"));
                    kind = ((Element)node).getAttribute("kind");
                    if (kind.equals("null")) {
                        this.lowerBound = null;
                    } else if (kind.equals("variable")) {
                        this.lowerBound = this.parent.getTreeManager().getVariables().getKnownVariables().get(node.getChildNodes().item(0).getNodeValue());
                    } else {
                        if (!kind.equals("constant")) throw new DeserializeException("Unknown lower bound kind.");
                        dataType = (CoverableDataType)GenericUserObjectDataType.lookupDataType(Class.forName(((Element)node).getAttribute("dataType")));
                        serializedValue = node.hasChildNodes() ? node.getChildNodes().item(0).getNodeValue() : "";
                        this.lowerBound = new DefaultConstant(dataType, dataType.deserializeValue(serializedValue));
                    }
                } else if (node.getNodeName().equals("upperBound")) {
                    this.upperBoundIncluded = Boolean.parseBoolean(((Element)node).getAttribute("included"));
                    kind = ((Element)node).getAttribute("kind");
                    if (kind.equals("null")) {
                        this.upperBound = null;
                    } else if (kind.equals("variable")) {
                        this.upperBound = this.parent.getTreeManager().getVariables().getKnownVariables().get(node.getChildNodes().item(0).getNodeValue());
                    } else {
                        if (!kind.equals("constant")) throw new DeserializeException("Unknown upper bound kind.");
                        dataType = (CoverableDataType)GenericUserObjectDataType.lookupDataType(Class.forName(((Element)node).getAttribute("dataType")));
                        serializedValue = node.hasChildNodes() ? node.getChildNodes().item(0).getNodeValue() : "";
                        this.upperBound = new DefaultConstant(dataType, dataType.deserializeValue(serializedValue));
                    }
                }
                ++i;
            }
            return;
        }
        catch (DOMException e) {
            throw new DeserializeException("Error deserialising this predicate", e);
        }
        catch (ClassNotFoundException e) {
            throw new DeserializeException("Error deserialising this predicate", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveToXML(Element rootElement, Document parentDoc) {
        Variable v;
        Constant c;
        rootElement.setAttributeNS(null, "type", this.type.name());
        rootElement.setAttributeNS(null, "id", Long.toString(this.ID));
        rootElement.setAttributeNS(null, "exclusive", String.valueOf(this.exclusionPredicate));
        Element elem = parentDoc.createElement("lowerBound");
        elem.setAttributeNS(null, "included", String.valueOf(this.lowerBoundIncluded));
        if (this.lowerBound != null) {
            if (this.lowerBound instanceof Constant) {
                c = (Constant)this.lowerBound;
                elem.setAttributeNS(null, "kind", "constant");
                elem.setAttributeNS(null, "dataType", c.getDataType().getJavaDataType().getName());
                elem.appendChild(parentDoc.createTextNode(c.getDataType().serializeValue(c.getValue())));
            } else {
                if (!(this.lowerBound instanceof Variable)) throw new RuntimeException("Serialisation for this bound type not supported.");
                v = (Variable)this.lowerBound;
                elem.setAttributeNS(null, "kind", "variable");
                elem.appendChild(parentDoc.createTextNode(v.getName()));
            }
        } else {
            elem.setAttributeNS(null, "kind", "null");
        }
        rootElement.appendChild(elem);
        elem = parentDoc.createElement("upperBound");
        elem.setAttributeNS(null, "included", String.valueOf(this.upperBoundIncluded));
        if (this.upperBound != null) {
            if (this.upperBound instanceof Constant) {
                c = (Constant)this.upperBound;
                elem.setAttributeNS(null, "kind", "constant");
                elem.setAttributeNS(null, "dataType", c.getDataType().getJavaDataType().getName());
                elem.appendChild(parentDoc.createTextNode(c.getDataType().serializeValue(c.getValue())));
            } else {
                if (!(this.upperBound instanceof Variable)) throw new RuntimeException("Serialisation for this bound type not supported.");
                v = (Variable)this.upperBound;
                elem.setAttributeNS(null, "kind", "variable");
                elem.appendChild(parentDoc.createTextNode(v.getName()));
            }
        } else {
            elem.setAttributeNS(null, "kind", "null");
        }
        rootElement.appendChild(elem);
    }

    @Override
    public long getID() {
        return this.ID;
    }

    protected InstructionHandle writeCompare(CodeGenerator gen, int expressionIndex, int comparatorVarIndex, AtomicElement bound) {
        Method compareMethod;
        try {
            compareMethod = Comparator.class.getDeclaredMethod("compare", Object.class, Object.class);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        gen.addGetLocalVariable(comparatorVarIndex, Comparator.class);
        InstructionHandle ih = gen.getLastFirstInstruction();
        gen.addGetLocalVariable(1, Object[].class);
        gen.addGetArray(expressionIndex, Object.class);
        if (bound instanceof Variable) {
            gen.addLoadVariable((Variable)bound, Object.class);
        } else {
            gen.addLoadConstant((Constant)bound);
        }
        gen.addMethodCall(compareMethod);
        return ih;
    }

    @Override
    public InstructionHandle writeCode(CodeGenerator gen, int expressionIndex, int comparatorVarIndex, List<BranchInstruction> noMatchJumps, List<BranchInstruction> matchJumps) {
        InstructionHandle ih = null;
        CoverableDataType dataType = this.parent.getDataType();
        switch (this.type) {
            case IS_NULL: {
                gen.addGetLocalVariable(1, Object[].class);
                ih = gen.getLastFirstInstruction();
                gen.addGetArray(expressionIndex, Object.class);
                IFNONNULL nullJump = new IFNONNULL(null);
                noMatchJumps.add((BranchInstruction)nullJump);
                gen.addBranchInstruction((BranchInstruction)nullJump);
                break;
            }
            case ISNOT_NULL: {
                gen.addGetLocalVariable(1, Object[].class);
                ih = gen.getLastFirstInstruction();
                gen.addGetArray(expressionIndex, Object.class);
                IFNULL nullJump = new IFNULL(null);
                noMatchJumps.add((BranchInstruction)nullJump);
                gen.addBranchInstruction((BranchInstruction)nullJump);
                break;
            }
            case CONSTRAINT_NOT_SATISFIED: {
                Method compareMethod;
                List<Variable> variableOrder = this.parent.getVariableOrder();
                try {
                    compareMethod = Comparator.class.getDeclaredMethod("compare", Object.class, Object.class);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                int i = 0;
                while (i < variableOrder.size() - 1) {
                    gen.addGetLocalVariable(comparatorVarIndex, Comparator.class);
                    if (ih == null) {
                        ih = gen.getLastFirstInstruction();
                    }
                    gen.addLoadVariable(variableOrder.get(i), Object.class);
                    gen.addLoadVariable(variableOrder.get(i + 1), Object.class);
                    gen.addMethodCall(compareMethod);
                    IFGT cmpJmp = new IFGT(null);
                    matchJumps.add((BranchInstruction)cmpJmp);
                    gen.addBranchInstruction((BranchInstruction)cmpJmp);
                    ++i;
                }
                GOTO noMatchJump = new GOTO(null);
                noMatchJumps.add((BranchInstruction)noMatchJump);
                gen.addBranchInstruction((BranchInstruction)noMatchJump);
                break;
            }
            default: {
                if (this.isExclusionPredicate()) {
                    gen.addGetLocalVariable(1, Object[].class);
                    ih = gen.getLastFirstInstruction();
                    gen.addGetArray(expressionIndex, Object.class);
                    IFNULL nullJump = new IFNULL(null);
                    noMatchJumps.add((BranchInstruction)nullJump);
                    gen.addBranchInstruction((BranchInstruction)nullJump);
                }
                IFNE nextJmp1 = null;
                IFLT nextJmp2 = null;
                Interval[] intervalArray = this.getCoveredIntervals();
                int n = intervalArray.length;
                int n2 = 0;
                while (n2 < n) {
                    InstructionHandle ihtmp;
                    Interval intvl = intervalArray[n2];
                    AtomicElement lowerBound = intvl.getLowerBound();
                    AtomicElement upperBound = intvl.getUpperBound();
                    if (lowerBound.getClass().isAssignableFrom(upperBound.getClass()) && lowerBound.equals(upperBound)) {
                        IFNE cmpJmp;
                        ihtmp = this.writeCompare(gen, expressionIndex, comparatorVarIndex, lowerBound);
                        if (ih == null) {
                            ih = ihtmp;
                        }
                        if (nextJmp1 != null) {
                            nextJmp1.setTarget(ihtmp);
                        }
                        if (nextJmp2 != null) {
                            nextJmp2.setTarget(ihtmp);
                            nextJmp2 = null;
                        }
                        nextJmp1 = cmpJmp = new IFNE(null);
                        gen.addBranchInstruction((BranchInstruction)cmpJmp);
                    } else {
                        Object cmpJmp;
                        boolean haveLowerBound = false;
                        if (!(lowerBound instanceof Constant) || !lowerBound.equals(dataType.getMinValue())) {
                            ihtmp = this.writeCompare(gen, expressionIndex, comparatorVarIndex, lowerBound);
                            if (ih == null) {
                                ih = ihtmp;
                            }
                            if (nextJmp1 != null) {
                                nextJmp1.setTarget(ihtmp);
                            }
                            if (nextJmp2 != null) {
                                nextJmp2.setTarget(ihtmp);
                                nextJmp2 = null;
                            }
                            cmpJmp = intvl.isLowerBoundIncluded() ? new IFLT(null) : new IFLE(null);
                            nextJmp1 = cmpJmp;
                            gen.addBranchInstruction((BranchInstruction)cmpJmp);
                            haveLowerBound = true;
                        }
                        if (!(upperBound instanceof Constant) || !upperBound.equals(dataType.getMaxValue())) {
                            ihtmp = this.writeCompare(gen, expressionIndex, comparatorVarIndex, upperBound);
                            if (ih == null) {
                                ih = ihtmp;
                            }
                            if (!haveLowerBound) {
                                if (nextJmp1 != null) {
                                    nextJmp1.setTarget(ihtmp);
                                    nextJmp1 = null;
                                }
                                if (nextJmp2 != null) {
                                    nextJmp2.setTarget(ihtmp);
                                }
                            }
                            cmpJmp = intvl.isUpperBoundIncluded() ? new IFGT(null) : new IFGE(null);
                            nextJmp2 = cmpJmp;
                            gen.addBranchInstruction((BranchInstruction)cmpJmp);
                        }
                    }
                    GOTO matchJump = new GOTO(null);
                    matchJumps.add((BranchInstruction)matchJump);
                    ihtmp = gen.addBranchInstruction((BranchInstruction)matchJump);
                    if (ih == null) {
                        ih = ihtmp;
                    }
                    ++n2;
                }
                if (nextJmp1 != null) {
                    noMatchJumps.add((BranchInstruction)nextJmp1);
                }
                if (nextJmp2 == null) break;
                noMatchJumps.add((BranchInstruction)nextJmp2);
            }
        }
        return ih;
    }
}

