/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultConstant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.CodeGenerator;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.SubExpression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.UnaryOperator;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import java.util.Set;
import org.apache.bcel.generic.InstructionHandle;

public class DefaultUnaryOperation
implements SubExpression,
UnaryOperator {
    protected SubExpression expression;
    protected OperatorType operator;

    public DefaultUnaryOperation(OperatorType operator, SubExpression expression) {
        this.operator = operator;
        this.expression = expression;
    }

    @Override
    public DataType getDataType() {
        return this.expression.getDataType();
    }

    @Override
    public int getNumberOfElements() {
        return this.expression.getNumberOfElements();
    }

    @Override
    public Object getValue() {
        return this.getDataType().applyUnaryOperator(this.expression.getValue(), this.operator);
    }

    @Override
    public SubExpression getExpression() {
        return this.expression;
    }

    @Override
    public OperatorType getOperator() {
        return this.operator;
    }

    public String toString() {
        return String.valueOf(this.operator.toString()) + this.expression.toString();
    }

    @Override
    public SubExpression makeRunnable() {
        this.expression = this.expression.makeRunnable();
        if (this.expression instanceof Constant) {
            return new DefaultConstant((CoverableDataType)this.getDataType(), this.getValue());
        }
        return this;
    }

    @Override
    public void determineUsedVariables(Set<Variable> vars) {
        this.expression.determineUsedVariables(vars);
    }

    @Override
    public InstructionHandle writeCode(CodeGenerator gen, Class<?> desiredType) {
        Class<?> stackType = gen.addPrepareOperation(this.expression.getDataType(), 1);
        InstructionHandle ih = gen.getLastFirstInstruction();
        this.expression.writeCode(gen, stackType);
        gen.addUnaryOperation(stackType, this.operator);
        gen.addCast(stackType, desiredType);
        return ih;
    }

    @Override
    public boolean canBeNull() {
        return this.expression.canBeNull();
    }
}

