/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultAtomicElement;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.CodeGenerator;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.SubExpression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.VariableManager;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.bcel.generic.InstructionHandle;

public class DefaultVariable
extends DefaultAtomicElement
implements Variable {
    protected static final String E_ILLEGAL_IDENTIFIER_NAME = "Illegal identifier name! An identifier must start with a character between a and z followed by alphanumeric characters (a-z or 0-9) or underscores (_). Other characters like white spaces, ?, etc. are not allowed in the parameter name.";
    protected static final String E_EMPTY_VARIABLE_NAME = "Empty variable names are not allowed!";
    protected static final String E_VAR_ALREADY_EXISTS = "A variable with this name already exists!";
    protected static final Pattern NAME_PATTERN = Pattern.compile("^[a-zA-Z_]\\w*");
    protected String name;
    protected boolean canBeNull;
    protected int relativePosition = -1;
    protected Object value = null;
    protected VariableManager manager;

    public DefaultVariable(DataType type, String name, boolean canBeNull, VariableManager manager) {
        super(type);
        this.manager = manager;
        this.canBeNull = canBeNull;
        this.checkVarName(name);
        this.name = name;
    }

    protected void checkVarName(String name) {
        String errMsg = DefaultVariable.checkVariableName(name, this.name, this.manager);
        if (errMsg != null) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        if (this.manager.isAtRuntime()) {
            return this.value;
        }
        return ((CoverableDataType)this.getDataType()).getVariableDummy(this.relativePosition);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public SubExpression makeRunnable() {
        return this;
    }

    @Override
    public void determineUsedVariables(Set<Variable> vars) {
        vars.add(this);
    }

    @Override
    public int getTopologicalPosition() {
        return this.relativePosition;
    }

    @Override
    public void setTopologicalPosition(int position) {
        this.relativePosition = position;
    }

    @Override
    public InstructionHandle writeCode(CodeGenerator gen, Class<?> desiredType) {
        gen.addLoadVariable(this, desiredType);
        return gen.getLastFirstInstruction();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        String otherName = ((Variable)obj).getName();
        return otherName != null && otherName.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void setValue(Object newValue) {
        this.value = newValue;
    }

    @Override
    public void setName(String name) {
        if (!name.equals(this.name)) {
            this.checkVarName(name);
            this.manager.getKnownVariables().remove(this.name);
            this.name = name;
            this.manager.getKnownVariables().put(name, this);
        }
    }

    public static String variableListToString(List<Variable> varList, String separator) {
        StringBuilder relSizes = new StringBuilder();
        int i = 0;
        while (i < varList.size()) {
            Variable var = varList.get(i);
            relSizes.append(var.getName()).append(separator);
            ++i;
        }
        if (relSizes.length() > 0) {
            relSizes.delete(relSizes.length() - separator.length(), relSizes.length());
        }
        return relSizes.toString();
    }

    public static String checkVariableName(String newName, String oldName, VariableManager manager) {
        if (newName == null || newName.trim().equals("")) {
            return E_EMPTY_VARIABLE_NAME;
        }
        if (oldName != null && newName.equals(oldName)) {
            return null;
        }
        if (!NAME_PATTERN.matcher(newName).matches()) {
            return E_ILLEGAL_IDENTIFIER_NAME;
        }
        if (manager.getKnownVariables().containsKey(newName)) {
            return E_VAR_ALREADY_EXISTS;
        }
        return null;
    }

    @Override
    public boolean canBeNull() {
        return this.canBeNull;
    }
}

