/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultVariable;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.VariableManager;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class DefaultVariableManager
implements VariableManager {
    protected BranchTreeManager parent;
    protected Map<String, Variable> knownVariables = new HashMap<String, Variable>();
    protected Map<String, Object> valueView;
    protected boolean atRuntime = false;

    public DefaultVariableManager(BranchTreeManager parent) {
        this.parent = parent;
    }

    @Override
    public Map<String, Object> getValueView() {
        if (this.valueView == null) {
            this.valueView = new ValueMap();
        }
        return this.valueView;
    }

    @Override
    public Variable addVariable(String name, DataType type, boolean canBeNull) {
        DefaultVariable res = new DefaultVariable(type, name, canBeNull, this);
        this.knownVariables.put(name, res);
        return res;
    }

    @Override
    public boolean removeVariable(Variable var) {
        boolean rv = false;
        ListIterator<Expression> exprIt = this.parent.getExpressionList().listIterator();
        while (exprIt.hasNext()) {
            Expression expr = exprIt.next();
            if (expr.getLHSVariables().contains(var)) {
                exprIt.remove();
                rv = true;
                continue;
            }
            ListIterator<Predicate> predIt = expr.getPredicates().listIterator();
            while (predIt.hasNext()) {
                Predicate pred = predIt.next();
                if (pred.getLowerBound() != null && pred.getLowerBound().equals(var)) {
                    predIt.remove();
                    rv = true;
                    continue;
                }
                if (pred.getUpperBound() == null || !pred.getUpperBound().equals(var)) continue;
                predIt.remove();
                rv = true;
            }
        }
        this.knownVariables.remove(var.getName());
        return rv;
    }

    @Override
    public boolean isAtRuntime() {
        return this.atRuntime;
    }

    @Override
    public void setAtRuntime(boolean atRuntime) {
        this.atRuntime = atRuntime;
    }

    @Override
    public Map<String, Variable> getKnownVariables() {
        return this.knownVariables;
    }

    protected class ValueMap
    extends AbstractMap<String, Object> {
        protected final Set<Map.Entry<String, Object>> entrySet = new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new ValueIterator(((ValueMap)ValueMap.this).DefaultVariableManager.this.knownVariables.entrySet().iterator());
            }

            @Override
            public int size() {
                return ((ValueMap)ValueMap.this).DefaultVariableManager.this.knownVariables.size();
            }
        };

        protected ValueMap() {
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.entrySet;
        }

        @Override
        public boolean containsKey(Object key) {
            return DefaultVariableManager.this.knownVariables.containsKey(key);
        }

        @Override
        public Set<String> keySet() {
            return DefaultVariableManager.this.knownVariables.keySet();
        }

        @Override
        public Object get(Object key) {
            Variable val = DefaultVariableManager.this.knownVariables.get(key);
            if (val == null) {
                return null;
            }
            return val.getValue();
        }

        protected class ValueEntry
        implements Map.Entry<String, Object> {
            protected Map.Entry<String, Variable> variableEntry;

            @Override
            public String getKey() {
                return this.variableEntry.getKey();
            }

            @Override
            public Object getValue() {
                return this.variableEntry.getValue().getValue();
            }

            @Override
            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public ValueEntry(Map.Entry<String, Variable> variableEntry) {
                this.variableEntry = variableEntry;
            }
        }

        protected class ValueIterator
        implements Iterator<Map.Entry<String, Object>> {
            protected Iterator<Map.Entry<String, Variable>> variableIterator;

            @Override
            public boolean hasNext() {
                return this.variableIterator.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                Map.Entry<String, Variable> nextVar = this.variableIterator.next();
                return new ValueEntry(nextVar);
            }

            @Override
            public void remove() {
                this.variableIterator.remove();
            }

            public ValueIterator(Iterator<Map.Entry<String, Variable>> variableIterator) {
                this.variableIterator = variableIterator;
            }
        }
    }
}

