/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import java.util.ArrayList;
import java.util.Collection;

public class ExpressionList
extends ArrayList<Expression> {
    private static final long serialVersionUID = -7012187048912515940L;
    protected BranchTreeManager treeManager;

    public ExpressionList(BranchTreeManager associatedManager) {
        this.treeManager = associatedManager;
    }

    public ExpressionList(int arg0, BranchTreeManager associatedManager) {
        super(arg0);
        this.treeManager = associatedManager;
    }

    public ExpressionList(Collection arg0, BranchTreeManager associatedManager) {
        super(arg0);
        this.treeManager = associatedManager;
    }

    protected void addAllPredicates(Expression ex) {
        for (Predicate p : ex.getPredicates()) {
            this.treeManager.addPredicate(p);
        }
    }

    @Override
    public boolean add(Expression o) {
        boolean res = super.add(o);
        if (res) {
            this.addAllPredicates(o);
        }
        return res;
    }

    @Override
    public void add(int index, Expression element) {
        super.add(index, element);
        this.addAllPredicates(element);
    }

    @Override
    public boolean addAll(Collection<? extends Expression> c) {
        boolean res = super.addAll(c);
        if (res) {
            for (Expression expression : c) {
                this.addAllPredicates(expression);
            }
        }
        return res;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Expression> c) {
        boolean res = super.addAll(index, c);
        if (res) {
            for (Expression expression : c) {
                this.addAllPredicates(expression);
            }
        }
        return res;
    }

    @Override
    public void clear() {
        super.clear();
        this.treeManager.rebuildTree();
    }

    @Override
    public Expression remove(int index) {
        Expression res = (Expression)super.remove(index);
        this.treeManager.rebuildTree();
        return res;
    }

    @Override
    public boolean remove(Object o) {
        boolean res = super.remove(o);
        if (res) {
            this.treeManager.rebuildTree();
        }
        return res;
    }

    @Override
    public Expression set(int index, Expression element) {
        if (element != this.get(index)) {
            Expression res = super.set(index, element);
            this.treeManager.rebuildTree();
            return res;
        }
        return element;
    }
}

