/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation;

import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ExpressionType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class PredicateList
extends ArrayList<Predicate> {
    private static final long serialVersionUID = 1L;
    protected Expression parent;
    protected BranchTreeManager treeManager;

    public PredicateList(Expression parent, BranchTreeManager treeManager) {
        this.parent = parent;
        this.treeManager = treeManager;
    }

    protected void checkPredicate(Predicate pred) throws IllegalArgumentException {
        CoverableDataType ty = this.parent.getDataType();
        if (ty == null) {
            return;
        }
        if (!ty.getSupportedExpressionTypes().contains((Object)this.parent.getType())) {
            throw new IllegalArgumentException("Expression type not supported by data type or expression type not properly initialised.");
        }
        if (!ty.getSupportedPredicateMap().get((Object)this.parent.getType()).contains((Object)pred.getType())) {
            throw new IllegalArgumentException("Predicate type not supported.");
        }
    }

    public boolean isPredicateListCompatibleTo(ExpressionType newType, CoverableDataType ty) {
        Set<PredicateType> supportedPreds = ty.getSupportedPredicateMap().get((Object)newType);
        for (Predicate pred : this) {
            if (supportedPreds.contains((Object)pred.getType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(int index, Predicate element) {
        this.checkPredicate(element);
        super.add(index, element);
        this.treeManager.addPredicate(element);
    }

    @Override
    public boolean add(Predicate o) {
        this.checkPredicate(o);
        boolean res = super.add(o);
        this.treeManager.addPredicate(o);
        return res;
    }

    @Override
    public boolean addAll(Collection<? extends Predicate> c) {
        for (Predicate predicate : c) {
            this.checkPredicate(predicate);
        }
        boolean bl = super.addAll(c);
        for (Predicate predicate : c) {
            this.treeManager.addPredicate(predicate);
        }
        return bl;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Predicate> c) {
        for (Predicate predicate : c) {
            this.checkPredicate(predicate);
        }
        boolean bl = super.addAll(index, c);
        for (Predicate predicate : c) {
            this.treeManager.addPredicate(predicate);
        }
        return bl;
    }

    @Override
    public Predicate remove(int arg0) {
        Predicate res = (Predicate)super.remove(arg0);
        this.treeManager.deletePredicate(res);
        return res;
    }

    @Override
    public boolean remove(Object arg0) {
        boolean res = super.remove(arg0);
        this.treeManager.deletePredicate((Predicate)arg0);
        return res;
    }

    @Override
    public void clear() {
        for (Predicate p : this) {
            this.treeManager.deletePredicate(p);
        }
        super.clear();
    }
}

