/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.parser;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultArithmeticExpression;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultFunctionCall;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultMethodCall;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultUnaryOperation;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.DelimiterSymbol;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.IdentifierSymbol;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.ParserException;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.ParserFunctions;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.Scanner;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.ScannerSymbolInformation;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.ArithmeticExpression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.FunctionCall;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.MethodCall;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.MethodOwner;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.SubExpression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.VariableManager;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.FunctionSignature;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.UserObjectDataType;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Parser {
    protected static final String ERROR_NO_PRIMITIVE_RETURN_TYPE = "The return type of this expression is not a primitive type!";
    protected static final String ERROR_WRONG_ARGUMENT = "No overload of \"%s\" accepts a parameter of type \"%s\" here!";
    protected static final String ERROR_UNKNOWN_METHOD = "Class \"%s\" has no method called \"%s\"!";
    protected static final String ERROR_METHOD_NAME_EXPECTED = "Method name expected!";
    protected static final String ERROR_PRIMITIVE_DATATYPE_METHOD_CALL = "Variable \"%s\" is a primitive object and does not allow method calls!";
    protected static final String ERROR_UNKNOWN_IDENTIFIER = "Unknown identifier \"%s\"!";
    protected static final String ERROR_CLOSING_BRACKET_OR_COMMA_EXPECTED = "\",\" or \")\" expected!";
    protected static final String ERROR_BAD_NUMBER_OF_PARAMS = "The actual number of parameters differs from the required number of parameters!";
    protected static final String ERROR_OPENING_BRACKET_EXPECTED = "\"(\" expected!";
    protected static final String ERROR_INCOMPATIBLE_TYPES = "Operands of expression have incompatible types!";
    protected static final String ERROR_OPERATOR_NOT_APPLICABLE = "Operator \"%s\" is not applicable to operand type \"%s\"";
    protected static final String ERROR_CLOSING_BRACKET_EXPECTED = "\")\" expected!";
    protected static final String ERROR_UNEXPECTED_SYMBOL = "Unexpected symbol!";
    protected static final String ERROR_UNEXPECTED_END_OF_EXPRESSION = "Unexpected end of expression!";
    private static List<ScannerSymbolInformation> symbols;
    private static int scannerPosition;
    private static ScannerSymbolInformation current;
    private static boolean finishedCorrectly;
    private static VariableManager manager;
    public static final Map<String, List<FunctionSignature>> knownFunctions;

    static {
        knownFunctions = new HashMap<String, List<FunctionSignature>>();
        Parser.registerAllStaticMethods(ParserFunctions.class);
        Parser.registerAllStaticMethods(Math.class);
    }

    public static void registerAllStaticMethods(Class<?> c) {
        Method[] methodArray = c.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if ((m.getModifiers() & 8) != 0) {
                Parser.registerFunction(m.getName(), m);
            }
            ++n2;
        }
    }

    public static void registerFunction(String name, Method method) {
        List<Object> l;
        if ((method.getModifiers() & 8) == 0) {
            throw new IllegalArgumentException("Static method expected!");
        }
        FunctionSignature f = new FunctionSignature(GenericUserObjectDataType.lookupDataType(method.getReturnType()), method, method.getName());
        int insertionIndex = Integer.MIN_VALUE;
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            f.getParameters().add(GenericUserObjectDataType.lookupDataType(c));
            ++n2;
        }
        if (!knownFunctions.containsKey(name)) {
            l = new LinkedList();
            knownFunctions.put(name, l);
        } else {
            l = knownFunctions.get(name);
            insertionIndex = Collections.binarySearch(l, f);
        }
        if (insertionIndex < 0) {
            if (insertionIndex != Integer.MIN_VALUE) {
                l.add(-insertionIndex - 1, f);
            } else {
                l.add(f);
            }
        } else {
            int scoring = FunctionSignature.checkConcurrentMethods(f, (FunctionSignature)l.get(insertionIndex));
            if (scoring == 0) {
                l.add(insertionIndex, f);
            } else if (scoring > 0) {
                l.set(insertionIndex, f);
            }
        }
    }

    private static void scan() {
        if (scannerPosition >= symbols.size()) {
            throw new ParserException(ERROR_UNEXPECTED_END_OF_EXPRESSION, Parser.current.endPosition, Parser.current.endPosition);
        }
        current = symbols.get(scannerPosition++);
    }

    private static void pushBack() {
        current = scannerPosition > 1 ? symbols.get(--scannerPosition - 1) : symbols.get(0);
    }

    private static boolean endReached() {
        return scannerPosition == symbols.size();
    }

    public static SubExpression parse(String input, VariableManager manager) {
        symbols = Scanner.scan(String.valueOf(input) + " ");
        scannerPosition = 0;
        finishedCorrectly = false;
        Parser.manager = manager;
        if (symbols.size() == 0) {
            return null;
        }
        SubExpression ex = Parser.parseSubExpression();
        if (!finishedCorrectly) {
            throw new ParserException(ERROR_UNEXPECTED_SYMBOL, Parser.current.startPosition, Parser.current.endPosition);
        }
        if (!(ex.getDataType() instanceof CoverableDataType)) {
            throw new ParserException(ERROR_NO_PRIMITIVE_RETURN_TYPE, Parser.symbols.get((int)0).startPosition, Parser.current.endPosition);
        }
        return ex;
    }

    private static SubExpression parseSubExpression() {
        SubExpression res = null;
        do {
            SubExpression tmp;
            Parser.scan();
            boolean subExpr = false;
            OperatorType unOp = null;
            if (Parser.current.symbol instanceof OperatorType && ((OperatorType)Parser.current.symbol).isUnary()) {
                unOp = (OperatorType)Parser.current.symbol;
                Parser.scan();
            }
            if (Parser.current.symbol == DelimiterSymbol.OPENING_BRACKET) {
                subExpr = res == null;
                tmp = Parser.parseSubExpression();
                Parser.scan();
                if (Parser.current.symbol != DelimiterSymbol.CLOSING_BRACKET) {
                    throw new ParserException(ERROR_CLOSING_BRACKET_EXPECTED, Parser.current.startPosition, Parser.current.endPosition);
                }
            } else if (Parser.current.symbol instanceof IdentifierSymbol) {
                String id = ((IdentifierSymbol)Parser.current.symbol).name;
                if (knownFunctions.containsKey(id)) {
                    tmp = Parser.parseFunctionCall(knownFunctions.get(((IdentifierSymbol)Parser.current.symbol).name));
                } else {
                    boolean needsPushBack = false;
                    if (!Parser.endReached()) {
                        needsPushBack = true;
                        Parser.scan();
                    }
                    if (!Parser.endReached() && Parser.current.symbol == DelimiterSymbol.DOT) {
                        if (needsPushBack) {
                            Parser.pushBack();
                        }
                        tmp = Parser.parseMethodCall();
                    } else {
                        if (needsPushBack) {
                            Parser.pushBack();
                        }
                        tmp = Parser.parseVariable();
                    }
                }
            } else if (Parser.current.symbol instanceof Constant) {
                tmp = (Constant)Parser.current.symbol;
            } else {
                throw new ParserException(ERROR_UNEXPECTED_SYMBOL, Parser.current.startPosition, Parser.current.endPosition);
            }
            if (unOp != null) {
                if (!tmp.getDataType().getSupportedUnaryOperators().contains(unOp)) {
                    throw new ParserException(String.format(ERROR_OPERATOR_NOT_APPLICABLE, unOp, tmp.getDataType()), Parser.current.startPosition, Parser.current.endPosition);
                }
                tmp = new DefaultUnaryOperation(unOp, tmp);
            }
            if (res == null) {
                res = tmp;
            } else if (res instanceof ArithmeticExpression && !subExpr) {
                if (res.getDataType().isDataTypeCompatible(tmp.getDataType())) {
                    ((ArithmeticExpression)res).getSubExpressions().add(tmp);
                } else {
                    throw new ParserException(ERROR_INCOMPATIBLE_TYPES, Parser.current.startPosition, Parser.current.endPosition);
                }
            }
            if (Parser.endReached()) {
                finishedCorrectly = true;
                break;
            }
            Parser.scan();
            if (!(Parser.current.symbol instanceof OperatorType) || !((OperatorType)Parser.current.symbol).isBinary()) continue;
            OperatorType op = (OperatorType)Parser.current.symbol;
            if (!res.getDataType().getSupportedBinaryOperators().contains(op)) {
                throw new ParserException(String.format(ERROR_OPERATOR_NOT_APPLICABLE, op, res.getDataType()), Parser.current.startPosition, Parser.current.endPosition);
            }
            if (!(res instanceof ArithmeticExpression) || subExpr) {
                tmp = res;
                res = new DefaultArithmeticExpression();
                ((ArithmeticExpression)res).getSubExpressions().add(tmp);
                ((ArithmeticExpression)res).getOperators().add(op);
                continue;
            }
            ((ArithmeticExpression)res).getOperators().add(op);
        } while (Parser.current.symbol instanceof OperatorType && ((OperatorType)Parser.current.symbol).isBinary());
        Parser.pushBack();
        return res;
    }

    private static FunctionCall parseFunctionCall(List<FunctionSignature> sig) {
        LinkedList<FunctionSignature> possibleSigs = new LinkedList<FunctionSignature>();
        possibleSigs.addAll(sig);
        DefaultFunctionCall res = new DefaultFunctionCall(((IdentifierSymbol)Parser.current.symbol).name);
        Parser.scan();
        if (Parser.current.symbol != DelimiterSymbol.OPENING_BRACKET) {
            throw new ParserException(ERROR_OPENING_BRACKET_EXPECTED, Parser.current.startPosition, Parser.current.endPosition);
        }
        Parser.scan();
        int numParams = 0;
        FunctionSignature fitting = sig.get(0);
        while (Parser.current.symbol != DelimiterSymbol.CLOSING_BRACKET) {
            if (numParams == 0) {
                Parser.pushBack();
            }
            SubExpression e = Parser.parseSubExpression();
            fitting = null;
            Iterator it = possibleSigs.iterator();
            while (it.hasNext()) {
                FunctionSignature f = (FunctionSignature)it.next();
                if (f.getParameters().size() > numParams && f.getParameters().get(numParams).isDataTypeCompatible(e.getDataType())) {
                    fitting = f;
                    break;
                }
                it.remove();
            }
            if (fitting == null) {
                throw new ParserException(String.format(ERROR_WRONG_ARGUMENT, res.getFuncName(), e.getDataType()), Parser.current.startPosition, Parser.current.endPosition);
            }
            ++numParams;
            res.getParameters().add(e);
            Parser.scan();
            if (Parser.current.symbol == DelimiterSymbol.COMMA || Parser.current.symbol == DelimiterSymbol.CLOSING_BRACKET) continue;
            throw new ParserException(ERROR_CLOSING_BRACKET_OR_COMMA_EXPECTED, Parser.current.startPosition, Parser.current.endPosition);
        }
        if (numParams != fitting.getParameters().size()) {
            throw new ParserException(ERROR_BAD_NUMBER_OF_PARAMS, Parser.current.startPosition, Parser.current.endPosition);
        }
        res.setResultType(fitting.getResultType());
        res.setMethod(fitting.getMethod());
        return res;
    }

    private static Variable parseVariable() {
        String id = ((IdentifierSymbol)Parser.current.symbol).getName();
        if (!manager.getKnownVariables().containsKey(id)) {
            throw new ParserException(String.format(ERROR_UNKNOWN_IDENTIFIER, id), Parser.current.startPosition, Parser.current.endPosition);
        }
        return manager.getKnownVariables().get(id);
    }

    private static MethodCall parseMethodCall() {
        MethodOwner owner = Parser.parseVariable();
        Parser.scan();
        do {
            if (!(owner.getDataType() instanceof UserObjectDataType)) {
                throw new ParserException(String.format(ERROR_PRIMITIVE_DATATYPE_METHOD_CALL, owner), Parser.current.startPosition, Parser.current.endPosition);
            }
            Parser.scan();
            if (!(Parser.current.symbol instanceof IdentifierSymbol)) {
                throw new ParserException(ERROR_METHOD_NAME_EXPECTED, Parser.current.startPosition, Parser.current.endPosition);
            }
            String methodName = ((IdentifierSymbol)Parser.current.symbol).getName();
            UserObjectDataType type = (UserObjectDataType)((Object)owner.getDataType());
            if (!type.getMethods().containsKey(methodName)) {
                throw new ParserException(String.format(ERROR_UNKNOWN_METHOD, type, methodName), Parser.current.startPosition, Parser.current.endPosition);
            }
            FunctionCall call = Parser.parseFunctionCall(type.getMethods().get(methodName));
            owner = new DefaultMethodCall(call, owner);
            if (Parser.endReached()) continue;
            Parser.scan();
        } while (!Parser.endReached() && Parser.current.symbol == DelimiterSymbol.DOT);
        if (!Parser.endReached()) {
            Parser.pushBack();
        }
        return (MethodCall)owner;
    }
}

