/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.parser;

import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import java.util.Date;
import java.util.GregorianCalendar;

public class ParserFunctions {
    public static long strToInt(String value) {
        return Long.parseLong(value);
    }

    public static double strToReal(String value) {
        return Double.parseDouble(value);
    }

    public static long toInt(double d) {
        return (long)d;
    }

    public static double toReal(long i) {
        return i;
    }

    public static String toString(Object o) {
        DataType dataType = GenericUserObjectDataType.knownUserDataTypes.get(o.getClass());
        if (dataType != null) {
            return dataType.valueToString(o);
        }
        return o.toString();
    }

    public static Date strToDate(String value) {
        Date rv = CoverableDataType.DATE.parseDate(value);
        if (rv == null) {
            throw new RuntimeException("Invalid date format");
        }
        return rv;
    }

    public static Date makeDate(int year, int month, int day) {
        return new GregorianCalendar(year, month - 1, day).getTime();
    }

    public static Date now() {
        return new Date();
    }

    public static long year(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(1);
    }

    public static long month(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static long day(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(5);
    }

    public static Date addDate(Date date, long numYears, long numMonths, long numDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(1, (int)numYears);
        cal.add(2, (int)numMonths);
        cal.add(5, (int)numDays);
        return cal.getTime();
    }

    public static long yearDiff(Date date1, Date date2) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date1);
        int year1 = cal.get(1);
        cal.setTime(date2);
        int year2 = cal.get(1);
        return year2 - year1;
    }

    public static long monthDiff(Date date1, Date date2) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date1);
        int year1 = cal.get(1);
        int month1 = cal.get(2);
        cal.setTime(date2);
        int year2 = cal.get(1);
        int month2 = cal.get(2);
        return (year2 - year1) * 12 + month2 - month1;
    }

    public static long dayDiff(Date date1, Date date2) {
        return (date2.getTime() - date1.getTime()) / 86400000L;
    }
}

