/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.parser;

import de.aristaflow.adept2.extensions.xorsupport.core.parser.ParserException;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.ScannerMatch;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.ScannerSymbolInformation;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.ScannerSymbolRecognizer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Scanner {
    private static Pattern whitespace = Pattern.compile("^[\\s]+");
    private static ScannerSymbolRecognizer[] symbolRecognizers = new ScannerSymbolRecognizer[]{ScannerSymbolRecognizer.BOOL_CONSTANT, ScannerSymbolRecognizer.IDENTIFIER, ScannerSymbolRecognizer.OPERATOR, ScannerSymbolRecognizer.DELIMITER, ScannerSymbolRecognizer.STRING_CONSTANT, ScannerSymbolRecognizer.REAL_CONSTANT, ScannerSymbolRecognizer.INT_CONSTANT};

    Scanner() {
    }

    public static List<ScannerSymbolInformation> scan(String input) {
        int position = 0;
        ArrayList<ScannerSymbolInformation> res = new ArrayList<ScannerSymbolInformation>();
        String s = input;
        while (s.length() > 0) {
            boolean match = false;
            int i = 0;
            while (i < symbolRecognizers.length && !match) {
                ScannerMatch m = symbolRecognizers[i].matches(s);
                match = m.matches;
                if (match) {
                    res.add(new ScannerSymbolInformation(position + m.start, position + m.end, symbolRecognizers[i].createSymbol(s.substring(m.start, m.end))));
                    s = s.substring(m.end);
                    position += m.end;
                }
                ++i;
            }
            if (match) continue;
            Matcher wm = whitespace.matcher(s);
            if (wm.find()) {
                s = s.substring(wm.end());
                position += wm.end();
                continue;
            }
            throw new ParserException("Unrecognized symbol!", position, position);
        }
        return res;
    }
}

