/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.parser;

import de.aristaflow.adept2.extensions.xorsupport.core.parser.DelimiterSymbol;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.IdentifierSymbol;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.ScannerMatch;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import de.aristaflow.adept2.extensions.xorsupport.model.parser.ScannerSymbol;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class ScannerSymbolRecognizer {
    protected Pattern regex;
    public static ScannerSymbolRecognizer INT_CONSTANT = new ScannerSymbolRecognizer("^[0-9]+"){

        @Override
        public ScannerSymbol createSymbol(String s) {
            return CoverableDataType.INTEGER.parseFromString(s);
        }
    };
    public static ScannerSymbolRecognizer REAL_CONSTANT = new ScannerSymbolRecognizer("^[0-9]+\\.[0-9]+"){

        @Override
        public ScannerSymbol createSymbol(String s) {
            return CoverableDataType.REAL.parseFromString(s);
        }
    };
    public static ScannerSymbolRecognizer BOOL_CONSTANT = new ScannerSymbolRecognizer("(^true|^false)(,|\\(|\\)|\\!|\\&|\\||\\s)"){

        @Override
        public ScannerMatch matches(String s) {
            ScannerMatch m = super.matches(s);
            --m.end;
            return m;
        }

        @Override
        public ScannerSymbol createSymbol(String s) {
            return CoverableDataType.BOOLEAN.parseFromString(s);
        }
    };
    public static ScannerSymbolRecognizer STRING_CONSTANT = new ScannerSymbolRecognizer("^\"(\\\\\"|[^\"\n])*\""){

        @Override
        public ScannerSymbol createSymbol(String s) {
            return CoverableDataType.STRING.parseFromString(s);
        }
    };
    public static ScannerSymbolRecognizer OPERATOR = new ScannerSymbolRecognizer("^\\+|^\\-|^!|^\\*|^/|^&&|^\\|\\|"){

        @Override
        public ScannerSymbol createSymbol(String s) {
            if (s.equals("+")) {
                return OperatorType.OP_PLUS;
            }
            if (s.equals("-")) {
                return OperatorType.OP_MINUS;
            }
            if (s.equals("*")) {
                return OperatorType.OP_MULT;
            }
            if (s.equals("/")) {
                return OperatorType.OP_DIV;
            }
            if (s.equals("&&")) {
                return OperatorType.OP_AND;
            }
            if (s.equals("||")) {
                return OperatorType.OP_OR;
            }
            return OperatorType.OP_NOT;
        }
    };
    public static ScannerSymbolRecognizer DELIMITER = new ScannerSymbolRecognizer("^,|^\\(|^\\)|^\\."){

        @Override
        public ScannerSymbol createSymbol(String s) {
            if (s.equals(",")) {
                return DelimiterSymbol.COMMA;
            }
            if (s.equals("(")) {
                return DelimiterSymbol.OPENING_BRACKET;
            }
            if (s.equals(")")) {
                return DelimiterSymbol.CLOSING_BRACKET;
            }
            return DelimiterSymbol.DOT;
        }
    };
    public static ScannerSymbolRecognizer IDENTIFIER = new ScannerSymbolRecognizer("^[a-zA-Z_]\\w*"){

        @Override
        public ScannerSymbol createSymbol(String s) {
            return new IdentifierSymbol(s);
        }
    };

    public ScannerSymbolRecognizer(String expression) {
        this.regex = Pattern.compile(expression);
    }

    public ScannerMatch matches(String s) {
        Matcher m = this.regex.matcher(s);
        if (m.find()) {
            return new ScannerMatch(m.start(), m.end(), true);
        }
        return new ScannerMatch(0, 0, false);
    }

    public abstract ScannerSymbol createSymbol(String var1);
}

