/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.core.runtime;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.extensions.xorsupport.core.codegen.PredicateEvaluator;
import de.aristaflow.adept2.extensions.xorsupport.core.runtime.BytecodePredicateEvaluatorFactory;
import de.aristaflow.adept2.extensions.xorsupport.core.runtime.PredicateEvaluatorFactory;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.DecisionActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import java.util.HashMap;

public class DecisionExecutionEnvironment
extends ExecutionEnvironment {
    protected DecisionActivityInstance activity;
    protected PredicateEvaluatorFactory factory;

    public DecisionExecutionEnvironment(ActivityInstance activity) {
        super(activity);
        if (!(activity instanceof DecisionActivityInstance)) {
            throw new IllegalArgumentException("The DecisionExecutionEnvironment needs a DecisionActivityInstance!");
        }
        this.activity = (DecisionActivityInstance)activity;
        this.factory = new BytecodePredicateEvaluatorFactory();
    }

    @Override
    public void run() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (ProcessModelParameter p : this.activity.getParameters(ActivityConstants.AccessType.READ)) {
            variables.put(p.getName(), this.getInputParameterValue(p.getName()));
        }
        PredicateEvaluator code = this.factory.createEvaluator(this.activity.getConfiguration(), variables);
        try {
            int decisionID = code.evaluateDecisionID(code.evaluateLeftHandSide());
            if (decisionID == Integer.MIN_VALUE) {
                String message = "The evaluation did not succeed.";
                throw new ApplicationFailedException(message, "No decision", 0L);
            }
            this.sessionContext.getDataContext().storeIntegerParameterValue(this.activity.getDecisionParameter().getName(), decisionID);
        }
        catch (InvalidDataTypeException ex) {
            throw new ApplicationEnvironmentException(ex.getMessage(), -401001L, ex);
        }
        catch (NoSuchParameterException ex) {
            throw new ApplicationEnvironmentException(ex.getMessage(), 1100005L, ex);
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }
}

