/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.model.meta;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultConstant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.AtomicElement;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Interval;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ComparableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ExpressionType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BooleanDataType
extends ComparableDataType {
    protected static final String TYPE_DESCRIPTION = "Boolean";
    public final Constant TRUE = new DefaultConstant(this, Boolean.TRUE);
    public final Constant FALSE = new DefaultConstant(this, Boolean.FALSE);
    protected Set<OperatorType> supportedBinaryOperators = new HashSet<OperatorType>(Arrays.asList(OperatorType.OP_AND, OperatorType.OP_OR));
    protected Set<OperatorType> supportedUnaryOperators = new HashSet<OperatorType>(Arrays.asList(OperatorType.OP_NOT));
    private Constant maxValue = this.TRUE;
    private Constant minValue = this.FALSE;
    private Constant defaultValue = this.FALSE;

    @Override
    public Class<?> getJavaDataType() {
        return Boolean.class;
    }

    @Override
    public String getDescription() {
        return TYPE_DESCRIPTION;
    }

    @Override
    public Constant getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Constant getMinValue() {
        return this.minValue;
    }

    @Override
    public Object getVariableDummy(int relativePos) {
        if (relativePos >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Interval makeInterval(AtomicElement lowerBound, AtomicElement upperBound, boolean lowerBoundIncluded, boolean upperBoundIncluded) {
        if (!lowerBoundIncluded && lowerBound instanceof Constant && !((Boolean)lowerBound.getValue()).booleanValue()) {
            lowerBound = this.maxValue;
            lowerBoundIncluded = true;
        }
        if (!upperBoundIncluded && upperBound instanceof Constant && ((Boolean)upperBound.getValue()).booleanValue()) {
            upperBound = this.minValue;
            upperBoundIncluded = true;
        }
        if (!((Boolean)upperBound.getValue()).booleanValue() && ((Boolean)lowerBound.getValue()).booleanValue()) {
            return null;
        }
        return super.makeInterval(lowerBound, upperBound, lowerBoundIncluded, upperBoundIncluded);
    }

    @Override
    protected List<ExpressionType> createSupportedExpressionTypeList() {
        return Arrays.asList(ExpressionType.VAR_COMP_CONST);
    }

    @Override
    protected List<PredicateType> createConstantsPredicateList() {
        return Arrays.asList(PredicateType.IS_NULL, PredicateType.IS_TRUE, PredicateType.IS_FALSE);
    }

    @Override
    protected List<PredicateType> createVariablesPredicateList() {
        return Collections.emptyList();
    }

    @Override
    public Constant getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Constant parseFromString(String sValue) {
        try {
            return new DefaultConstant(this, Boolean.valueOf(sValue));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public Set<OperatorType> getSupportedBinaryOperators() {
        return this.supportedBinaryOperators;
    }

    @Override
    public Set<OperatorType> getSupportedUnaryOperators() {
        return this.supportedUnaryOperators;
    }

    @Override
    public Object applyBinaryOperator(Object operand1, Object operand2, OperatorType operator) {
        if (!this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand1.getClass())) || !this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand2.getClass()))) {
            throw new IllegalArgumentException("Incompatible operand types!");
        }
        switch (operator) {
            case OP_AND: {
                return (Boolean)operand1 != false && (Boolean)operand2 != false;
            }
            case OP_OR: {
                return (Boolean)operand1 != false || (Boolean)operand2 != false;
            }
        }
        throw new IllegalArgumentException("Operator is not applicable to this data type!");
    }

    @Override
    public Object applyUnaryOperator(Object operand, OperatorType operator) {
        if (!this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand.getClass()))) {
            throw new IllegalArgumentException("Incompatible operand type!");
        }
        if (operator == OperatorType.OP_NOT) {
            return (Boolean)operand == false;
        }
        throw new IllegalArgumentException("Operator is not applicable to this data type!");
    }

    @Override
    public Object deserializeValue(String value) {
        return Boolean.valueOf(value);
    }

    @Override
    public String serializeValue(Object value) {
        return value.toString();
    }
}

