/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.model.meta;

import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ExpressionType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class ComparableDataType
extends CoverableDataType {
    private List<ExpressionType> supportedExpressionTypes = Collections.unmodifiableList(this.createSupportedExpressionTypeList());
    private Map<ExpressionType, Set<PredicateType>> supportedPredicateMap = Collections.unmodifiableMap(this.createSupportedPredicateMap());

    @Override
    public List<ExpressionType> getSupportedExpressionTypes() {
        return this.supportedExpressionTypes;
    }

    @Override
    public Map<ExpressionType, Set<PredicateType>> getSupportedPredicateMap() {
        return this.supportedPredicateMap;
    }

    protected List<ExpressionType> createSupportedExpressionTypeList() {
        return Arrays.asList(ExpressionType.VAR_COMP_CONST, ExpressionType.VAR_COMP_VAR);
    }

    protected Map<ExpressionType, Set<PredicateType>> createSupportedPredicateMap() {
        Set<PredicateType> constPreds = Collections.unmodifiableSet(new TreeSet<PredicateType>(this.createConstantsPredicateList()));
        Set<PredicateType> varPreds = Collections.unmodifiableSet(new TreeSet<PredicateType>(this.createVariablesPredicateList()));
        HashMap<ExpressionType, Set<PredicateType>> predMap = new HashMap<ExpressionType, Set<PredicateType>>();
        predMap.put(ExpressionType.VAR_COMP_CONST, constPreds);
        predMap.put(ExpressionType.VAR_COMP_VAR, varPreds);
        return predMap;
    }

    protected List<PredicateType> createConstantsPredicateList() {
        return Arrays.asList(PredicateType.EQUALS, PredicateType.NOT_EQUALS, PredicateType.LESS_THAN, PredicateType.LESS_OR_EQUAL, PredicateType.GREATER_THAN, PredicateType.GREATER_OR_EQUAL, PredicateType.IN_INTERVAL, PredicateType.NOTIN_INTERVAL, PredicateType.IS_NULL, PredicateType.ISNOT_NULL);
    }

    protected List<PredicateType> createVariablesPredicateList() {
        return Arrays.asList(PredicateType.EQUALS, PredicateType.NOT_EQUALS, PredicateType.LESS_THAN, PredicateType.LESS_OR_EQUAL, PredicateType.GREATER_THAN, PredicateType.GREATER_OR_EQUAL, PredicateType.IS_NULL, PredicateType.ISNOT_NULL, PredicateType.IN_INTERVAL, PredicateType.NOTIN_INTERVAL, PredicateType.CONSTRAINT_NOT_SATISFIED);
    }

    @Override
    public Comparator<Object> getComparator() {
        return ComparableComparator.sharedInstance;
    }

    ComparableDataType() {
    }

    public static class ComparableComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = -5774052286494320511L;
        public static final ComparableComparator sharedInstance = new ComparableComparator();

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    }
}

