/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.model.meta;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultInterval;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.AtomicElement;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Interval;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.BooleanDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DateDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ExpressionType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.IntegerDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.RealDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.StringDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CoverableDataType
extends DataType {
    public static final IntegerDataType INTEGER = new IntegerDataType();
    public static final RealDataType REAL = new RealDataType();
    public static final StringDataType STRING;
    public static final BooleanDataType BOOLEAN;
    public static final DateDataType DATE;
    private static final List<CoverableDataType> availableDataTypes;

    static {
        BOOLEAN = new BooleanDataType();
        DATE = new DateDataType();
        STRING = new StringDataType();
        availableDataTypes = Collections.unmodifiableList(Arrays.asList(INTEGER, REAL, STRING, BOOLEAN, DATE));
        for (DataType dataType : availableDataTypes) {
            GenericUserObjectDataType.knownUserDataTypes.put(dataType.getJavaDataType(), dataType);
        }
    }

    public static List<CoverableDataType> getAvailableDataTypes() {
        return availableDataTypes;
    }

    public abstract List<ExpressionType> getSupportedExpressionTypes();

    public abstract Map<ExpressionType, Set<PredicateType>> getSupportedPredicateMap();

    public abstract Constant getDefaultValue();

    public abstract Constant getMaxValue();

    public abstract Constant getMinValue();

    public abstract Object getVariableDummy(int var1);

    public abstract Comparator<Object> getComparator();

    public Interval makeInterval(AtomicElement lowerBound, AtomicElement upperBound, boolean lowerBoundIncluded, boolean upperBoundIncluded) {
        int compValue = this.getComparator().compare(lowerBound.getValue(), upperBound.getValue());
        if (compValue > 0) {
            throw new IllegalArgumentException("lowerBound > upperBound not allowed!");
        }
        if (!(compValue != 0 || lowerBoundIncluded && upperBoundIncluded)) {
            return null;
        }
        return new DefaultInterval(lowerBound, upperBound, lowerBoundIncluded, upperBoundIncluded);
    }

    public abstract Constant parseFromString(String var1);

    public boolean isCharacterAllowed(char c) {
        return true;
    }
}

