/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.model.meta;

import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.Set;
import java.util.logging.Logger;

public abstract class DataType {
    protected static final Logger logger = LoggerTools.getLogger(DataType.class);

    public static DataType getDataTypeFromAdeptDataType(ProcessConstants.AdeptDataType type, String userDefinedName) {
        switch (type) {
            case INTEGER: {
                return CoverableDataType.INTEGER;
            }
            case FLOAT: {
                return CoverableDataType.REAL;
            }
            case BOOLEAN: {
                return CoverableDataType.BOOLEAN;
            }
            case STRING: {
                return CoverableDataType.STRING;
            }
            case DATE: {
                return CoverableDataType.DATE;
            }
            case URI: {
                return GenericUserObjectDataType.lookupDataType(URI.class);
            }
            case USERDEFINED: {
                Class c;
                try {
                    if (userDefinedName == null) {
                        c = Object.class;
                        logger.warning("getDataTypeFromAdeptDataType: null UDT name found, using java.lang.Object.");
                    } else {
                        c = Class.forName(userDefinedName);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    c = Object.class;
                    logger.warning("getDataTypeFromAdeptDataType: Unknown UDT name \"" + userDefinedName + "\" found, using java.lang.Object instead.");
                }
                return GenericUserObjectDataType.lookupDataType(c);
            }
        }
        throw new IllegalArgumentException("Illegal input parameter type: " + type.toString());
    }

    public abstract String getDescription();

    public abstract Class<?> getJavaDataType();

    public String toString() {
        return this.getDescription();
    }

    public boolean isDataTypeCompatible(DataType t) {
        return this.getJavaDataType().isAssignableFrom(t.getJavaDataType());
    }

    public abstract Set<OperatorType> getSupportedBinaryOperators();

    public abstract Set<OperatorType> getSupportedUnaryOperators();

    public abstract Object applyUnaryOperator(Object var1, OperatorType var2);

    public abstract Object applyBinaryOperator(Object var1, Object var2, OperatorType var3);

    public String valueToString(Object value) {
        return value.toString();
    }

    public abstract String serializeValue(Object var1);

    public abstract Object deserializeValue(String var1);
}

