/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.model.meta;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultConstant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ComparableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class DateDataType
extends ComparableDataType {
    protected static final String TYPE_DESCRIPTION = "Date";
    public static final long millisPerDay = 86400000L;
    private Constant maxValue = new DefaultConstant(this, new Date(Long.MAX_VALUE));
    private Constant minValue = new DefaultConstant(this, new Date(Long.MIN_VALUE));
    private Constant defaultValue = new DefaultConstant(this, new Date());
    protected Set<OperatorType> supportedBinaryOperators = new HashSet<OperatorType>(Arrays.asList(OperatorType.OP_PLUS, OperatorType.OP_MINUS));
    protected Set<OperatorType> supportedUnaryOperators = Collections.emptySet();
    private DateFormat parseFormat = DateFormat.getDateInstance();

    @Override
    public Constant getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Constant getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Constant getMinValue() {
        return this.minValue;
    }

    @Override
    public Object getVariableDummy(int relativePos) {
        return new Date(86400000L * (long)relativePos);
    }

    public Date parseDate(String sValue) {
        try {
            return this.parseFormat.parse(sValue);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Constant parseFromString(String sValue) {
        Date rv = this.parseDate(sValue);
        if (rv == null) {
            return null;
        }
        return new DefaultConstant(this, rv);
    }

    @Override
    public String getDescription() {
        return TYPE_DESCRIPTION;
    }

    @Override
    public Class<?> getJavaDataType() {
        return Date.class;
    }

    @Override
    public Object applyBinaryOperator(Object operand1, Object operand2, OperatorType operator) {
        if (!this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand1.getClass())) || !this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand2.getClass()))) {
            throw new IllegalArgumentException("Incompatible operand types!");
        }
        long op1 = ((Date)operand1).getTime();
        long op2 = ((Date)operand2).getTime();
        switch (operator) {
            case OP_PLUS: {
                return new Date(op1 + op2);
            }
            case OP_MINUS: {
                return new Date(op1 - op2);
            }
        }
        throw new IllegalArgumentException("Operator is not applicable to this data type!");
    }

    @Override
    public Object applyUnaryOperator(Object operand, OperatorType operator) {
        throw new IllegalArgumentException("No unary operators supported!");
    }

    @Override
    public Set<OperatorType> getSupportedBinaryOperators() {
        return this.supportedBinaryOperators;
    }

    @Override
    public Set<OperatorType> getSupportedUnaryOperators() {
        return this.supportedUnaryOperators;
    }

    @Override
    public String valueToString(Object value) {
        if (value.equals(this.getMinValue().getValue())) {
            return "-\u00e2\u02c6\u017e";
        }
        if (value.equals(this.getMaxValue().getValue())) {
            return "+\u00e2\u02c6\u017e";
        }
        return this.parseFormat.format(value);
    }

    DateDataType() {
        this.parseFormat.setLenient(true);
    }

    @Override
    public Object deserializeValue(String value) {
        return new Date(Long.parseLong(value));
    }

    @Override
    public String serializeValue(Object value) {
        return Long.toString(((Date)value).getTime());
    }
}

