/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.model.meta;

import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FunctionSignature
implements Comparable<FunctionSignature> {
    protected DataType resultType;
    protected List<DataType> parameters;
    protected String externalName;
    protected Method method;
    protected static final Map<Class<?>, Integer> dataTypeScoring = new HashMap();
    protected static final Map<Class<?>, Set<Class<?>>> concurrentTypes;

    static {
        dataTypeScoring.put(Long.class, 3);
        dataTypeScoring.put(Integer.class, 2);
        dataTypeScoring.put(Short.class, 1);
        dataTypeScoring.put(Byte.class, 0);
        dataTypeScoring.put(Double.class, 3);
        dataTypeScoring.put(Float.class, 0);
        dataTypeScoring.put(Long.TYPE, 3);
        dataTypeScoring.put(Integer.TYPE, 2);
        dataTypeScoring.put(Short.TYPE, 1);
        dataTypeScoring.put(Byte.TYPE, 0);
        dataTypeScoring.put(Double.TYPE, 3);
        dataTypeScoring.put(Float.TYPE, 0);
        concurrentTypes = new HashMap();
        concurrentTypes.put(Long.class, new HashSet<Class>(Arrays.asList(Integer.class, Short.class, Byte.class, Integer.TYPE, Short.TYPE, Byte.TYPE)));
        concurrentTypes.put(Long.TYPE, concurrentTypes.get(Long.class));
        concurrentTypes.put(Integer.class, new HashSet<Class>(Arrays.asList(Long.class, Short.class, Byte.class, Long.TYPE, Short.TYPE, Byte.TYPE)));
        concurrentTypes.put(Integer.TYPE, concurrentTypes.get(Integer.class));
        concurrentTypes.put(Short.class, new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Byte.class, Integer.TYPE, Long.TYPE, Byte.TYPE)));
        concurrentTypes.put(Short.TYPE, concurrentTypes.get(Short.class));
        concurrentTypes.put(Byte.class, new HashSet<Class>(Arrays.asList(Integer.class, Short.class, Long.class, Integer.TYPE, Short.TYPE, Long.TYPE)));
        concurrentTypes.put(Byte.TYPE, concurrentTypes.get(Byte.class));
        concurrentTypes.put(Double.class, new HashSet<Class>(Arrays.asList(Float.class, Float.TYPE)));
        concurrentTypes.put(Double.TYPE, concurrentTypes.get(Double.class));
        concurrentTypes.put(Float.class, new HashSet<Class>(Arrays.asList(Double.class, Double.TYPE)));
        concurrentTypes.put(Float.TYPE, concurrentTypes.get(Float.class));
    }

    public static int checkConcurrentMethods(FunctionSignature f1, FunctionSignature f2) {
        Class<?>[] par2;
        Class<?>[] par1 = f1.getMethod().getParameterTypes();
        if (par1.length != (par2 = f2.getMethod().getParameterTypes()).length || !f1.externalName.equals(f2.externalName)) {
            return 0;
        }
        int score1 = 0;
        if (dataTypeScoring.containsKey(f1.getMethod().getReturnType())) {
            score1 = dataTypeScoring.get(f1.getMethod().getReturnType());
        }
        int score2 = 0;
        if (dataTypeScoring.containsKey(f2.getMethod().getReturnType())) {
            score2 = dataTypeScoring.get(f2.getMethod().getReturnType());
        }
        int i = 0;
        while (i < par1.length) {
            if (!(par1[i] == par2[i] || concurrentTypes.containsKey(par1[i]) && concurrentTypes.containsKey(par2[i]) && concurrentTypes.get(par1[i]).contains(par2[i]))) {
                return 0;
            }
            if (dataTypeScoring.containsKey(par1[i])) {
                score1 += dataTypeScoring.get(par1[i]).intValue();
            }
            if (dataTypeScoring.containsKey(par2[i])) {
                score2 += dataTypeScoring.get(par2[i]).intValue();
            }
            ++i;
        }
        return score1 - score2;
    }

    public FunctionSignature(DataType resultType, Method method, String externalName) {
        this.resultType = resultType;
        this.method = method;
        this.externalName = externalName;
        this.parameters = new ArrayList<DataType>();
    }

    public List<DataType> getParameters() {
        return this.parameters;
    }

    public DataType getResultType() {
        return this.resultType;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.resultType != null) {
            s.append(this.resultType);
        } else {
            s.append("void");
        }
        s.append(" ");
        s.append(this.externalName);
        s.append("(");
        int i = 0;
        while (i < this.parameters.size()) {
            s.append(this.parameters.get(i));
            if (i != this.parameters.size() - 1) {
                s.append(",");
            }
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public int compareTo(FunctionSignature fs) {
        if (this.parameters.size() < fs.getParameters().size()) {
            return -1;
        }
        if (this.parameters.size() > fs.getParameters().size()) {
            return 1;
        }
        return 0;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getEmptyTemplate() {
        StringBuilder s = new StringBuilder();
        s.append(this.externalName);
        s.append("(");
        int i = 0;
        while (i < this.parameters.size()) {
            if (i != this.parameters.size() - 1) {
                s.append(",");
            }
            ++i;
        }
        s.append(")");
        return s.toString();
    }
}

