/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.model.meta;

import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.FunctionSignature;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.UserObjectDataType;
import de.aristaflow.adept2.model.runtimeenvironment.ComponentObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericUserObjectDataType
extends DataType
implements UserObjectDataType {
    protected Set<OperatorType> supportedBinaryOperators = new HashSet<OperatorType>();
    protected Set<OperatorType> supportedUnaryOperators = new HashSet<OperatorType>();
    public static final Map<Class<?>, DataType> knownUserDataTypes = new HashMap();
    protected Map<String, List<FunctionSignature>> methods;
    protected Class<?> type;

    static {
        knownUserDataTypes.put(Boolean.class, CoverableDataType.BOOLEAN);
        knownUserDataTypes.put(Double.class, CoverableDataType.REAL);
        knownUserDataTypes.put(Float.class, CoverableDataType.REAL);
        knownUserDataTypes.put(Long.class, CoverableDataType.INTEGER);
        knownUserDataTypes.put(Integer.class, CoverableDataType.INTEGER);
        knownUserDataTypes.put(Short.class, CoverableDataType.INTEGER);
        knownUserDataTypes.put(Byte.class, CoverableDataType.INTEGER);
        knownUserDataTypes.put(Boolean.TYPE, CoverableDataType.BOOLEAN);
        knownUserDataTypes.put(Double.TYPE, CoverableDataType.REAL);
        knownUserDataTypes.put(Float.TYPE, CoverableDataType.REAL);
        knownUserDataTypes.put(Long.TYPE, CoverableDataType.INTEGER);
        knownUserDataTypes.put(Integer.TYPE, CoverableDataType.INTEGER);
        knownUserDataTypes.put(Short.TYPE, CoverableDataType.INTEGER);
        knownUserDataTypes.put(Byte.TYPE, CoverableDataType.INTEGER);
    }

    public static void createDataTypeFromClass(UserObjectDataType type, Class c) {
        knownUserDataTypes.put(c, (DataType)((Object)type));
        Method[] methodArray = c.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            FunctionSignature f = new FunctionSignature(GenericUserObjectDataType.lookupDataType(m.getReturnType()), m, m.getName());
            Class<?>[] classArray = m.getParameterTypes();
            int n3 = classArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> param = classArray[n4];
                f.getParameters().add(GenericUserObjectDataType.lookupDataType(param));
                ++n4;
            }
            if (type.getMethods().containsKey(m.getName())) {
                type.getMethods().get(m.getName()).add(f);
            } else {
                LinkedList<FunctionSignature> l = new LinkedList<FunctionSignature>();
                l.add(f);
                type.getMethods().put(m.getName(), l);
            }
            ++n2;
        }
        for (List<FunctionSignature> l : type.getMethods().values()) {
            Collections.sort(l);
        }
    }

    public static DataType lookupDataType(Class<?> c) {
        if (knownUserDataTypes.containsKey(c)) {
            return knownUserDataTypes.get(c);
        }
        return new GenericUserObjectDataType(c);
    }

    public GenericUserObjectDataType(Class<?> c) {
        this.type = c;
        this.methods = new HashMap<String, List<FunctionSignature>>();
        GenericUserObjectDataType.createDataTypeFromClass(this, c);
    }

    @Override
    public String getDescription() {
        return this.type.getName();
    }

    @Override
    public Class<?> getJavaDataType() {
        return this.type;
    }

    @Override
    public Map<String, List<FunctionSignature>> getMethods() {
        return this.methods;
    }

    @Override
    public Set<OperatorType> getSupportedBinaryOperators() {
        return this.supportedBinaryOperators;
    }

    @Override
    public Set<OperatorType> getSupportedUnaryOperators() {
        return this.supportedUnaryOperators;
    }

    @Override
    public Object applyBinaryOperator(Object operand1, Object operand2, OperatorType operator) {
        throw new IllegalArgumentException("No binary operators supported!");
    }

    @Override
    public Object applyUnaryOperator(Object operand, OperatorType operator) {
        throw new IllegalArgumentException("No unary operators supported!");
    }

    @Override
    public Object deserializeValue(String value) {
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(value.getBytes("UTF-16LE"));
            ComponentObjectInputStream objIn = new ComponentObjectInputStream(inStream);
            Object rv = objIn.readObject();
            objIn.close();
            inStream.close();
            return rv;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public String serializeValue(Object value) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(outStream);
            objOut.writeObject(value);
            objOut.close();
            outStream.close();
            return outStream.toString("UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

