/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.model.meta;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultConstant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.AtomicElement;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Interval;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.NumberDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;

public class IntegerDataType
extends NumberDataType {
    protected static final String TYPE_DESCRIPTION = "Integer";
    private Constant maxValue = new DefaultConstant(this, Long.MAX_VALUE);
    private Constant minValue = new DefaultConstant(this, Long.MIN_VALUE);
    private Constant defaultValue = new DefaultConstant(this, 0L);

    @Override
    public Class<?> getJavaDataType() {
        return Long.class;
    }

    @Override
    public String getDescription() {
        return TYPE_DESCRIPTION;
    }

    @Override
    public Constant getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Constant getMinValue() {
        return this.minValue;
    }

    @Override
    public Object getVariableDummy(int relativePos) {
        return 4L * (long)relativePos;
    }

    @Override
    public Constant getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Interval makeInterval(AtomicElement lowerBound, AtomicElement upperBound, boolean lowerBoundIncluded, boolean upperBoundIncluded) {
        if (!lowerBoundIncluded && lowerBound instanceof Constant) {
            lowerBound = new DefaultConstant(this, (Long)lowerBound.getValue() + 1L);
            lowerBoundIncluded = true;
        }
        if (!upperBoundIncluded && upperBound instanceof Constant) {
            upperBound = new DefaultConstant(this, (Long)upperBound.getValue() - 1L);
            upperBoundIncluded = true;
        }
        if ((Long)upperBound.getValue() < (Long)lowerBound.getValue()) {
            return null;
        }
        return super.makeInterval(lowerBound, upperBound, lowerBoundIncluded, upperBoundIncluded);
    }

    @Override
    public Constant parseFromString(String sValue) {
        try {
            return new DefaultConstant(this, Long.decode(sValue));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public boolean isCharacterAllowed(char c) {
        return Character.isDigit(c) || c == '-';
    }

    @Override
    public Object applyBinaryOperator(Object operand1, Object operand2, OperatorType operator) {
        if (!this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand1.getClass())) || !this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand2.getClass()))) {
            throw new IllegalArgumentException("Incompatible operand types!");
        }
        switch (operator) {
            case OP_PLUS: {
                return ((Number)operand1).longValue() + ((Number)operand2).longValue();
            }
            case OP_MINUS: {
                return ((Number)operand1).longValue() - ((Number)operand2).longValue();
            }
            case OP_MULT: {
                return ((Number)operand1).longValue() * ((Number)operand2).longValue();
            }
            case OP_DIV: {
                return ((Number)operand1).longValue() / ((Number)operand2).longValue();
            }
        }
        throw new IllegalArgumentException("Operator is not applicable to this data type!");
    }

    @Override
    public Object applyUnaryOperator(Object operand, OperatorType operator) {
        if (!this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand.getClass()))) {
            throw new IllegalArgumentException("Incompatible operand type!");
        }
        switch (operator) {
            case OP_PLUS: {
                return ((Number)operand).longValue();
            }
            case OP_MINUS: {
                return -((Number)operand).longValue();
            }
        }
        throw new IllegalArgumentException("Operator is not applicable to this data type!");
    }

    @Override
    public Object deserializeValue(String value) {
        return Long.valueOf(value);
    }

    @Override
    public String serializeValue(Object value) {
        return value.toString();
    }
}

