/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.model.meta;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultConstant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.NumberDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import java.util.Arrays;
import java.util.List;

public class RealDataType
extends NumberDataType {
    protected static final String TYPE_DESCRIPTION = "Real";
    private Constant maxValue = new DefaultConstant(this, Double.POSITIVE_INFINITY);
    private Constant minValue = new DefaultConstant(this, Double.NEGATIVE_INFINITY);
    private Constant defaultValue = new DefaultConstant(this, 0.0);

    @Override
    public Class<?> getJavaDataType() {
        return Double.class;
    }

    @Override
    public String getDescription() {
        return TYPE_DESCRIPTION;
    }

    @Override
    public Constant getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Constant getMinValue() {
        return this.minValue;
    }

    @Override
    public Object getVariableDummy(int relativePos) {
        return (double)relativePos;
    }

    @Override
    protected List<PredicateType> createConstantsPredicateList() {
        return Arrays.asList(PredicateType.LESS_THAN, PredicateType.LESS_OR_EQUAL, PredicateType.GREATER_THAN, PredicateType.GREATER_OR_EQUAL, PredicateType.IN_INTERVAL, PredicateType.NOTIN_INTERVAL, PredicateType.IS_NULL, PredicateType.ISNOT_NULL);
    }

    @Override
    public Constant getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Constant parseFromString(String sValue) {
        try {
            return new DefaultConstant(this, Double.valueOf(sValue));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public boolean isCharacterAllowed(char c) {
        return Character.isDigit(c) || c == '-' || c == '.';
    }

    @Override
    public Object applyBinaryOperator(Object operand1, Object operand2, OperatorType operator) {
        if (!this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand1.getClass())) || !this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand2.getClass()))) {
            throw new IllegalArgumentException("Incompatible operand types!");
        }
        switch (operator) {
            case OP_PLUS: {
                return ((Number)operand1).doubleValue() + ((Number)operand2).doubleValue();
            }
            case OP_MINUS: {
                return ((Number)operand1).doubleValue() - ((Number)operand2).doubleValue();
            }
            case OP_MULT: {
                return ((Number)operand1).doubleValue() * ((Number)operand2).doubleValue();
            }
            case OP_DIV: {
                return ((Number)operand1).doubleValue() / ((Number)operand2).doubleValue();
            }
        }
        throw new IllegalArgumentException("Operator is not applicable to this data type!");
    }

    @Override
    public Object applyUnaryOperator(Object operand, OperatorType operator) {
        if (!this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand.getClass()))) {
            throw new IllegalArgumentException("Incompatible operand type!");
        }
        switch (operator) {
            case OP_PLUS: {
                return ((Number)operand).doubleValue();
            }
            case OP_MINUS: {
                return -((Number)operand).doubleValue();
            }
        }
        throw new IllegalArgumentException("Operator is not applicable to this data type!");
    }

    @Override
    public Object deserializeValue(String value) {
        return Double.valueOf(value);
    }

    @Override
    public String serializeValue(Object value) {
        return value.toString();
    }
}

