/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.model.meta;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultConstant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ComparableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.FunctionSignature;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.GenericUserObjectDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.UserObjectDataType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StringDataType
extends ComparableDataType
implements UserObjectDataType {
    protected static final String TYPE_DESCRIPTION = "String";
    public static final String MAX_STRING = new String("$MAX_STRING$");
    protected Set<OperatorType> supportedBinaryOperators = new HashSet<OperatorType>(Arrays.asList(OperatorType.OP_PLUS));
    protected Set<OperatorType> supportedUnaryOperators = Collections.emptySet();
    private Constant maxValue = new DefaultConstant(this, MAX_STRING);
    private Constant minValue;
    private Constant defaultValue = this.minValue = new DefaultConstant(this, "");
    protected Map<String, List<FunctionSignature>> methods = new HashMap<String, List<FunctionSignature>>();

    public StringDataType() {
        GenericUserObjectDataType.createDataTypeFromClass(this, String.class);
    }

    @Override
    public Class<?> getJavaDataType() {
        return String.class;
    }

    @Override
    public String getDescription() {
        return TYPE_DESCRIPTION;
    }

    @Override
    public Constant getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Constant getMinValue() {
        return this.minValue;
    }

    @Override
    public Object getVariableDummy(int relativePos) {
        if (relativePos == 0) {
            return "00000000";
        }
        StringBuilder sBuf = new StringBuilder();
        String hex = Integer.toHexString(relativePos);
        if (relativePos < 0) {
            sBuf.append('-');
        }
        int i = 0;
        while (i < 8 - hex.length()) {
            sBuf.append('0');
            ++i;
        }
        sBuf.append(hex);
        return sBuf.toString();
    }

    @Override
    public Comparator<Object> getComparator() {
        return StringComparator.sharedInstance;
    }

    @Override
    public Constant getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Constant parseFromString(String sValue) {
        if (sValue.length() < 2 || sValue.charAt(0) != '\"' || sValue.charAt(sValue.length() - 1) != '\"') {
            return null;
        }
        int maxLen = sValue.length() - 1;
        StringBuilder sBuf = new StringBuilder(maxLen);
        int i = 1;
        while (i < maxLen) {
            block12: {
                char c;
                block11: {
                    c = sValue.charAt(i);
                    if (c != '\\') break block11;
                    if (++i >= maxLen) break;
                    c = sValue.charAt(i);
                    switch (c) {
                        case 't': {
                            sBuf.append('\t');
                            break;
                        }
                        case 'n': {
                            sBuf.append('\n');
                            break;
                        }
                        case '\\': {
                            sBuf.append('\\');
                            break;
                        }
                        case 'u': {
                            int tmp;
                            int value;
                            if (i + 4 < maxLen && (value = Character.digit(sValue.charAt(i + 1), 16)) >= 0 && (tmp = Character.digit(sValue.charAt(i + 2), 16)) >= 0) {
                                value = value * 16 + tmp;
                                tmp = Character.digit(sValue.charAt(i + 3), 16);
                                if (tmp >= 0) {
                                    value = value * 16 + tmp;
                                    tmp = Character.digit(sValue.charAt(i + 4), 16);
                                    if (tmp >= 0) {
                                        value = value * 16 + tmp;
                                        sBuf.append((char)value);
                                        i += 4;
                                        break;
                                    }
                                }
                            }
                            break block12;
                        }
                        default: {
                            sBuf.append(c);
                            break;
                        }
                    }
                    break block12;
                }
                sBuf.append(c);
            }
            ++i;
        }
        return new DefaultConstant(this, sBuf.toString());
    }

    @Override
    public Map<String, List<FunctionSignature>> getMethods() {
        return this.methods;
    }

    @Override
    public Set<OperatorType> getSupportedBinaryOperators() {
        return this.supportedBinaryOperators;
    }

    @Override
    public Set<OperatorType> getSupportedUnaryOperators() {
        return this.supportedUnaryOperators;
    }

    @Override
    public Object applyBinaryOperator(Object operand1, Object operand2, OperatorType operator) {
        if (!this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand1.getClass())) || !this.isDataTypeCompatible(GenericUserObjectDataType.knownUserDataTypes.get(operand2.getClass()))) {
            throw new IllegalArgumentException("Incompatible operand types!");
        }
        if (operator == OperatorType.OP_PLUS) {
            return String.valueOf(operand1.toString()) + operand2.toString();
        }
        throw new IllegalArgumentException("Operator is not applicable to this data type!");
    }

    @Override
    public Object applyUnaryOperator(Object operand, OperatorType operator) {
        throw new IllegalArgumentException("No unary operators supported!");
    }

    @Override
    public String valueToString(Object value) {
        String sVal = (String)value;
        StringBuilder sBuf = new StringBuilder(sVal.length() * 2 + 2);
        sBuf.append('\"');
        int i = 0;
        while (i < sVal.length()) {
            char c = sVal.charAt(i);
            switch (c) {
                case '\n': {
                    sBuf.append("\\n");
                    break;
                }
                case '\t': {
                    sBuf.append("\\t");
                    break;
                }
                case '\\': {
                    sBuf.append("\\\\");
                    break;
                }
                case '\"': {
                    sBuf.append("\\\"");
                    break;
                }
                default: {
                    sBuf.append(c);
                }
            }
            ++i;
        }
        sBuf.append('\"');
        return sBuf.toString();
    }

    @Override
    public Object deserializeValue(String value) {
        return value;
    }

    @Override
    public String serializeValue(Object value) {
        return (String)value;
    }

    public static class StringComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = -6727018013108845556L;
        public static final StringComparator sharedInstance = new StringComparator();

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == MAX_STRING) {
                if (o2 == MAX_STRING) {
                    return 0;
                }
                return 1;
            }
            if (o2 == MAX_STRING) {
                return -1;
            }
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return ((String)o1).compareTo((String)o2);
        }
    }
}

