/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Graph<T> {
    public static final int TOTAL_ORDER_CHECK_OK = 0;
    public static final int TOTAL_ORDER_CHECK_MULTIPLE_STARTNODES = 1;
    public static final int TOTAL_ORDER_CHECK_MULTIPLE_ENDNODES = 2;
    public static final int TOTAL_ORDER_CHECK_CYCLE = 4;
    public static final int TOTAL_ORDER_CHECK_PARALLEL_PATHS = 8;
    protected Map<T, AdjListElement<T>> adjList;
    protected List<T> result = new ArrayList<T>();
    protected boolean inDegreesOK = true;
    protected int visitCounter;

    public void addNode(T node) {
        if (!this.adjList.containsKey(node)) {
            this.adjList.put(node, new AdjListElement<T>(node));
        }
    }

    public void addEdge(T from, T to) {
        AdjListElement<T> fromItem = this.adjList.get(from);
        if (!fromItem.outEdges.contains(to)) {
            fromItem.outEdges.add(to);
            ++this.adjList.get(to).inDegree;
        }
    }

    public List<T> getResult() {
        return this.result;
    }

    public List<T> getCycleNodes() {
        Collection<AdjListElement<T>> values = this.adjList.values();
        if (this.inDegreesOK) {
            this.sort();
        }
        LinkedList<AdjListElement<T>> nullQueue = new LinkedList<AdjListElement<T>>();
        for (AdjListElement<T> el : values) {
            el.outDegree = el.outEdges.size();
            if (el.outDegree != 0) continue;
            nullQueue.add(el);
        }
        while (!nullQueue.isEmpty()) {
            AdjListElement toNode = (AdjListElement)nullQueue.poll();
            for (AdjListElement<T> el : values) {
                if (!el.outEdges.contains(toNode)) continue;
                --el.outDegree;
                if (el.outDegree != 0) continue;
                nullQueue.add(el);
            }
        }
        ArrayList rv = new ArrayList();
        for (AdjListElement<T> el : this.adjList.values()) {
            if (el.inDegree == 0 || el.outDegree == 0) continue;
            rv.add(el.object);
        }
        return rv;
    }

    public boolean existsPath(T from, T to) {
        for (AdjListElement<T> el : this.adjList.values()) {
            el.visited = false;
        }
        return this.internalExistsPath(from, to);
    }

    private boolean internalExistsPath(T from, T to) {
        if (from == to) {
            return true;
        }
        AdjListElement<T> fromEntry = this.adjList.get(from);
        if (fromEntry.visited) {
            return false;
        }
        fromEntry.visited = true;
        for (Object succ : fromEntry.outEdges) {
            if (!this.internalExistsPath(succ, to)) continue;
            return true;
        }
        return false;
    }

    public int getOutDegree(T node) {
        AdjListElement<T> adjEl = this.adjList.get(node);
        if (adjEl != null) {
            return adjEl.outEdges.size();
        }
        return -1;
    }

    public int getInDegree(T node) {
        AdjListElement<T> adjEl;
        if (!this.inDegreesOK) {
            this.fixInDegrees();
        }
        if ((adjEl = this.adjList.get(node)) != null) {
            return adjEl.inDegree;
        }
        return -1;
    }

    public int definesTotalOrdering() {
        if (this.adjList.size() <= 1) {
            this.result.clear();
            this.result.addAll(this.adjList.keySet());
            return 0;
        }
        if (!this.inDegreesOK) {
            this.fixInDegrees();
        }
        Collection<AdjListElement<T>> values = this.adjList.values();
        AdjListElement<T> startElement = null;
        boolean hadNoSuccessor = false;
        int returnValue = 0;
        this.result.clear();
        for (AdjListElement<T> el : values) {
            if (el.inDegree == 0) {
                if (startElement == null) {
                    startElement = el;
                } else {
                    returnValue |= 1;
                }
                this.result.add(el.object);
            }
            if (el.outEdges.size() == 0) {
                if (hadNoSuccessor) {
                    returnValue |= 2;
                } else {
                    hadNoSuccessor = true;
                }
                if (el.inDegree != 0) {
                    this.result.add(el.object);
                }
            }
            el.visited = false;
        }
        if (startElement == null || !hadNoSuccessor) {
            returnValue |= 4;
        }
        if (returnValue != 0) {
            return returnValue;
        }
        this.result.clear();
        this.visitCounter = 0;
        if (this.internalTotalOrderCheck(startElement)) {
            if (this.visitCounter < values.size()) {
                return 4;
            }
            return 0;
        }
        return 8;
    }

    private boolean internalTotalOrderCheck(AdjListElement<T> startNode) {
        if (startNode.visited) {
            return false;
        }
        this.result.add(startNode.object);
        startNode.visited = true;
        ++this.visitCounter;
        for (Object edge : startNode.outEdges) {
            if (this.internalTotalOrderCheck(this.adjList.get(edge))) continue;
            return false;
        }
        return true;
    }

    protected void fixInDegrees() {
        Collection<AdjListElement<T>> values = this.adjList.values();
        for (AdjListElement<T> el : values) {
            el.inDegree = 0;
        }
        for (AdjListElement<T> el : values) {
            for (Object edge : el.outEdges) {
                ++this.adjList.get(edge).inDegree;
            }
        }
        this.inDegreesOK = true;
    }

    public boolean sort() {
        if (this.adjList.size() <= 1) {
            this.result.clear();
            this.result.addAll(this.adjList.keySet());
            return true;
        }
        LinkedList<AdjListElement<T>> nullQueue = new LinkedList<AdjListElement<T>>();
        Collection<AdjListElement<T>> values = this.adjList.values();
        this.result.clear();
        if (!this.inDegreesOK) {
            this.fixInDegrees();
        }
        this.inDegreesOK = false;
        for (AdjListElement<T> el : values) {
            if (el.inDegree != 0) continue;
            nullQueue.add(el);
        }
        while (!nullQueue.isEmpty()) {
            AdjListElement fromNode = (AdjListElement)nullQueue.poll();
            this.result.add(fromNode.object);
            for (Object edge : fromNode.outEdges) {
                AdjListElement<T> toNode = this.adjList.get(edge);
                --toNode.inDegree;
                if (toNode.inDegree != 0) continue;
                nullQueue.add(toNode);
            }
        }
        return this.result.size() == values.size();
    }

    public Graph() {
        this(null);
    }

    public Graph(Collection<T> initialObjects) {
        this.adjList = new HashMap<T, AdjListElement<T>>();
        if (initialObjects != null) {
            for (T t : initialObjects) {
                this.adjList.put(t, new AdjListElement<T>(t));
            }
        }
    }

    private static class AdjListElement<T> {
        public T object;
        public int inDegree;
        public Set<T> outEdges;
        public boolean visited;
        public int outDegree;

        public AdjListElement(T object) {
            this.object = object;
            this.inDegree = 0;
            this.outEdges = new HashSet<T>();
            this.visited = false;
        }
    }
}

