/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xpathsupport.checks;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.checks.processmodel.activity.AbstractExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.AllExecutableComponentChecks;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.CheckReport;
import java.text.SimpleDateFormat;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.configuration.Configuration;

public class XPathCheck
extends AbstractExecutableComponentCheck {
    private static final String CHECK_ID = "XPath Activity Check";

    public XPathCheck(Configuration configuration, AllExecutableComponentChecks checkProvider) {
        super("de.aristaflow.xml.XPath", CHECK_ID);
    }

    public XPathCheck(Configuration configuration, AllExecutableComponentChecks checkProvider, Registry registry) {
        this(configuration, checkProvider);
    }

    @Override
    public void performCheckSpi(AbstractActivity activity) {
        String namespaceAware;
        if (!activity.getGUIContextID().equals("NullContext")) {
            String message2 = String.format("The XPath environment only supports the %s context, but the context %s is used.", "NullContext", activity.getGUIContextID());
            this.addReportEntry(CheckReport.ResultType.FAILURE, message2);
        }
        if ((namespaceAware = activity.getConfiguration().getString("namespaceAware")) == null || namespaceAware.equals("")) {
            String string = String.format("There is no namespace aware flag provided for the activity.", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, string);
        }
        if (activity.getParameters(ActivityConstants.AccessType.READ).size() != 1) {
            String string = String.format("The XPath environment expects exactly one input parameter!", new Object[0]);
            this.addReportEntry(CheckReport.ResultType.FAILURE, string);
        }
        for (Parameter parameter : activity.getParameters(ActivityConstants.AccessType.READ)) {
            switch (parameter.getDataType()) {
                case STRING: 
                case URI: 
                case USERDEFINED: {
                    break;
                }
                default: {
                    String message3 = String.format("Only STRING, URI and USERDEFINED are valid input parameter types!", new Object[0]);
                    this.addReportEntry(CheckReport.ResultType.FAILURE, message3);
                }
            }
        }
        for (Parameter parameter : activity.getParameters(ActivityConstants.AccessType.WRITE)) {
            String expression = parameter.getConfiguration().getString("expression");
            if (expression == null || expression.equals("")) {
                String message6 = String.format("The output parameter '%s' does not have an expression assigned!", parameter.getName());
                this.addReportEntry(CheckReport.ResultType.FAILURE, message6);
            } else {
                try {
                    XPathFactory.newInstance().newXPath().compile(expression);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    String message = String.format("The XPath expression '%s' could not be compiled!", expression);
                    this.addReportEntry(CheckReport.ResultType.FAILURE, message);
                }
            }
            if (parameter.getDataType() != ProcessConstants.AdeptDataType.DATE) continue;
            String pattern = parameter.getConfiguration().getString("dateFormat");
            if (pattern == null || pattern.equals("")) {
                String message5 = "No date format pattern has been specified for output parameter " + parameter.getName() + ". Specifying a pattern and a locale is recommended.";
                this.addReportEntry(CheckReport.ResultType.INFO, message5);
            } else {
                try {
                    new SimpleDateFormat(pattern);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    String message = String.format("The date format pattern '%s' of the output parameter '%s' is invalid.", pattern, parameter.getName());
                    this.addReportEntry(CheckReport.ResultType.FAILURE, message);
                }
            }
            String locale = parameter.getConfiguration().getString("dateLocale");
            if (locale != null && !locale.equals("")) {
                if (pattern != null && !pattern.equals("")) continue;
                String message4 = String.format("The output parameter '%s' has a locale for date parsing, but no date format has been provided.", parameter.getName());
                this.addReportEntry(CheckReport.ResultType.FAILURE, message4);
                continue;
            }
            if (pattern == null || pattern.equals("")) continue;
            String message = String.format("The output parameter '%s' has a pattern for date parsing, but no locale has been provided. Providing a locale is recommended.", parameter.getName());
            this.addReportEntry(CheckReport.ResultType.INFO, message);
        }
    }
}

