/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xpathsupport.environments;

import de.aristaflow.adept2.core.runtimemanager.executionenvironments.ExecutionEnvironment;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericXPathExecutionEnvironment
extends ExecutionEnvironment {
    public static final String PATC_XPATH_EXPRESSION = "expression";
    public static final String PATC_ENCODING = "encoding";
    public static final String PATC_DATE_FORMAT = "dateFormat";
    public static final String PATC_DATE_LOCALE = "dateLocale";
    public static final String ATC_NAMESPACE_AWARE = "namespaceAware";

    public GenericXPathExecutionEnvironment(ActivityInstance activityInstance) {
        super(activityInstance);
    }

    @Override
    public void run() {
        InputStream is = this.getInputStreamFromInputParameter();
        boolean namespaceAware = Boolean.parseBoolean(this.activityInstance.getConfiguration().getString(ATC_NAMESPACE_AWARE));
        Document doc = this.getDocumentFromStream(is, namespaceAware);
        XPath xPath = XPathFactory.newInstance().newXPath();
        GenericNamespaceContext namespaceContext = null;
        if (namespaceAware) {
            namespaceContext = new GenericNamespaceContext(doc);
            xPath.setNamespaceContext(namespaceContext);
        }
        Set<ProcessModelParameter> outputParameters = this.activityInstance.getParameters(ActivityConstants.AccessType.WRITE);
        for (ProcessModelParameter param : outputParameters) {
            String message;
            String expression = param.getConfiguration().getString(PATC_XPATH_EXPRESSION);
            QName returnType = this.getXPathResultType(param.getDataType());
            try {
                Object result = xPath.evaluate(expression, doc, returnType);
                String strResult = null;
                if (param.getDataType() == ProcessConstants.AdeptDataType.FLOAT || param.getDataType() == ProcessConstants.AdeptDataType.INTEGER) {
                    strResult = xPath.evaluate(expression, doc);
                }
                if (param.isOptional() && xPath.evaluate(expression, doc, XPathConstants.NODE) == null) {
                    this.sessionContext.getDataContext().ignoreValue(param.getName());
                    continue;
                }
                if (namespaceContext != null) {
                    this.writeResultToDataContext(result, strResult, param, namespaceContext.getNamespaces());
                    continue;
                }
                this.writeResultToDataContext(result, strResult, param, null);
            }
            catch (XPathExpressionException e) {
                message = String.format("A XPathExpressionException occured during the evaluation of the expression '%s'.", expression);
                throw new ApplicationEnvironmentException(message, 123001L, e);
            }
            catch (NoSuchParameterException e) {
                message = String.format("A NoSuchParameterException occured while trying to ignore the optional output parameter '%s'.", param.getName());
                throw new ApplicationEnvironmentException(message, 1100005L, e);
            }
        }
        this.sessionContext.getRuntimeEnvironment().applicationClosed();
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public boolean signal(int signal) {
        return false;
    }

    @Override
    public boolean suspend() {
        return false;
    }

    @Override
    public boolean kill() {
        return false;
    }

    private InputStream getInputStreamFromInputParameter() {
        InputStream is;
        DataContext dataContext = this.sessionContext.getDataContext();
        Set<ProcessModelParameter> inputParameters = this.activityInstance.getParameters(ActivityConstants.AccessType.READ);
        if (inputParameters.size() == 0) {
            throw new ApplicationEnvironmentException("The XPathExecutionEnvironment needs an input parameter!", -401000L);
        }
        if (inputParameters.size() > 1) {
            throw new ApplicationEnvironmentException("The XPathExecutionEnvironment needs exactly one input parameter!", 1100006L);
        }
        ProcessModelParameter inputParameter = (ProcessModelParameter)inputParameters.iterator().next();
        String parameterName = inputParameter.getName();
        try {
            switch (inputParameter.getDataType()) {
                case STRING: {
                    String str = dataContext.retrieveStringParameterValue(parameterName);
                    String encoding = inputParameter.getConfiguration().getString(PATC_ENCODING);
                    is = encoding != null ? new ByteArrayInputStream(str.getBytes(encoding)) : new ByteArrayInputStream(str.getBytes("UTF-8"));
                    this.logger.fine("Read an InputStream from a String");
                    break;
                }
                case URI: {
                    is = dataContext.retrieveURIParameterValue(inputParameter.getName()).toURL().openStream();
                    this.logger.fine("Read an InputStream from an URI");
                    break;
                }
                case USERDEFINED: {
                    is = dataContext.retrieveUDTParameterValue(parameterName).getValueAsStream();
                    this.logger.fine("Read an InputStream from an UDT");
                    break;
                }
                default: {
                    throw new ApplicationEnvironmentException("The input parameter is of a type that is not supported!", -401001L);
                }
            }
        }
        catch (InvalidDataTypeException e) {
            String message = "An InvalidDataTypeException occured while trying to get an input stream from an input parameter.";
            throw new ApplicationEnvironmentException(message, -401001L, e);
        }
        catch (NoSuchParameterException e) {
            String message = "An NoSuchParameterException occured while trying to get an input stream from an input parameter.";
            throw new ApplicationEnvironmentException(message, 1100005L, e);
        }
        catch (MalformedURLException e) {
            String message = "An MalformedURLException occured while trying to get an input stream from an input parameter.";
            throw new ApplicationEnvironmentException(message, 123002L, e);
        }
        catch (IOException e) {
            String message = "An IOException occured while trying to get an input stream from an input parameter.";
            throw new ApplicationEnvironmentException(message, 123003L, e);
        }
        return is;
    }

    private Document getDocumentFromStream(InputStream is, boolean namespaceAware) {
        Document doc;
        try {
            doc = XMLHelperTools.getDocumentFromStream(is, null, null, namespaceAware);
        }
        catch (IOException e) {
            String message = "An IOException occured while trying to parse a XML document from an input stream.";
            this.logger.log(Level.SEVERE, message, e);
            throw new ApplicationEnvironmentException(message, 123003L, e);
        }
        catch (XMLFormatException e) {
            String message = "A XMLFormatException occured while trying to parse a XML document from an input stream.";
            throw new ApplicationEnvironmentException(message, 123009L, e);
        }
        return doc;
    }

    private QName getXPathResultType(ProcessConstants.AdeptDataType dataType) {
        QName xPathType;
        switch (dataType) {
            case BOOLEAN: {
                xPathType = XPathConstants.BOOLEAN;
                break;
            }
            case INTEGER: 
            case FLOAT: {
                xPathType = XPathConstants.NUMBER;
                break;
            }
            case STRING: 
            case DATE: 
            case URI: {
                xPathType = XPathConstants.STRING;
                break;
            }
            case USERDEFINED: {
                xPathType = XPathConstants.NODESET;
                break;
            }
            default: {
                throw new ApplicationEnvironmentException("The output parameter type could not be matched to the XPath data types!", -401001L);
            }
        }
        return xPathType;
    }

    private void writeResultToDataContext(Object result, String strResult, ProcessModelParameter param, Map<String, String> namespaces) {
        String parameterName = param.getName();
        try {
            DataContext dataContext = this.sessionContext.getDataContext();
            switch (param.getDataType()) {
                case BOOLEAN: {
                    dataContext.storeBooleanParameterValue(parameterName, (Boolean)result);
                    break;
                }
                case DATE: {
                    String pattern = param.getConfiguration().getString(PATC_DATE_FORMAT);
                    if (pattern != null && pattern.length() == 0) {
                        pattern = null;
                    }
                    String localeString = param.getConfiguration().getString(PATC_DATE_LOCALE);
                    Locale locale = null;
                    if (localeString != null && localeString.length() > 0) {
                        String[] localeElements = localeString.split("_");
                        if (localeElements.length == 1) {
                            locale = new Locale(localeElements[0]);
                        } else if (localeElements.length == 2) {
                            locale = new Locale(localeElements[0], localeElements[1]);
                        } else if (localeElements.length == 3) {
                            locale = new Locale(localeElements[0], localeElements[1], localeElements[2]);
                        }
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat();
                    try {
                        if (pattern != null && locale != null) {
                            dateFormat = new SimpleDateFormat(pattern, locale);
                        } else if (pattern != null) {
                            dateFormat = new SimpleDateFormat(pattern);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.logger.warning(String.format("Date format pattern '%s' not valid, will try to continue with default.", pattern));
                    }
                    dateFormat.setLenient(true);
                    Date date = dateFormat.parse((String)result);
                    dataContext.storeDateParameterValue(parameterName, date);
                    break;
                }
                case FLOAT: {
                    Double d = (Double)result;
                    if (d.isNaN()) {
                        String msg = String.format("The value '%s' is not a number.", strResult);
                        throw new ApplicationFailedException(msg, "ADEPT2:GenericXPathExecutionEnvironment:FloatNaN", 123011L);
                    }
                    dataContext.storeFloatParameterValue(parameterName, d);
                    break;
                }
                case INTEGER: {
                    Double d = (Double)result;
                    if (d.isNaN()) {
                        String msg = String.format("The value '%s' is not a number.", strResult);
                        throw new ApplicationFailedException(msg, "ADEPT2:GenericXPathExecutionEnvironment:IntegerNaN", 123011L);
                    }
                    dataContext.storeIntegerParameterValue(parameterName, d.longValue());
                    break;
                }
                case STRING: {
                    dataContext.storeStringParameterValue(parameterName, (String)result);
                    break;
                }
                case URI: {
                    dataContext.storeURIParameterValue(parameterName, new URI((String)result));
                    break;
                }
                case USERDEFINED: {
                    String udtName = param.getUDTName();
                    UDTValue nodeListToUDT = udtName.startsWith("java.util.List<Integer>") || udtName.startsWith("java.util.List<INTEGER>") ? this.nodeListToListOfObjects((NodeList)result, udtName, ProcessConstants.AdeptDataType.INTEGER) : (udtName.startsWith("java.util.List<Float>") || udtName.startsWith("java.util.List<FLOAT>") ? this.nodeListToListOfObjects((NodeList)result, udtName, ProcessConstants.AdeptDataType.FLOAT) : (udtName.startsWith("java.util.List<String>") || udtName.startsWith("java.util.List<STRING>") ? this.nodeListToListOfObjects((NodeList)result, udtName, ProcessConstants.AdeptDataType.STRING) : (udtName.startsWith("java.util.List<Uri>") || udtName.startsWith("java.util.List<URI>") ? this.nodeListToListOfObjects((NodeList)result, udtName, ProcessConstants.AdeptDataType.URI) : (udtName.startsWith("java.util.List") ? this.nodeListToListOfNodes((NodeList)result, udtName, namespaces) : this.nodeListToUDT((NodeList)result, udtName, namespaces)))));
                    dataContext.storeUDTParameterValue(parameterName, nodeListToUDT);
                    break;
                }
                default: {
                    throw new ApplicationEnvironmentException("The output parameter type '" + (Object)((Object)param.getDataType()) + "' is not supported!", -401001L);
                }
            }
        }
        catch (InvalidDataTypeException e) {
            String message = "An InvalidDataTypeException occured while trying to write to an output parameter.";
            throw new ApplicationEnvironmentException(message, -401001L, e);
        }
        catch (NoSuchParameterException e) {
            String message = "A NoSuchParameterException occured while trying to write to an output parameter.";
            throw new ApplicationEnvironmentException(message, 1100005L, e);
        }
        catch (ParseException pe) {
            String message = String.format("A ParseException occured while trying to parse '%s' to a date value.", result);
            throw new ApplicationFailedException(message, "ADEPT2:GenericXPathExecutionEnvironment:DateParseException", 123008L, pe);
        }
        catch (URISyntaxException use) {
            String message = String.format("An URISyntaxException occured while trying to create an URI from '%s'.", result);
            throw new ApplicationFailedException(message, "ADEPT2:GenericXPathExecutionEnvironment:URISyntaxException", 123010L, use);
        }
    }

    /*
     * WARNING - void declaration
     */
    private UDTValue nodeListToUDT(NodeList result, String udtName, Map<String, String> namespaces) {
        byte[] byArray;
        void var6_7;
        Document doc = XMLHelperTools.createDocument();
        Element root = doc.createElement("xPathNodeList");
        boolean bl = false;
        while (var6_7 < result.getLength()) {
            Object node = result.item((int)var6_7);
            node = doc.importNode((Node)node, true);
            root.appendChild((Node)node);
            ++var6_7;
        }
        if (namespaces != null && namespaces.size() > 0) {
            for (Map.Entry entry : namespaces.entrySet()) {
                root.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        doc.appendChild(root);
        try {
            byArray = XMLHelperTools.getByteArrayForDocument(doc);
        }
        catch (IOException e) {
            String message = "An IOException occured while trying to transform a document to a byte[]!";
            throw new ApplicationEnvironmentException(message, 123003L, e);
        }
        return new ADEPT2UDTValue(udtName, byArray);
    }

    private UDTValue nodeListToListOfNodes(NodeList result, String udtName, Map<String, String> namespaces) {
        ArrayList<ADEPT2UDTValue> list = new ArrayList<ADEPT2UDTValue>();
        int i = 0;
        while (i < result.getLength()) {
            Document doc = XMLHelperTools.createDocument();
            Element root = doc.createElement("xPathNodeList");
            Node node = result.item(i);
            node = doc.importNode(node, true);
            root.appendChild(node);
            if (namespaces != null && namespaces.size() > 0) {
                for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                    root.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            doc.appendChild(root);
            try {
                byte[] bytes = XMLHelperTools.getByteArrayForDocument(doc);
                list.add(new ADEPT2UDTValue("xml", bytes));
            }
            catch (IOException e) {
                String message = "An IOException occured while trying to transform a document to a byte[]!";
                throw new ApplicationEnvironmentException(message, 123003L, e);
            }
            ++i;
        }
        ByteArrayOutputStream listOut = new ByteArrayOutputStream(4096);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(listOut);
            oos.writeObject(list);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            String message = "An IOException occured while trying to write an array list to an ouput stream!";
            throw new ApplicationEnvironmentException(message, 123003L, e);
        }
        return new ADEPT2UDTValue(udtName, listOut.toByteArray());
    }

    private UDTValue nodeListToListOfObjects(NodeList result, String udtName, ProcessConstants.AdeptDataType type) {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < result.getLength()) {
            Object value;
            String textContent = result.item(i).getTextContent();
            switch (type) {
                case INTEGER: {
                    value = Long.valueOf(textContent);
                    break;
                }
                case FLOAT: {
                    value = Double.valueOf(textContent);
                    break;
                }
                case STRING: {
                    value = textContent;
                    break;
                }
                case URI: {
                    value = URI.create(textContent);
                    break;
                }
                default: {
                    value = null;
                }
            }
            list.add(value);
            ++i;
        }
        ByteArrayOutputStream listOut = new ByteArrayOutputStream(4096);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(listOut);
            oos.writeObject(list);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            String message = "An IOException occured while trying to write an array list to an ouput stream!";
            throw new ApplicationEnvironmentException(message, 123003L, e);
        }
        return new ADEPT2UDTValue(udtName, listOut.toByteArray());
    }

    private static class GenericNamespaceContext
    implements NamespaceContext {
        private NamedNodeMap attributes;

        GenericNamespaceContext(Document doc) {
            this.attributes = doc.getDocumentElement().getAttributes();
        }

        @Override
        public String getNamespaceURI(String prefix) {
            Node namespace = this.attributes.getNamedItem("xmlns:" + prefix);
            if (namespace == null) {
                namespace = this.attributes.getNamedItem("xmlns");
            }
            if (namespace == null) {
                String message = "NamespaceAware is set to 'true', but no namespace could be found in the given document!";
                throw new ApplicationEnvironmentException(message, 123000L);
            }
            return namespace.getTextContent();
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }

        public Map<String, String> getNamespaces() {
            HashMap<String, String> namespaces = new HashMap<String, String>();
            int i = 0;
            while (i < this.attributes.getLength()) {
                Node item = this.attributes.item(i);
                if (item.getNodeName().contains("xmlns")) {
                    namespaces.put(item.getNodeName(), item.getNodeValue());
                }
                ++i;
            }
            return namespaces;
        }
    }
}

