/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model;

import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.registry.InstanceToInstanceRegistry;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.common.ModelViewerProvider;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.graphical.GraphicalModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="Components.ProcessModelFactory", type=Property.Type.STRING, isRequired=true, description="the process model factory"), @Property(name="Components.ActivityModelFactory", type=Property.Type.STRING, isRequired=true, description="the activity model factory"), @Property(name="Components.ExecutionFactory", type=Property.Type.STRING, isRequired=true, description="The factory for execution model."), @Property(name="Components.FilterFactory", type=Property.Type.STRING, isRequired=true, description="The factory for filters on the models."), @Property(name="Components.GraphicalModelFactory", type=Property.Type.STRING, isRequired=true, description="The factory for elements of the graphical model like images."), @Property(name="Components.WorklistModelFactory", type=Property.Type.STRING, isRequired=true, description="the worklist model factory")})
public final class ModelFactoryRegistry
extends InstanceToInstanceRegistry
implements ModelViewerProvider {
    protected final Map<String, Class<?>> declaredModelViewers = new HashMap();
    @Deprecated
    static ModelFactoryRegistry instance;

    public ModelFactoryRegistry(Configuration configuration, Registry registry) {
        super(configuration, registry);
        instance = this;
    }

    @Override
    protected void renewConfiguration(Configuration configuration) throws ConfigurationException {
        super.renewConfiguration(configuration);
        this.declaredModelViewers.clear();
        this.readDeclaredModelViewerClasses(configuration);
    }

    protected void readDeclaredModelViewerClasses(Configuration configuration) throws ConfigurationException {
        String key = String.format("%s.%s", "PluginData", "Instances");
        List pluginDataInstances = configuration.getList(key);
        for (String pluginDataInstance : pluginDataInstances) {
            Class<?> viewerClass;
            key = String.format("%s.%s", pluginDataInstance, "Implementation");
            String className = configuration.getString(key);
            if (className != null && !className.equals("")) {
                try {
                    viewerClass = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    String message = String.format("The model viewer class %s for plug-in data %s has not been found.", className, pluginDataInstance);
                    this.logger.log(Level.SEVERE, message, e);
                    throw new ConfigurationException(message, e);
                }
            } else {
                viewerClass = null;
            }
            this.declaredModelViewers.put(pluginDataInstance, viewerClass);
        }
    }

    public ProcessModelFactory getProcessModelFactory(String instanceName) throws ServiceNotKnownException {
        try {
            return this.getUsedObjectForInstance(instanceName, "ProcessModelFactory", ProcessModelFactory.class);
        }
        catch (ConfigurationException ce) {
            throw new ServiceNotKnownException("ProcessModelFactory", (Throwable)ce);
        }
    }

    public ActivityModelFactory getActivityModelFactory(String instanceName) throws ServiceNotKnownException {
        try {
            return this.getUsedObjectForInstance(instanceName, "ActivityModelFactory", ActivityModelFactory.class);
        }
        catch (ConfigurationException ce) {
            throw new ServiceNotKnownException("ActivityModelFactory", (Throwable)ce);
        }
    }

    public WorklistModelFactory getWorklistModelFactory(String instanceName) throws ServiceNotKnownException {
        try {
            return this.getUsedObjectForInstance(instanceName, "WorklistModelFactory", WorklistModelFactory.class);
        }
        catch (ConfigurationException ce) {
            throw new ServiceNotKnownException("WorklistModelFactory", (Throwable)ce);
        }
    }

    public FilterFactory getModelFilterFactory(String instanceName) throws ServiceNotKnownException {
        try {
            return this.getUsedObjectForInstance(instanceName, "FilterFactory", FilterFactory.class);
        }
        catch (ConfigurationException ce) {
            throw new ServiceNotKnownException("FilterFactory", (Throwable)ce);
        }
    }

    public ExecutionFactory getExecutionFactory(String instanceName) throws ServiceNotKnownException {
        try {
            return this.getUsedObjectForInstance(instanceName, "ExecutionFactory", ExecutionFactory.class);
        }
        catch (ConfigurationException ce) {
            throw new ServiceNotKnownException("ExecutionFactory", (Throwable)ce);
        }
    }

    public GraphicalModelFactory getGraphicalModelFactory(String instanceName) throws ServiceNotKnownException {
        try {
            return this.getUsedObjectForInstance(instanceName, "GraphicalModelFactory", GraphicalModelFactory.class);
        }
        catch (ConfigurationException ce) {
            throw new ServiceNotKnownException("GraphicalModelFactory", (Throwable)ce);
        }
    }

    @Override
    public Class<?> getModelViewerClass(String pluginID) {
        return this.declaredModelViewers.get(pluginID);
    }

    @Deprecated
    public static ModelFactoryRegistry getModelFactoryRegistry() throws ServiceNotKnownException {
        if (instance == null) {
            throw new ServiceNotKnownException("ModelFactoryRegistry", "ModelFactoryRegistry");
        }
        return instance;
    }
}

