/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;
import java.util.UUID;

class AbstractActivityModelParameter
extends SerialisablePluginDataContainer {
    private static final long serialVersionUID = -5185302353602957006L;
    protected String name;
    protected String description;
    protected String developerDescription;
    protected ProcessConstants.AdeptDataType dataType;
    protected String udtName;
    protected UUID identifierID;
    protected Boolean isOptional;
    protected Boolean isVirtual;
    protected Boolean isFailure;
    protected String defaultValue;

    AbstractActivityModelParameter(PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
    }

    AbstractActivityModelParameter(String name, String description, String developerDescription, ProcessConstants.AdeptDataType dataType, String udtName, UUID identifierID, Boolean isOptional, Boolean isVirtual, Boolean isFailure, String defaultValue, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        this.setName(name);
        if (description == null) {
            this.removeOwnDescription();
        } else {
            this.setDescription(description);
        }
        if (developerDescription == null) {
            this.removeOwnDeveloperDescription();
        } else {
            this.setDeveloperDescription(developerDescription);
        }
        if (dataType == null) {
            this.removeOwnDataType();
        } else {
            this.setDataType(dataType, udtName);
        }
        if (identifierID == null) {
            this.identifierID = null;
        } else {
            this.setIdentifierID(identifierID);
        }
        if (isOptional == null) {
            this.removeOwnOptional();
        } else {
            this.setOptional(isOptional);
        }
        if (isVirtual == null) {
            this.removeOwnVirtual();
        } else {
            this.setVirtual(isVirtual);
        }
        if (isFailure == null) {
            this.removeOwnFailure();
        } else {
            this.setFailure(isFailure);
        }
        if (defaultValue == null) {
            this.removeOwnDefaultValue();
        } else {
            this.setDefaultValue(defaultValue);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        ArgChecks.checkForEmpty(name, "name");
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        ArgChecks.checkForNull(description, "description");
        this.description = description;
    }

    public boolean isDescriptionInherited() {
        return this.description == null;
    }

    public void removeOwnDescription() {
        this.description = null;
    }

    public String getDeveloperDescription() {
        return this.developerDescription;
    }

    public void setDeveloperDescription(String developerDescription) {
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        this.developerDescription = developerDescription;
    }

    public boolean isDeveloperDescriptionInherited() {
        return this.developerDescription == null;
    }

    public void removeOwnDeveloperDescription() {
        this.developerDescription = null;
    }

    public ProcessConstants.AdeptDataType getDataType() {
        return this.dataType;
    }

    public String getUDTName() {
        if (this.dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
            return this.udtName;
        }
        return null;
    }

    public void setDataType(ProcessConstants.AdeptDataType dataType, String udtName) {
        if (dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
            if (udtName == null) {
                throw new IllegalArgumentException("UDT name must not be null for USERDEFINED");
            }
            this.dataType = dataType;
            this.udtName = udtName;
        } else if (dataType != null) {
            if (udtName != null) {
                throw new IllegalArgumentException("UDT name must be null for anything else than USERDEFINED");
            }
            this.dataType = dataType;
            this.udtName = null;
        } else {
            this.dataType = null;
            this.udtName = null;
        }
    }

    public boolean isDataTypeInherited() {
        return this.dataType == null;
    }

    public void removeOwnDataType() {
        this.dataType = null;
        this.udtName = null;
    }

    public UUID getIdentifierID() {
        return this.identifierID;
    }

    public void setIdentifierID(UUID identifierID) {
        ArgChecks.checkForNull(identifierID, "identifierID");
        this.identifierID = identifierID;
    }

    public boolean isIdentifierIDInherited() {
        return this.identifierID == null;
    }

    public void removeOwnIdentifierID() {
        this.identifierID = null;
    }

    public boolean isOptional() {
        return this.isOptional == null ? false : this.isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public boolean isOptionalInherited() {
        return this.isOptional == null;
    }

    public void removeOwnOptional() {
        this.isOptional = null;
    }

    public boolean isVirtual() {
        return this.isVirtual == null ? false : this.isVirtual;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public boolean isVirtualInherited() {
        return this.isVirtual == null;
    }

    public void removeOwnVirtual() {
        this.isVirtual = null;
    }

    public boolean isFailure() {
        return this.isFailure == null ? false : this.isFailure;
    }

    public void setFailure(boolean isFailure) {
        this.isFailure = isFailure;
    }

    public boolean isFailureInherited() {
        return this.isFailure == null;
    }

    public void removeOwnFailure() {
        this.isFailure = null;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isDefaultValueInherited() {
        return this.defaultValue == null;
    }

    public void removeOwnDefaultValue() {
        this.defaultValue = null;
    }
}

