/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;
import java.util.UUID;

public class AbstractParameterTemplate
extends SerialisablePluginDataContainer {
    private static final long serialVersionUID = -8544161127820608345L;
    protected String templateName;
    protected String templateDescription;
    protected ActivityConstants.AccessType accessType;
    protected String name;
    protected String description;
    protected ProcessConstants.AdeptDataType dataType;
    protected String udtName;
    protected UUID identifierID;
    protected Boolean isOptional;
    protected Boolean isVirtual;
    protected Boolean isFailure;
    protected String defaultValue;

    AbstractParameterTemplate(PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
    }

    AbstractParameterTemplate(String templateName, String templateDescription, ActivityConstants.AccessType accessType, String name, String description, ProcessConstants.AdeptDataType dataType, String udtName, UUID identifierID, Boolean isOptional, Boolean isVirtual, Boolean isFailure, String defaultValue, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        this.setTemplateName(templateName);
        if (templateDescription != null) {
            this.setTemplateDescription(templateDescription);
        }
        if (accessType != null) {
            this.setAccessType(accessType);
        }
        if (name != null) {
            this.setName(name);
        }
        if (description != null) {
            this.setDescription(description);
        }
        if (dataType != null) {
            this.setDataType(dataType, udtName);
        }
        if (identifierID != null) {
            this.setIdentifierID(identifierID);
        }
        if (isOptional != null) {
            this.setOptional(isOptional);
        }
        if (isVirtual != null) {
            this.setVirtual(isVirtual);
        }
        if (isFailure != null) {
            this.setFailure(isFailure);
        }
        if (defaultValue != null) {
            this.setDefaultValue(defaultValue);
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        ArgChecks.checkForEmpty(templateName, "templateName");
        this.templateName = templateName;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public void setTemplateDescription(String templateDescription) {
        ArgChecks.checkForNull(templateDescription, "templateDescription");
        this.templateDescription = templateDescription;
    }

    public boolean isTemplateDescriptionInherited() {
        return this.templateDescription == null;
    }

    public void removeOwnTemplateDescription() {
        this.templateDescription = null;
    }

    public ActivityConstants.AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(ActivityConstants.AccessType accessType) {
        ArgChecks.checkForNull((Object)accessType, "accessType");
        this.accessType = accessType;
    }

    public boolean isAccessTypeInherited() {
        return this.accessType == null;
    }

    public void removeOwnAccessType() {
        this.accessType = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        ArgChecks.checkForEmpty(name, "name");
        this.name = name;
    }

    public boolean isNameInherited() {
        return this.name == null;
    }

    public void removeOwnName() {
        this.name = null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        ArgChecks.checkForEmpty(description, "description");
        this.description = description;
    }

    public boolean isDescriptionInherited() {
        return this.description == null;
    }

    public void removeOwnDescription() {
        this.description = null;
    }

    public ProcessConstants.AdeptDataType getDataType() {
        return this.dataType;
    }

    public String getUDTName() {
        return this.udtName;
    }

    public void setDataType(ProcessConstants.AdeptDataType dataType, String udtName) {
        ArgChecks.checkForNull((Object)dataType, "dataType");
        if ("".equals(udtName)) {
            udtName = null;
        }
        if (dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
            this.dataType = dataType;
            this.udtName = udtName;
        } else if (dataType != null) {
            if (udtName != null) {
                throw new IllegalArgumentException("UDT name must be null for anything else than USERDEFINED");
            }
            this.dataType = dataType;
            this.udtName = null;
        } else {
            this.dataType = null;
            this.udtName = null;
        }
    }

    public boolean isDataTypeInherited() {
        return this.dataType == null;
    }

    public void removeOwnDataType() {
        this.dataType = null;
        this.udtName = null;
    }

    public UUID getIdentifierID() {
        return this.identifierID;
    }

    public void setIdentifierID(UUID identifierID) {
        ArgChecks.checkForNull(identifierID, "identifierID");
        this.identifierID = identifierID;
    }

    public boolean isIdentifierIDInherited() {
        return this.identifierID == null;
    }

    public void removeOwnIdentifierID() {
        this.identifierID = null;
    }

    public Boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public boolean isOptionalInherited() {
        return this.isOptional == null;
    }

    public void removeOwnOptional() {
        this.isOptional = null;
    }

    public Boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public boolean isVirtualInherited() {
        return this.isVirtual == null;
    }

    public void removeOwnVirtual() {
        this.isVirtual = null;
    }

    public Boolean isFailure() {
        return this.isFailure;
    }

    public void setFailure(boolean isFailure) {
        this.isFailure = isFailure;
    }

    public boolean isFailureInherited() {
        return this.isFailure == null;
    }

    public void removeOwnFailure() {
        this.isFailure = null;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        ArgChecks.checkForNull(defaultValue, "defaultValue");
        this.defaultValue = defaultValue;
    }

    public boolean isDefaultValueInherited() {
        return this.defaultValue == null;
    }

    public void removeOwnDefaultValue() {
        this.defaultValue = null;
    }
}

