/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.StorageConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.InheritedParameterCollection;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.InheritedParameterTemplateCollection;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class ActivityModelImpl {
    public static void checkName(String name) {
        char[] cArray = ActivityConstants.DISALLOWED_NAME_CHARACTERS;
        int n = ActivityConstants.DISALLOWED_NAME_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char illegal = cArray[n2];
            if (name.indexOf(illegal) > -1) {
                String msg = "The name must not contain '%s' characters!";
                msg = String.format(msg, Character.valueOf(illegal));
                throw new IllegalArgumentException(msg);
            }
            ++n2;
        }
    }

    public static void checkParameterCollection(Collection<ActivityModelParameter> parameters) {
        HashSet<String> names = new HashSet<String>();
        for (ActivityModelParameter param : parameters) {
            if (!names.contains(param.getName())) {
                names.add(param.getName());
                continue;
            }
            String msg = "the collections contains parameters with duplicate names!";
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkStorageParameterCollection(Collection<StorageActivityModelParameter> parameters) {
        HashSet<String> names = new HashSet<String>();
        for (StorageActivityModelParameter param : parameters) {
            if (!names.contains(param.getName())) {
                names.add(param.getName());
                continue;
            }
            String msg = "the collections contains parameters with duplicate names!";
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkStorageParameterMap(Map<String, StorageActivityModelParameter> parameters) {
        for (Map.Entry<String, StorageActivityModelParameter> entry : parameters.entrySet()) {
            StorageActivityModelParameter parameter = entry.getValue();
            if (parameter == null || parameter.getName().equals(entry.getKey())) continue;
            String msg = "keys in the map must match the parameters' names!";
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkStorageParameterTemplateMap(Map<String, StorageParameterTemplate> parameterTemplates) {
        for (Map.Entry<String, StorageParameterTemplate> entry : parameterTemplates.entrySet()) {
            StorageParameterTemplate template = entry.getValue();
            if (template == null || template.getTemplateName().equals(entry.getKey())) continue;
            String msg = "keys in the map must match the parameter template's name!";
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkParameterTemplateMap(Map<String, ParameterTemplate> parameterTemplates) {
        for (Map.Entry<String, ParameterTemplate> entry : parameterTemplates.entrySet()) {
            ParameterTemplate template = entry.getValue();
            if (template == null || template.getTemplateName().equals(entry.getKey())) continue;
            String msg = "keys in the map must match the parameter templates' names!";
            throw new IllegalArgumentException(msg);
        }
    }

    public static void setClonedParameters(Map<ActivityConstants.AccessType, Map<String, StorageActivityModelParameter>> allParameters, ActivityConstants.AccessType accessType, Collection<StorageActivityModelParameter> parameters) {
        Map<Object, Object> paramMap;
        ArgChecks.checkForNulls(allParameters, "allParameters");
        ArgChecks.checkForNull((Object)accessType, "accessType");
        if (parameters == null) {
            paramMap = Collections.emptyMap();
        } else {
            ArgChecks.checkForNulls(parameters, "parameters");
            ActivityModelImpl.checkStorageParameterCollection(parameters);
            paramMap = ActivityModelImpl.cloneStorageParameters(parameters);
        }
        allParameters.put(accessType, paramMap);
    }

    public static void setClonedParameters(Map<ActivityConstants.AccessType, Map<String, StorageActivityModelParameter>> allParameters, ActivityConstants.AccessType accessType, Map<String, StorageActivityModelParameter> parameters) {
        Map<Object, Object> paramMap;
        ArgChecks.checkForNulls(allParameters, "allParameters");
        ArgChecks.checkForNull((Object)accessType, "accessType");
        if (parameters == null) {
            paramMap = Collections.emptyMap();
        } else {
            ArgChecks.checkForNulls(parameters, "parameters");
            ActivityModelImpl.checkStorageParameterMap(parameters);
            paramMap = ActivityModelImpl.cloneStorageParameters(parameters);
        }
        allParameters.put(accessType, paramMap);
    }

    public static HashMap<String, StorageParameterTemplate> setClonedParameterTemplates(Collection<StorageParameterTemplate> parameterTemplates) {
        HashMap<String, StorageParameterTemplate> result;
        if (parameterTemplates == null) {
            result = new HashMap<String, StorageParameterTemplate>();
        } else {
            ArgChecks.checkForNulls(parameterTemplates, "parameterTemplates");
            result = ActivityModelImpl.cloneStorageParameterTemplates(parameterTemplates);
        }
        return result;
    }

    public static HashMap<String, StorageParameterTemplate> setParameterTemplates(Map<String, StorageParameterTemplate> parameterTemplates) {
        HashMap<String, StorageParameterTemplate> result;
        if (parameterTemplates == null) {
            result = new HashMap();
        } else {
            ActivityModelImpl.checkStorageParameterTemplateMap(parameterTemplates);
            result = ActivityModelImpl.cloneStorageParameterTemplates(parameterTemplates);
        }
        return result;
    }

    public static Map<String, StorageActivityModelParameter> cloneStorageParameters(Collection<StorageActivityModelParameter> parameters) {
        HashMap<String, StorageActivityModelParameter> result = new HashMap<String, StorageActivityModelParameter>(parameters.size());
        for (StorageActivityModelParameter parameter : parameters) {
            parameter = new DefaultStorageActivityModelParameter(parameter);
            result.put(parameter.getName(), parameter);
        }
        return result;
    }

    public static Map<String, StorageActivityModelParameter> cloneStorageParameters(Map<String, StorageActivityModelParameter> parameters) {
        HashMap<String, StorageActivityModelParameter> result = new HashMap<String, StorageActivityModelParameter>(parameters.size());
        for (Map.Entry<String, StorageActivityModelParameter> entry : parameters.entrySet()) {
            StorageActivityModelParameter parameter = entry.getValue();
            if (parameter == null) {
                result.put(entry.getKey(), null);
                continue;
            }
            parameter = new DefaultStorageActivityModelParameter(parameter);
            result.put(entry.getKey(), parameter);
        }
        return result;
    }

    public static HashMap<String, StorageParameterTemplate> cloneStorageParameterTemplates(Collection<StorageParameterTemplate> parameterTemplates) {
        HashMap<String, StorageParameterTemplate> result = new HashMap<String, StorageParameterTemplate>(parameterTemplates.size());
        for (StorageParameterTemplate template : parameterTemplates) {
            template = new DefaultStorageParameterTemplate(template);
            result.put(template.getTemplateName(), template);
        }
        return result;
    }

    public static HashMap<String, StorageParameterTemplate> cloneStorageParameterTemplates(Map<String, StorageParameterTemplate> parameterTemplates) {
        HashMap<String, StorageParameterTemplate> result = new HashMap<String, StorageParameterTemplate>(parameterTemplates.size());
        for (Map.Entry<String, StorageParameterTemplate> entry : parameterTemplates.entrySet()) {
            StorageParameterTemplate parameterTemplate = entry.getValue();
            if (parameterTemplate == null) {
                result.put(entry.getKey(), null);
                continue;
            }
            parameterTemplate = new DefaultStorageParameterTemplate(parameterTemplate);
            result.put(entry.getKey(), parameterTemplate);
        }
        return result;
    }

    public static StorageConfigurationDescription convert(InheritedConfigurationDescription configurationDescription) {
        HashMap<String, ConfigurationDescription.ConfigurationEntry> entries = new HashMap<String, ConfigurationDescription.ConfigurationEntry>();
        for (String entryName : configurationDescription.getEntries().keySet()) {
            if (configurationDescription.isEntryInherited(entryName)) continue;
            entries.put(entryName, configurationDescription.getEntry(entryName));
        }
        return new DefaultStorageConfigurationDescription(entries);
    }

    public static StorageConfiguration convert(InheritedConfiguration configuration) {
        HashMap<String, String> values = new HashMap<String, String>();
        HashSet<String> fixedForChildren = new HashSet<String>();
        for (String entryName : configuration.getAllEntries()) {
            if (!configuration.isInherited(entryName)) {
                values.put(entryName, configuration.getString(entryName));
            }
            if (!configuration.isFixedForChildren(entryName) || configuration.isFixedForChildrenInherited(entryName)) continue;
            fixedForChildren.add(entryName);
        }
        return new DefaultStorageConfiguration(values, fixedForChildren);
    }

    public static StorageActivityConfiguration convert(InheritedActivityConfiguration configuration) {
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, String> fromParameters = new HashMap<String, String>();
        HashMap<String, String> fromConfigurations = new HashMap<String, String>();
        HashSet<String> fixedForChildren = new HashSet<String>();
        for (String entryName : configuration.getAllEntries()) {
            if (!configuration.isInherited(entryName)) {
                String value = configuration.getString(entryName);
                String fromParameter = configuration.fromInputParameter(entryName);
                String fromConfiguration = configuration.fromProcessConfiguration(entryName);
                if (fromConfiguration != null) {
                    fromConfigurations.put(entryName, fromConfiguration);
                } else if (fromParameter != null) {
                    fromParameters.put(entryName, fromParameter);
                } else if (value != null) {
                    values.put(entryName, value);
                }
            }
            if (configuration.isFixedForChildrenInherited(entryName) || !configuration.isFixedForChildren(entryName)) continue;
            fixedForChildren.add(entryName);
        }
        return new DefaultStorageActivityConfiguration(values, fromParameters, fromConfigurations, fixedForChildren);
    }

    public static Map<String, StorageActivityModelParameter> convertParameters(Map<String, ActivityModelParameter> parameters) {
        HashMap<String, StorageActivityModelParameter> result = new HashMap<String, StorageActivityModelParameter>();
        for (Map.Entry<String, ActivityModelParameter> entry : parameters.entrySet()) {
            if (entry.getValue() == null) {
                result.put(entry.getKey(), null);
                continue;
            }
            result.put(entry.getKey(), new DefaultStorageActivityModelParameter(entry.getValue()));
        }
        return result;
    }

    public static Map<String, StorageParameterTemplate> convertParameterTemplates(Map<String, ParameterTemplate> parameterTemplates) {
        HashMap<String, StorageParameterTemplate> result = new HashMap<String, StorageParameterTemplate>();
        for (Map.Entry<String, ParameterTemplate> entry : parameterTemplates.entrySet()) {
            if (entry.getValue() == null) {
                result.put(entry.getKey(), null);
                continue;
            }
            result.put(entry.getKey(), new DefaultStorageParameterTemplate(entry.getValue()));
        }
        return result;
    }

    static InheritedConfigurationDescription convert(StorageConfigurationDescription configurationDescription) {
        return new DefaultInheritedConfigurationDescription(null, configurationDescription.getEntries());
    }

    static InheritedConfiguration convert(StorageConfiguration configuration) {
        return new DefaultInheritedConfiguration(null, configuration.getValues(), configuration.getFixedForChildren());
    }

    static InheritedActivityConfiguration convert(StorageActivityConfiguration configuration) {
        return new DefaultInheritedActivityConfiguration(null, configuration.getValues(), configuration.getFromInputParameters(), configuration.getFromProcessConfigurations(), configuration.getFixedForChildren());
    }

    static Map<String, ActivityModelParameter> convertParams(Map<String, StorageActivityModelParameter> parameterTemplates) {
        HashMap<String, ActivityModelParameter> result = new HashMap<String, ActivityModelParameter>();
        for (StorageActivityModelParameter param : parameterTemplates.values()) {
            DefaultActivityModelParameter temp = new DefaultActivityModelParameter(param.getName(), param.getDescription(), param.getDeveloperDescription(), param.getDataType(), param.getUDTName(), param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), ActivityModelImpl.convert(param.getConfigurationDescription()), ActivityModelImpl.convert(param.getConfiguration()), param, param.getUserAttributes());
            result.put(param.getName(), temp);
        }
        return result;
    }

    static Map<String, ParameterTemplate> convertParamTemplates(Map<String, StorageParameterTemplate> parameterTemplates) {
        HashMap<String, ParameterTemplate> result = new HashMap<String, ParameterTemplate>();
        for (StorageParameterTemplate tpl : parameterTemplates.values()) {
            DefaultParameterTemplate temp = new DefaultParameterTemplate(null, tpl.getTemplateName(), tpl.getTemplateDescription(), tpl.getAccessType(), tpl.getName(), tpl.getDescription(), tpl.getDataType(), tpl.getUDTName(), tpl.getIdentifierID(), tpl.isOptional(), tpl.isVirtual(), tpl.isFailure(), tpl.getDefaultValue(), ActivityModelImpl.convert(tpl.getConfigurationDescription()), ActivityModelImpl.convert(tpl.getConfiguration()), tpl, tpl.getUserAttributes());
            result.put(tpl.getTemplateName(), temp);
        }
        return result;
    }

    static InheritedCollection<String, ActivityModelParameter> convertParamsToIC(Map<String, StorageActivityModelParameter> parameterTemplates) {
        InheritedParameterCollection result = new InheritedParameterCollection();
        for (StorageActivityModelParameter param : parameterTemplates.values()) {
            DefaultActivityModelParameter temp = new DefaultActivityModelParameter(param.getName(), param.getDescription(), param.getDeveloperDescription(), param.getDataType(), param.getUDTName(), param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), ActivityModelImpl.convert(param.getConfigurationDescription()), ActivityModelImpl.convert(param.getConfiguration()), param, param.getUserAttributes());
            result.set(param.getName(), temp);
        }
        return result;
    }

    static InheritedCollection<String, ParameterTemplate> convertParamTemplatesToIC(Map<String, StorageParameterTemplate> parameterTemplates) {
        InheritedParameterTemplateCollection result = new InheritedParameterTemplateCollection();
        for (StorageParameterTemplate tpl : parameterTemplates.values()) {
            DefaultParameterTemplate temp = new DefaultParameterTemplate(null, tpl.getTemplateName(), tpl.getTemplateDescription(), tpl.getAccessType(), tpl.getName(), tpl.getDescription(), tpl.getDataType(), tpl.getUDTName(), tpl.getIdentifierID(), tpl.isOptional(), tpl.isVirtual(), tpl.isFailure(), tpl.getDefaultValue(), ActivityModelImpl.convert(tpl.getConfigurationDescription()), ActivityModelImpl.convert(tpl.getConfiguration()), tpl, tpl.getUserAttributes());
            result.set(tpl.getName(), temp);
        }
        return result;
    }

    private ActivityModelImpl() {
    }
}

