/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;
import java.util.UUID;

public class DefaultATDReference
extends SerialisablePluginDataContainer
implements ATDReference {
    private static final long serialVersionUID = -5575301605302994721L;
    protected UUID id;
    protected String executableComponentName;
    protected String operationName;
    protected String configurationSetName;
    protected String name;
    protected String description;
    protected String developerDescription;
    protected long revision;
    protected long branch;
    protected State state;
    protected UUID iconID;

    public DefaultATDReference(UUID id, String executableComponentName, String operationName, String configurationSetName, String name, String description, String developerDescription, long revision, long branch, State state, UUID iconID, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNull(executableComponentName, "executableComponentName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(name, "name");
        ArgChecks.checkForNull(description, "description");
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        ArgChecks.checkForNegative(revision, "revision");
        this.branch = branch < 0L ? -1L : branch;
        ArgChecks.checkForNull((Object)state, "state");
        this.id = id;
        this.executableComponentName = executableComponentName;
        this.operationName = operationName;
        this.configurationSetName = configurationSetName;
        this.name = name;
        this.description = description;
        this.developerDescription = developerDescription;
        this.revision = revision;
        this.state = state;
        this.iconID = iconID;
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    @Override
    public String getExecutableComponentName() {
        return this.executableComponentName;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public String getConfigurationSetName() {
        return this.configurationSetName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDeveloperDescription() {
        return this.developerDescription;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public long getBranch() {
        return this.branch;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public UUID getIconID() {
        return this.iconID;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ATDReference)) {
            return false;
        }
        ATDReference otherATDRef = (ATDReference)obj;
        return this.getExecutableComponentName().equals(otherATDRef.getExecutableComponentName()) && this.getOperationName().equals(otherATDRef.getOperationName()) && this.getName().equals(otherATDRef.getName());
    }

    public int hashCode() {
        return (this.getExecutableComponentName().hashCode() * 31 + this.getOperationName().hashCode()) * 31 + this.getName().hashCode();
    }
}

