/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.AbstractActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedConfigurationDescription;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;
import java.util.UUID;

public class DefaultActivityModelParameter
extends AbstractActivityModelParameter
implements ActivityModelParameter {
    private static final long serialVersionUID = 6611987807168670979L;
    protected ActivityModelParameter parent;
    protected String originID;
    protected InheritedConfigurationDescription configurationDescription;
    protected InheritedActivityConfiguration configuration;

    public DefaultActivityModelParameter(String name, String description, String developerDescription, ProcessConstants.AdeptDataType dataType, String udtName, UUID identifierID, Boolean isOptional, Boolean isVirtual, Boolean isFailure, String defaultValue, InheritedConfigurationDescription configurationDescription, InheritedActivityConfiguration configuration, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        this(null, name, description, developerDescription, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, configurationDescription, configuration, pluginData, userAttributes);
    }

    public DefaultActivityModelParameter(ActivityModelParameter parent, String name, String description, String developerDescription, ProcessConstants.AdeptDataType dataType, String udtName, UUID identifierID, Boolean isOptional, Boolean isVirtual, Boolean isFailure, String defaultValue, InheritedConfigurationDescription configurationDescription, InheritedActivityConfiguration configuration, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(name, description, developerDescription, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, pluginData, userAttributes);
        this.parent = parent;
        this.setConfigurationDescription(configurationDescription);
        this.setConfiguration(configuration);
    }

    public DefaultActivityModelParameter(ActivityModelParameter parent, ActivityModelParameter template) {
        super(template, template.getUserAttributes());
        this.parent = parent;
        this.setName(template.getName());
        if (template.isDescriptionInherited()) {
            this.removeOwnDescription();
        } else {
            this.setDescription(template.getDescription());
        }
        if (template.isDeveloperDescriptionInherited()) {
            this.removeOwnDeveloperDescription();
        } else {
            this.setDeveloperDescription(template.getDeveloperDescription());
        }
        if (!this.hasParent()) {
            this.setDataType(template.getDataType(), template.getUDTName());
            this.setIdentifierID(template.getIdentifierID());
            this.setVirtual(template.isVirtual());
            this.setFailure(template.isFailure());
        } else {
            this.removeOwnDataType();
            this.removeOwnIdentifierID();
            this.removeOwnVirtual();
            this.removeOwnFailure();
        }
        if (template.isOptionalInherited()) {
            this.removeOwnOptional();
        } else {
            this.setOptional(template.isOptional());
        }
        if (template.isDefaultValueInherited()) {
            this.removeOwnDefaultValue();
        } else {
            this.setDefaultValue(template.getDefaultValue());
        }
        this.setConfigurationDescription(template.getConfigurationDescription());
        this.setConfiguration(template.getConfiguration());
    }

    public DefaultActivityModelParameter(ActivityModelParameter parent, String originID, ActivityModelParameter template) {
        this(parent, template);
        this.originID = originID;
    }

    private boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public String getDescription() {
        if (this.hasParent() && this.isDescriptionInherited()) {
            return this.parent.getDescription();
        }
        return super.getDescription();
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
    }

    @Override
    public String getDeveloperDescription() {
        if (this.hasParent() && this.isDeveloperDescriptionInherited()) {
            return this.parent.getDeveloperDescription();
        }
        return this.developerDescription;
    }

    @Override
    public void setDeveloperDescription(String developerDescription) {
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        this.developerDescription = developerDescription;
    }

    @Override
    public ProcessConstants.AdeptDataType getDataType() {
        if (this.hasParent()) {
            return this.parent.getDataType();
        }
        return super.getDataType();
    }

    @Override
    public String getUDTName() {
        if (this.hasParent()) {
            return this.parent.getUDTName();
        }
        return super.getUDTName();
    }

    @Override
    public void setDataType(ProcessConstants.AdeptDataType dataType, String udtName) {
        if (this.hasParent() && this.parent.getDataType() != null) {
            throw new IllegalStateException("data type is already set in parent!");
        }
        super.setDataType(dataType, udtName);
    }

    @Override
    public UUID getIdentifierID() {
        if (this.hasParent()) {
            return this.parent.getIdentifierID();
        }
        return super.getIdentifierID();
    }

    @Override
    public void setIdentifierID(UUID identifierID) {
        if (this.hasParent()) {
            throw new IllegalStateException("already set in parent");
        }
        super.setIdentifierID(identifierID);
    }

    @Override
    public boolean isOptional() {
        if (this.hasParent() && this.isOptionalInherited()) {
            return this.parent.isOptional();
        }
        return super.isOptional();
    }

    @Override
    public boolean isVirtual() {
        if (this.hasParent()) {
            return this.parent.isVirtual();
        }
        return super.isVirtual();
    }

    @Override
    public void setVirtual(boolean isVirtual) {
        if (this.hasParent()) {
            throw new IllegalStateException("already set in parent");
        }
        super.setVirtual(isVirtual);
    }

    @Override
    public boolean isFailure() {
        if (this.hasParent()) {
            return this.parent.isFailure();
        }
        return super.isFailure();
    }

    @Override
    public void setFailure(boolean isFailure) {
        if (this.hasParent()) {
            throw new IllegalStateException("already set in parent");
        }
        super.setFailure(isFailure);
    }

    @Override
    public String getDefaultValue() {
        if (this.hasParent() && this.isDefaultValueInherited()) {
            return this.parent.getDefaultValue();
        }
        return super.getDefaultValue();
    }

    @Override
    public InheritedConfigurationDescription getConfigurationDescription() {
        InheritedConfigurationDescription parentDesc = null;
        if (this.hasParent()) {
            parentDesc = this.parent.getConfigurationDescription();
        }
        return new DefaultInheritedConfigurationDescription(parentDesc, this.configurationDescription);
    }

    @Override
    public void setConfigurationDescription(InheritedConfigurationDescription description) {
        this.configurationDescription = new DefaultInheritedConfigurationDescription(null, description);
    }

    @Override
    public InheritedActivityConfiguration getConfiguration() {
        InheritedActivityConfiguration parentConf = null;
        if (this.hasParent()) {
            parentConf = this.parent.getConfiguration();
        }
        return new DefaultInheritedActivityConfiguration((InheritedConfiguration)parentConf, null, this.configuration);
    }

    @Override
    public void setConfiguration(InheritedActivityConfiguration configuration) {
        this.configuration = new DefaultInheritedActivityConfiguration(null, this.originID, configuration);
    }
}

