/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.ATParameter;
import de.aristaflow.adept2.model.activitymodel.ATParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultBuildtimeActivity;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultConfigurationDescription;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultActivityTemplate
extends DefaultBuildtimeActivity<ATParameter>
implements ActivityTemplate {
    private static final long serialVersionUID = -7851048243263318286L;
    protected String developerDescription;
    protected State state;
    protected String licenceInformation;
    protected ConfigurationDescription configurationDescription;
    protected HashMap<String, ATParameterTemplate> parameterTemplates;
    protected HashMap<UUID, Identifier> identifiers;
    protected String staffAssignmentRule;

    public DefaultActivityTemplate(UUID id, String executableComponentName, String operationName, String configurationSetName, String name, String description, String developerDescription, State state, String implementationClass, Map<ActivityConstants.ActivityModelEntityType, List<String>> separatedClassPaths, boolean isSingleton, byte[] systemComponentSignature, String guiContextID, ExecutionControlProperties executionControlProperties, boolean supportsViewOnly, boolean supportsTestExecution, UUID iconID, Map<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins, String licenceInformation, ConfigurationDescription configurationDescription, ActivityConfiguration configuration, ActivityConfiguration testConfiguration, ParameterChangePolicy parameterChangePolicy, Collection<ATParameter> inputParameters, Collection<ATParameter> outputParameters, Collection<ATParameterTemplate> parameterTemplates, String staffAssignmentRule, Collection<Identifier> identifiers, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(id, executableComponentName, operationName, configurationSetName, name, description, implementationClass, separatedClassPaths, isSingleton, systemComponentSignature, guiContextID, executionControlProperties, supportsViewOnly, supportsTestExecution, iconID, attributeOrigins, configuration, testConfiguration, parameterChangePolicy, inputParameters, outputParameters, pluginData, userAttributes);
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        this.developerDescription = developerDescription;
        ArgChecks.checkForNull((Object)state, "state");
        this.state = state;
        ArgChecks.checkForNull(licenceInformation, "licenceInformation");
        this.licenceInformation = licenceInformation;
        this.configurationDescription = new DefaultConfigurationDescription(configurationDescription);
        if (parameterTemplates == null) {
            this.parameterTemplates = new HashMap();
        } else {
            ArgChecks.checkForNulls(parameterTemplates, "parameterTemplates");
            this.parameterTemplates = new HashMap(parameterTemplates.size());
            for (ATParameterTemplate tpl : parameterTemplates) {
                if (this.parameterTemplates.containsKey(tpl.getTemplateName())) {
                    String msg = "Parameter templates with duplicate names not allowed: %s";
                    msg = String.format(msg, tpl.getTemplateName());
                    throw new IllegalArgumentException(msg);
                }
                this.parameterTemplates.put(tpl.getTemplateName(), tpl);
            }
        }
        ArgChecks.checkForNull(staffAssignmentRule, "staffAssignmentRule");
        this.staffAssignmentRule = staffAssignmentRule;
        ArgChecks.checkForNulls(identifiers, "identifiers");
        this.identifiers = new HashMap(identifiers.size());
        for (Identifier identifier : identifiers) {
            Identifier old = this.identifiers.put(identifier.getID(), identifier);
            if (old == null) continue;
            String msg = "the collection of identifiers contains duplicates!";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public String getDeveloperDescription() {
        return this.developerDescription;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public String getLicenceInformation() {
        return this.licenceInformation;
    }

    @Override
    public ConfigurationDescription getConfigurationDescription() {
        return new DefaultConfigurationDescription(this.configurationDescription);
    }

    @Override
    public Map<String, ATParameterTemplate> getParameterTemplates() {
        return new HashMap<String, ATParameterTemplate>(this.parameterTemplates);
    }

    @Override
    public String getStaffAssignmentRule() {
        return this.staffAssignmentRule;
    }

    @Override
    public Map<UUID, Identifier> getIdentifiers() {
        return new HashMap<UUID, Identifier>(this.identifiers);
    }
}

