/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.ConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.ActivityModelImpl;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.InheritedParameterCollection;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.InheritedParameterTemplateCollection;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultActivityTemplateDefinition
extends SerialisablePluginDataContainer
implements ActivityTemplateDefinition {
    private static final long serialVersionUID = -7237410464576320847L;
    protected Operation operation;
    protected ConfigurationSet configurationSet;
    protected UUID id;
    protected String name;
    protected String description;
    protected String developerDescription;
    protected long revision;
    protected State state;
    protected String implementationClass;
    protected ArrayList<String> classPath;
    protected Boolean isSingleton;
    protected byte[] systemComponentSignature;
    protected String guiContextID;
    protected ExecutionControlProperties executionControlProperties;
    protected Boolean supportsViewOnly;
    protected Boolean supportsTestExecution;
    protected UUID iconID;
    protected String licenceInformation;
    protected InheritedConfigurationDescription configurationDescription;
    protected InheritedActivityConfiguration configuration;
    protected InheritedActivityConfiguration testConfiguration;
    protected ParameterChangePolicy parameterChangePolicy;
    protected HashMap<ActivityConstants.AccessType, InheritedCollection<String, ActivityModelParameter>> parameters;
    protected InheritedCollection<String, ParameterTemplate> parameterTemplates;
    protected String staffAssignmentRule;

    public DefaultActivityTemplateDefinition(Operation operation, ConfigurationSet configurationSet, UUID id, String name, String description, String developerDescription, long revision, State state, String implementationClass, List<String> classPath, Boolean isSingleton, byte[] systemComponentSignature, String guiContextID, ExecutionControlProperties executionControlProperties, Boolean supportsViewOnly, Boolean supportsTestExecution, UUID iconID, String licenceInformation, InheritedConfigurationDescription configurationDescription, InheritedActivityConfiguration configuration, InheritedActivityConfiguration testConfiguration, ParameterChangePolicy parameterChangePolicy, Collection<ActivityModelParameter> inputParameters, Collection<ActivityModelParameter> outputParameters, Collection<ParameterTemplate> parameterTemplates, String staffAssignmentRule, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNull(operation, "operation");
        ArgChecks.checkForNegative(revision, "revision");
        ArgChecks.checkForNull((Object)state, "state");
        this.setID(id);
        this.operation = operation;
        this.configurationSet = configurationSet;
        this.setName(name);
        if (description == null) {
            this.removeOwnDescription();
        } else {
            this.setDescription(description);
        }
        if (developerDescription == null) {
            this.removeOwnDeveloperDescription();
        } else {
            this.setDeveloperDescription(developerDescription);
        }
        this.revision = revision;
        this.state = state;
        if (implementationClass == null) {
            this.removeOwnImplementationClass();
        } else {
            this.setImplementationClass(implementationClass);
        }
        this.setClassPath(classPath);
        if (isSingleton == null) {
            this.removeOwnSingleton();
        } else {
            this.setSingleton(isSingleton);
        }
        if (systemComponentSignature == null) {
            this.removeOwnSystemComponent();
        } else if (systemComponentSignature.length == 0) {
            this.setSystemComponent(null);
        } else {
            this.setSystemComponent(systemComponentSignature);
        }
        if (guiContextID == null) {
            this.removeOwnGUIContextID();
        } else {
            this.setGUIContextID(guiContextID);
        }
        if (executionControlProperties == null) {
            this.removeOwnExecutionControlProperties();
        } else {
            this.setExecutionControlProperties(executionControlProperties);
        }
        if (supportsViewOnly == null) {
            this.removeOwnSupportsViewOnly();
        } else {
            this.setSupportsViewOnly(supportsViewOnly);
        }
        if (supportsTestExecution == null) {
            this.removeOwnSupportsTestExecution();
        } else {
            this.setSupportsTestExecution(supportsTestExecution);
        }
        if (licenceInformation == null) {
            this.removeOwnLicenceInformation();
        } else {
            this.setLicenceInformation(licenceInformation);
        }
        if (iconID == null) {
            this.removeOwnIconID();
        } else {
            this.setIconID(iconID);
        }
        this.setConfigurationDescription(configurationDescription);
        this.setConfiguration(configuration);
        this.setTestConfiguration(testConfiguration);
        if (parameterChangePolicy == null) {
            this.removeOwnParameterChangePolicy();
        } else {
            this.setParameterChangePolicy(parameterChangePolicy);
        }
        this.parameters = new HashMap();
        this.setParameters(ActivityConstants.AccessType.READ, new InheritedParameterCollection(null, null, inputParameters));
        this.setParameters(ActivityConstants.AccessType.WRITE, new InheritedParameterCollection(null, null, outputParameters));
        this.parameterTemplates = new InheritedParameterTemplateCollection(null, null, parameterTemplates);
        if (staffAssignmentRule == null) {
            this.removeOwnStaffAssignmentRule();
        } else {
            this.setStaffAssignmentRule(staffAssignmentRule);
        }
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    @Override
    public void setID(UUID id) {
        ArgChecks.checkForNull(id, "id");
        this.id = id;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public ConfigurationSet getConfigurationSet() {
        return this.configurationSet;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        ArgChecks.checkForEmpty(name, "name");
        ActivityModelImpl.checkName(name);
        this.name = name;
    }

    @Override
    public String getDescription() {
        if (this.isDescriptionInherited()) {
            return this.operation.getDescription();
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        ArgChecks.checkForNull(description, "description");
        this.description = description;
    }

    @Override
    public boolean isDescriptionInherited() {
        return this.description == null;
    }

    @Override
    public void removeOwnDescription() {
        this.description = null;
    }

    @Override
    public String getDeveloperDescription() {
        if (this.isDeveloperDescriptionInherited()) {
            return this.operation.getDeveloperDescription();
        }
        return this.developerDescription;
    }

    @Override
    public void setDeveloperDescription(String developerDescription) {
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        this.developerDescription = developerDescription;
    }

    @Override
    public boolean isDeveloperDescriptionInherited() {
        return this.developerDescription == null;
    }

    @Override
    public void removeOwnDeveloperDescription() {
        this.developerDescription = null;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public String getImplementationClass() {
        if (this.isImplementationClassInherited()) {
            return this.operation.getImplementationClass();
        }
        return this.implementationClass;
    }

    @Override
    public void setImplementationClass(String implementationClass) {
        ArgChecks.checkForNull(implementationClass, implementationClass);
        this.implementationClass = implementationClass;
    }

    @Override
    public boolean isImplementationClassInherited() {
        return this.implementationClass == null;
    }

    @Override
    public void removeOwnImplementationClass() {
        this.implementationClass = null;
    }

    @Override
    public List<String> getClassPath() {
        List<String> result = this.operation.getClassPath();
        result.addAll(0, this.classPath);
        return result;
    }

    @Override
    public List<String> getOwnClassPath() {
        return new ArrayList<String>(this.classPath);
    }

    @Override
    public void setClassPath(List<String> classPath) {
        if (classPath == null) {
            this.classPath = new ArrayList();
        } else {
            ArgChecks.checkForNulls(classPath, "classPath");
            List<String> parentClassPath = this.operation.getClassPath();
            int expectedIndex = classPath.size() - parentClassPath.size();
            int index = Collections.lastIndexOfSubList(classPath, parentClassPath);
            this.classPath = parentClassPath.size() == 0 || expectedIndex < 0 || index != expectedIndex ? new ArrayList<String>(classPath) : new ArrayList<String>(classPath.subList(index, classPath.size()));
        }
    }

    @Override
    public boolean isSingleton() {
        if (this.isSingletonInherited()) {
            return this.operation.isSingleton();
        }
        return this.isSingleton == null ? false : this.isSingleton;
    }

    @Override
    public void setSingleton(boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    @Override
    public boolean isSingletonInherited() {
        return this.isSingleton == null;
    }

    @Override
    public void removeOwnSingleton() {
        this.isSingleton = null;
    }

    @Override
    public byte[] getSystemComponent() {
        if (this.isSystemComponentInherited()) {
            return this.operation.getSystemComponent();
        }
        if (this.systemComponentSignature.length == 0) {
            return null;
        }
        return (byte[])this.systemComponentSignature.clone();
    }

    @Override
    public void setSystemComponent(byte[] signature) {
        if (signature == null) {
            this.systemComponentSignature = new byte[0];
        } else {
            ArgChecks.checkForEmpty(signature, "signature");
            this.systemComponentSignature = (byte[])signature.clone();
        }
    }

    @Override
    public boolean isSystemComponentInherited() {
        return this.systemComponentSignature == null;
    }

    @Override
    public void removeOwnSystemComponent() {
        this.systemComponentSignature = null;
    }

    @Override
    public String getGUIContextID() {
        if (this.isGUIContextIDInherited()) {
            return this.operation.getGUIContextID();
        }
        return this.guiContextID;
    }

    @Override
    public void setGUIContextID(String guiContextID) {
        ArgChecks.checkForEmpty(guiContextID, "guiContextID");
        this.guiContextID = guiContextID;
    }

    @Override
    public boolean isGUIContextIDInherited() {
        return this.guiContextID == null;
    }

    @Override
    public void removeOwnGUIContextID() {
        this.guiContextID = null;
    }

    @Override
    public ExecutionControlProperties getExecutionControlProperties() {
        if (this.areExecutionControlPropertiesInterited()) {
            return this.operation.getExecutionControlProperties();
        }
        return this.executionControlProperties;
    }

    @Override
    public void setExecutionControlProperties(ExecutionControlProperties executionControlProperties) {
        ArgChecks.checkForNull(executionControlProperties, "executionControlProperties");
        this.executionControlProperties = executionControlProperties;
    }

    @Override
    public boolean areExecutionControlPropertiesInterited() {
        return this.executionControlProperties == null;
    }

    @Override
    public void removeOwnExecutionControlProperties() {
        this.executionControlProperties = null;
    }

    @Override
    public boolean supportsViewOnly() {
        if (this.isSupportsViewOnlyInherited()) {
            return this.operation.supportsViewOnly();
        }
        return this.supportsViewOnly == null ? false : this.supportsViewOnly;
    }

    @Override
    public void setSupportsViewOnly(boolean supportsViewOnly) {
        this.supportsViewOnly = supportsViewOnly;
    }

    @Override
    public boolean isSupportsViewOnlyInherited() {
        return this.supportsViewOnly == null;
    }

    @Override
    public void removeOwnSupportsViewOnly() {
        this.supportsViewOnly = null;
    }

    @Override
    public boolean supportsTestExecution() {
        if (this.isSupportsTestExecutionInherited()) {
            return this.operation.supportsTestExecution();
        }
        return this.supportsTestExecution == null ? false : this.supportsTestExecution;
    }

    @Override
    public void setSupportsTestExecution(boolean supportsTestExecution) {
        this.supportsTestExecution = supportsTestExecution;
    }

    @Override
    public boolean isSupportsTestExecutionInherited() {
        return this.supportsTestExecution == null;
    }

    @Override
    public void removeOwnSupportsTestExecution() {
        this.supportsTestExecution = null;
    }

    @Override
    public UUID getIconID() {
        if (this.isIconIDInherited()) {
            return this.operation.getIconID();
        }
        return this.iconID;
    }

    @Override
    public void setIconID(UUID iconID) {
        this.iconID = iconID;
    }

    @Override
    public boolean isIconIDInherited() {
        return this.iconID == null;
    }

    @Override
    public void removeOwnIconID() {
        this.iconID = null;
    }

    @Override
    public String getLicenceInformation() {
        if (this.isLicenceInformationInherited()) {
            return this.operation.getLicenceInformation();
        }
        return this.licenceInformation;
    }

    @Override
    public void setLicenceInformation(String licenceInformation) {
        ArgChecks.checkForNull(licenceInformation, "licenceInformation");
        this.licenceInformation = licenceInformation;
    }

    @Override
    public boolean isLicenceInformationInherited() {
        return this.licenceInformation == null;
    }

    @Override
    public void removeOwnLicenceInformation() {
        this.licenceInformation = null;
    }

    @Override
    public InheritedConfigurationDescription getConfigurationDescription() {
        InheritedConfigurationDescription parentConfDesc = this.getConfigurationSet() != null ? this.getConfigurationSet().getConfigurationDescription(this.operation) : this.operation.getConfigurationDescription();
        return new DefaultInheritedConfigurationDescription(parentConfDesc, this.configurationDescription);
    }

    @Override
    public void setConfigurationDescription(InheritedConfigurationDescription configurationDescription) {
        this.configurationDescription = new DefaultInheritedConfigurationDescription(null, configurationDescription);
    }

    @Override
    public InheritedActivityConfiguration getConfiguration() {
        InheritedActivityConfiguration parentConf = this.getConfigurationSet() != null ? this.getConfigurationSet().getConfiguration(this.operation) : this.operation.getConfiguration();
        return new DefaultInheritedActivityConfiguration((InheritedConfiguration)parentConf, "ActivityTemplateDefinition", this.configuration);
    }

    @Override
    public void setConfiguration(InheritedActivityConfiguration configuration) {
        this.configuration = new DefaultInheritedActivityConfiguration(null, null, configuration);
    }

    @Override
    public InheritedActivityConfiguration getTestConfiguration() {
        InheritedActivityConfiguration parentConf = this.getConfigurationSet() != null ? this.getConfigurationSet().getTestConfiguration(this.operation) : this.operation.getTestConfiguration();
        parentConf = new DefaultInheritedActivityConfiguration((InheritedConfiguration)parentConf, "ActivityTemplateDefinition", this.configuration);
        return new DefaultInheritedActivityConfiguration((InheritedConfiguration)parentConf, "Test of ActivityTemplateDefinition", this.testConfiguration);
    }

    @Override
    public void setTestConfiguration(InheritedActivityConfiguration testConfiguration) {
        this.testConfiguration = new DefaultInheritedActivityConfiguration(null, null, testConfiguration);
    }

    @Override
    public ParameterChangePolicy getParameterChangePolicy() {
        if (this.operation != null && this.isParameterChangePolicyInherited()) {
            return this.operation.getParameterChangePolicy();
        }
        return this.parameterChangePolicy;
    }

    @Override
    public void setParameterChangePolicy(ParameterChangePolicy parameterChangePolicy) {
        ArgChecks.checkForNull((Object)parameterChangePolicy, "parameterChangePolicy");
        this.parameterChangePolicy = parameterChangePolicy;
    }

    @Override
    public boolean isParameterChangePolicyInherited() {
        return this.parameterChangePolicy == null;
    }

    @Override
    public void removeOwnParameterChangePolicy() {
        this.parameterChangePolicy = null;
    }

    @Override
    public InheritedCollection<String, ActivityModelParameter> getParameters(ActivityConstants.AccessType accessType) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        InheritedCollection<String, ActivityModelParameter> parentParams = null;
        if (this.operation != null) {
            parentParams = this.operation.getParameters(accessType);
        }
        return new InheritedParameterCollection(parentParams, "Parameter of ActivityTemplateDefinition", this.parameters.get((Object)accessType));
    }

    @Override
    public void setParameters(ActivityConstants.AccessType accessType, InheritedCollection<String, ActivityModelParameter> parameters) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        this.parameters.put(accessType, new InheritedParameterCollection(null, null, parameters));
    }

    @Override
    public InheritedCollection<String, ParameterTemplate> getParameterTemplates() {
        InheritedCollection<String, ParameterTemplate> parent = this.operation != null ? (this.getConfigurationSet() != null ? this.getConfigurationSet().getParameterTemplates(this.operation) : this.operation.getParameterTemplates()) : null;
        return new InheritedParameterTemplateCollection(parent, "ParameterTemplate of ActivityTemplateDefinition", this.parameterTemplates);
    }

    @Override
    public void setParameterTemplates(InheritedCollection<String, ParameterTemplate> parameterTemplates) {
        this.parameterTemplates = new InheritedParameterTemplateCollection(null, null, parameterTemplates);
    }

    @Override
    public String getStaffAssignmentRule() {
        String result = this.staffAssignmentRule;
        if (result == null && this.operation != null) {
            result = this.getConfigurationSet() != null ? this.getConfigurationSet().getStaffAssignmentRule(this.operation) : this.operation.getStaffAssignmentRule();
        }
        return result;
    }

    @Override
    public void setStaffAssignmentRule(String staffAssignmentRule) {
        ArgChecks.checkForNull(staffAssignmentRule, "staffAssignmentRule");
        this.staffAssignmentRule = staffAssignmentRule;
    }

    @Override
    public boolean isStaffAssignmentRuleInherited() {
        return this.staffAssignmentRule == null;
    }

    @Override
    public void removeOwnStaffAssignmentRule() {
        this.staffAssignmentRule = null;
    }

    @Override
    public StorageActivityTemplateDefinition getStorageATD() {
        String ecName = this.getOperation().getExecutableComponentDescription().getName();
        String opName = this.getOperation().getName();
        String csName = null;
        if (this.getConfigurationSet() != null) {
            csName = this.getConfigurationSet().getName();
        }
        return new DefaultStorageActivityTemplateDefinition(ecName, opName, csName, this.id, this.name, this.description, this.developerDescription, this.revision, this.state, this.implementationClass, this.classPath, this.isSingleton, this.systemComponentSignature, this.guiContextID, this.executionControlProperties, this.supportsViewOnly, this.supportsTestExecution, this.iconID, this.licenceInformation, ActivityModelImpl.convert(this.configurationDescription), ActivityModelImpl.convert(this.configuration), ActivityModelImpl.convert(this.testConfiguration), this.parameterChangePolicy, ActivityModelImpl.convertParameters(this.parameters.get((Object)ActivityConstants.AccessType.READ).getAllOwn()), ActivityModelImpl.convertParameters(this.parameters.get((Object)ActivityConstants.AccessType.WRITE).getAllOwn()), ActivityModelImpl.convertParameterTemplates(this.parameterTemplates.getAllOwn()), this.staffAssignmentRule, this, this.getUserAttributes());
    }
}

