/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.CSReference;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DefaultCSReference
extends SerialisablePluginDataContainer
implements CSReference {
    private static final long serialVersionUID = 8985031968681849881L;
    protected String name;
    protected String developerDescription;
    protected long revision;
    protected State state;
    protected HashMap<String, Collection<String>> operationNames;

    public DefaultCSReference(String name, String developerDescription, long revision, State state, Map<String, Collection<String>> operationNames, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNull(name, "name");
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        ArgChecks.checkForNegative(revision, "revision");
        ArgChecks.checkForNull((Object)state, "state");
        if (operationNames != null) {
            ArgChecks.checkForNulls(operationNames, "operationNames");
            for (Map.Entry<String, Collection<String>> entry : operationNames.entrySet()) {
                if (!entry.getValue().contains(null)) continue;
                String msg = "The operation names collection must not contain nulls!";
                throw new IllegalArgumentException(msg);
            }
        }
        this.name = name;
        this.developerDescription = developerDescription;
        this.revision = revision;
        this.state = state;
        if (operationNames == null) {
            this.operationNames = new HashMap();
        } else {
            this.operationNames = new HashMap(operationNames.size());
            for (Map.Entry<String, Collection<String>> entry : operationNames.entrySet()) {
                this.operationNames.put(entry.getKey(), new ArrayList<String>(entry.getValue()));
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDeveloperDescription() {
        return this.developerDescription;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public Map<String, Collection<String>> getOperationNames() {
        HashMap<String, Collection<String>> temp = new HashMap<String, Collection<String>>(this.operationNames.size());
        for (String ecName : this.operationNames.keySet()) {
            temp.put(ecName, new ArrayList<String>(this.operationNames.get(ecName)));
        }
        return temp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CSReference)) {
            return false;
        }
        CSReference otherCSRef = (CSReference)obj;
        return this.getName().equals(otherCSRef.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

