/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.ConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.ActivityModelImpl;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.InheritedParameterTemplateCollection;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DefaultConfigurationSet
extends SerialisablePluginDataContainer
implements ConfigurationSet {
    private static final long serialVersionUID = -5236242276667217839L;
    protected String name;
    protected String developerDescription;
    protected long revision;
    protected State state;
    protected Entry entryGlobal = new Entry("ConfigurationSet", "Test of ConfigurationSet", "ParameterTemplate of ConfigurationSet");
    protected HashMap<String, Entry> entriesEcd = new HashMap();
    protected HashMap<String, Map<String, Entry>> entriesOp = new HashMap();

    public DefaultConfigurationSet(String name, String developerDescription, long revision, State state, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNegative(revision, "revision");
        ArgChecks.checkForNull((Object)state, "state");
        this.setName(name);
        this.setDeveloperDescription(developerDescription);
        this.revision = revision;
        this.state = state;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        ArgChecks.checkForNull(name, "name");
        ActivityModelImpl.checkName(name);
        this.name = name;
    }

    @Override
    public String getDeveloperDescription() {
        return this.developerDescription;
    }

    @Override
    public void setDeveloperDescription(String developerDescription) {
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        this.developerDescription = developerDescription;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public Map<String, Collection<String>> getOperationNames() {
        HashMap<String, Collection<String>> operationNames = new HashMap<String, Collection<String>>(this.entriesOp.size());
        for (String ecName : this.entriesOp.keySet()) {
            operationNames.put(ecName, new ArrayList<String>(this.entriesOp.get(ecName).keySet()));
        }
        return operationNames;
    }

    @Override
    public void addOperation(String ecName, String operationName) {
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(operationName, "operationName");
        Map<String, Entry> ops = this.entriesOp.get(ecName);
        if (ops == null) {
            ops = new HashMap<String, Entry>();
            this.entriesOp.put(ecName, ops);
            this.entriesEcd.put(ecName, new Entry("ExecutableComponentDescription of ConfigurationSet", "Test of ExecutableComponentDescription of ConfigurationSet", "ParameterTemplate of ExecutableComponentDescription of ConfigurationSet"));
        }
        if (!ops.containsKey(operationName)) {
            ops.put(operationName, new Entry("Operation of ConfigurationSet", "Test of Operation of ConfigurationSet", "ParameterTemplate of Operation of ConfigurationSet"));
        }
    }

    @Override
    public void removeOperation(String ecName, String operationName) {
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(operationName, "operationName");
        Map<String, Entry> ops = this.entriesOp.get(ecName);
        if (ops != null) {
            ops.remove(operationName);
            if (ops.isEmpty()) {
                this.entriesOp.remove(ecName);
                this.entriesEcd.remove(ecName);
            }
        }
    }

    @Override
    public InheritedConfigurationDescription getConfigurationDescription() {
        return this.getEntryGlobal().getConfigurationDescription(null);
    }

    @Override
    public void setConfigurationDescription(InheritedConfigurationDescription description) {
        this.getEntryGlobal().setConfigurationDescription(description);
    }

    @Override
    public InheritedConfigurationDescription getConfigurationDescription(ExecutableComponentDescription ecd) {
        ArgChecks.checkForNull(ecd, "ecd");
        InheritedConfigurationDescription parent = ecd.getConfigurationDescription();
        parent = this.getEntryGlobal().getConfigurationDescription(parent);
        return this.getEntry(ecd.getName()).getConfigurationDescription(parent);
    }

    @Override
    public void setConfigurationDescription(InheritedConfigurationDescription description, String ecName) {
        this.getEntry(ecName).setConfigurationDescription(description);
    }

    @Override
    public InheritedConfigurationDescription getConfigurationDescription(Operation operation) {
        ArgChecks.checkForNull(operation, "operation");
        ExecutableComponentDescription ecd = operation.getExecutableComponentDescription();
        InheritedConfigurationDescription parent = operation.getConfigurationDescription();
        parent = this.getEntryGlobal().getConfigurationDescription(parent);
        parent = this.getEntry(ecd.getName()).getConfigurationDescription(parent);
        return this.getEntry(ecd.getName(), operation.getName()).getConfigurationDescription(parent);
    }

    @Override
    public void setConfigurationDescription(InheritedConfigurationDescription description, String ecName, String operationName) {
        this.getEntry(ecName, operationName).setConfigurationDescription(description);
    }

    @Override
    public InheritedConfiguration getConfiguration() {
        return this.getEntryGlobal().getConfiguration(null);
    }

    @Override
    public void setConfiguration(InheritedConfiguration configuration) {
        this.getEntryGlobal().setConfiguration(configuration);
    }

    @Override
    public InheritedConfiguration getConfiguration(ExecutableComponentDescription ecd) {
        ArgChecks.checkForNull(ecd, "ecd");
        InheritedActivityConfiguration parent = this.getEntryGlobal().getConfiguration(null);
        return this.getEntry(ecd.getName()).getConfiguration(parent);
    }

    @Override
    public void setConfiguration(InheritedConfiguration configuration, String ecName) {
        this.getEntry(ecName).setConfiguration(configuration);
    }

    @Override
    public InheritedActivityConfiguration getConfiguration(Operation operation) {
        ArgChecks.checkForNull(operation, "operation");
        ExecutableComponentDescription ecd = operation.getExecutableComponentDescription();
        InheritedActivityConfiguration result = operation.getConfiguration();
        result = this.getEntryGlobal().getConfiguration(result);
        result = this.getEntry(ecd.getName()).getConfiguration(result);
        result = this.getEntry(ecd.getName(), operation.getName()).getConfiguration(result);
        return result;
    }

    @Override
    public void setConfiguration(InheritedActivityConfiguration configuration, String ecName, String operationName) {
        this.getEntry(ecName, operationName).setConfiguration(configuration);
    }

    @Override
    public InheritedConfiguration getTestConfiguration() {
        return this.getEntryGlobal().getTestConfiguration(null);
    }

    @Override
    public void setTestConfiguration(InheritedConfiguration testConfiguration) {
        this.getEntryGlobal().setTestConfiguration(testConfiguration);
    }

    @Override
    public InheritedConfiguration getTestConfiguration(ExecutableComponentDescription ecd) {
        ArgChecks.checkForNull(ecd, "ecd");
        InheritedActivityConfiguration parent = this.getEntryGlobal().getConfiguration(null);
        parent = this.getEntryGlobal().getTestConfiguration(parent);
        parent = this.getEntry(ecd.getName()).getConfiguration(parent);
        parent = this.getEntry(ecd.getName()).getTestConfiguration(parent);
        return parent;
    }

    @Override
    public void setTestConfiguration(InheritedConfiguration testConfiguration, String ecName) {
        this.getEntry(ecName).setTestConfiguration(testConfiguration);
    }

    @Override
    public InheritedActivityConfiguration getTestConfiguration(Operation operation) {
        ArgChecks.checkForNull(operation, "operation");
        ExecutableComponentDescription ecd = operation.getExecutableComponentDescription();
        InheritedActivityConfiguration result = operation.getTestConfiguration();
        result = this.getEntryGlobal().getConfiguration(result);
        result = this.getEntryGlobal().getTestConfiguration(result);
        result = this.getEntry(ecd.getName()).getConfiguration(result);
        result = this.getEntry(ecd.getName()).getTestConfiguration(result);
        result = this.getEntry(ecd.getName(), operation.getName()).getConfiguration(result);
        result = this.getEntry(ecd.getName(), operation.getName()).getTestConfiguration(result);
        return result;
    }

    @Override
    public void setTestConfiguration(InheritedActivityConfiguration testConfiguration, String ecName, String operationName) {
        this.getEntry(ecName, operationName).setTestConfiguration(testConfiguration);
    }

    @Override
    public InheritedCollection<String, ParameterTemplate> getParameterTemplates() {
        return this.getEntryGlobal().getParameterTemplates(null);
    }

    @Override
    public void setParameterTemplates(InheritedCollection<String, ParameterTemplate> parameterTemplates) {
        this.getEntryGlobal().setParameterTemplates(parameterTemplates);
    }

    @Override
    public InheritedCollection<String, ParameterTemplate> getParameterTemplates(ExecutableComponentDescription ecd) {
        ArgChecks.checkForNull(ecd, "ecd");
        InheritedCollection<String, ParameterTemplate> result = ecd.getParameterTemplates();
        result = this.getEntryGlobal().getParameterTemplates(result);
        result = this.getEntry(ecd.getName()).getParameterTemplates(result);
        return result;
    }

    @Override
    public void setParameterTemplates(InheritedCollection<String, ParameterTemplate> parameterTemplates, String ecName) {
        this.getEntry(ecName).setParameterTemplates(parameterTemplates);
    }

    @Override
    public InheritedCollection<String, ParameterTemplate> getParameterTemplates(Operation operation) {
        ArgChecks.checkForNull(operation, "operation");
        ExecutableComponentDescription ecd = operation.getExecutableComponentDescription();
        InheritedCollection<String, ParameterTemplate> result = operation.getParameterTemplates();
        result = this.getEntryGlobal().getParameterTemplates(result);
        result = this.getEntry(ecd.getName()).getParameterTemplates(result);
        result = this.getEntry(ecd.getName(), operation.getName()).getParameterTemplates(result);
        return result;
    }

    @Override
    public void setParameterTemplates(InheritedCollection<String, ParameterTemplate> parameterTemplates, String ecName, String operationName) {
        this.getEntry(ecName, operationName).setParameterTemplates(parameterTemplates);
    }

    @Override
    public String getStaffAssignmentRule() {
        return this.getEntryGlobal().getStaffAssignmentRule();
    }

    @Override
    public void setStaffAssignmentRule(String staffAssignmentRule) {
        this.getEntryGlobal().setStaffAssignmentRule(staffAssignmentRule);
    }

    @Override
    public String getStaffAssignmentRule(Operation operation) {
        ArgChecks.checkForNull(operation, "operation");
        ExecutableComponentDescription ecd = operation.getExecutableComponentDescription();
        String result = this.getEntry(ecd.getName(), operation.getName()).getStaffAssignmentRule();
        if (result == null) {
            result = this.getEntryGlobal().getStaffAssignmentRule();
        }
        if (result == null) {
            result = operation.getStaffAssignmentRule();
        }
        return result;
    }

    @Override
    public void setStaffAssignmentRule(String staffAssignmentRule, String ecName, String operationName) {
        this.getEntry(ecName, operationName).setStaffAssignmentRule(staffAssignmentRule);
    }

    private Entry getEntryGlobal() {
        return this.entryGlobal;
    }

    private Entry getEntry(String ecName) {
        ArgChecks.checkForNull(ecName, "ecName");
        Entry entry = this.entriesEcd.get(ecName);
        if (entry == null) {
            entry = new Entry("ExecutableComponentDescription of ConfigurationSet", "Test of ExecutableComponentDescription of ConfigurationSet", "ParameterTemplate of ExecutableComponentDescription of ConfigurationSet");
        }
        return entry;
    }

    private Entry getEntry(String ecName, String operationName) {
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        Entry entry = null;
        Map<String, Entry> ops = this.entriesOp.get(ecName);
        if (ops != null) {
            entry = ops.get(operationName);
        }
        if (entry == null) {
            entry = new Entry("Operation of ConfigurationSet", "Test of Operation of ConfigurationSet", "ParameterTemplate of Operation of ConfigurationSet");
        }
        return entry;
    }

    @Override
    public StorageConfigurationSet getStorageCS() {
        DefaultStorageConfigurationSet result = new DefaultStorageConfigurationSet(this.name, this.developerDescription, this.revision, this.state, this, this.getUserAttributes());
        Entry globalEntry = this.getEntryGlobal();
        result.setConfigurationDescription(ActivityModelImpl.convert(globalEntry.getConfigurationDescription(null)));
        result.setConfiguration(ActivityModelImpl.convert(globalEntry.getConfiguration(null)));
        result.setTestConfiguration(ActivityModelImpl.convert(globalEntry.getTestConfiguration(null)));
        result.setParameterTemplates(ActivityModelImpl.convertParameterTemplates(globalEntry.getParameterTemplates(null).getAllOwn()));
        result.setStaffAssignmentRule(globalEntry.getStaffAssignmentRule());
        for (Map.Entry<String, Collection<String>> entry : this.getOperationNames().entrySet()) {
            String ecName = entry.getKey();
            for (String opName : entry.getValue()) {
                result.addOperation(ecName, opName);
                Entry opEntry = this.getEntry(ecName, opName);
                result.setConfigurationDescription(ActivityModelImpl.convert(opEntry.getConfigurationDescription(null)), ecName, opName);
                result.setConfiguration(ActivityModelImpl.convert(opEntry.getConfiguration(null)), ecName, opName);
                result.setTestConfiguration(ActivityModelImpl.convert(opEntry.getTestConfiguration(null)), ecName, opName);
                result.setParameterTemplates(ActivityModelImpl.convertParameterTemplates(opEntry.getParameterTemplates(null).getAllOwn()), ecName, opName);
                result.setStaffAssignmentRule(opEntry.getStaffAssignmentRule(), ecName, opName);
            }
            Entry ecEntry = this.getEntry(ecName);
            result.setConfigurationDescription(ActivityModelImpl.convert(ecEntry.getConfigurationDescription(null)), ecName);
            result.setConfiguration(ActivityModelImpl.convert(ecEntry.getConfiguration(null)), ecName);
            result.setTestConfiguration(ActivityModelImpl.convert(ecEntry.getTestConfiguration(null)), ecName);
            result.setParameterTemplates(ActivityModelImpl.convertParameterTemplates(ecEntry.getParameterTemplates(null).getAllOwn()), ecName);
        }
        return result;
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = -498675247747697375L;
        private String originID;
        private String originIDTestConf;
        private String originIDParamTemplates;
        private InheritedConfigurationDescription configurationDescription;
        private InheritedActivityConfiguration configuration;
        private InheritedActivityConfiguration testConfiguration;
        private InheritedCollection<String, ParameterTemplate> parameterTemplates;
        private String staffAssignmentRule;

        Entry(String originID, String originIDTestConf, String originIDParamTemplates) {
            this.originID = originID;
            this.originIDTestConf = originIDTestConf;
            this.originIDParamTemplates = originIDParamTemplates;
            this.configurationDescription = new DefaultInheritedConfigurationDescription();
            this.configuration = new DefaultInheritedActivityConfiguration();
            this.testConfiguration = new DefaultInheritedActivityConfiguration();
        }

        InheritedConfigurationDescription getConfigurationDescription(InheritedConfigurationDescription parent) {
            return new DefaultInheritedConfigurationDescription(parent, this.configurationDescription);
        }

        void setConfigurationDescription(InheritedConfigurationDescription description) {
            this.configurationDescription = new DefaultInheritedConfigurationDescription(null, description);
        }

        InheritedActivityConfiguration getConfiguration(InheritedConfiguration parent) {
            return new DefaultInheritedActivityConfiguration(parent, this.originID, this.configuration);
        }

        void setConfiguration(InheritedConfiguration configuration) {
            this.configuration = new DefaultInheritedActivityConfiguration(null, null, configuration);
        }

        void setConfiguration(InheritedActivityConfiguration configuration) {
            this.configuration = new DefaultInheritedActivityConfiguration(null, null, configuration);
        }

        InheritedActivityConfiguration getTestConfiguration(InheritedConfiguration parent) {
            return new DefaultInheritedActivityConfiguration(parent, this.originIDTestConf, this.testConfiguration);
        }

        void setTestConfiguration(InheritedConfiguration testConfiguration) {
            this.testConfiguration = new DefaultInheritedActivityConfiguration(null, null, testConfiguration);
        }

        void setTestConfiguration(InheritedActivityConfiguration testConfiguration) {
            this.testConfiguration = new DefaultInheritedActivityConfiguration(null, null, testConfiguration);
        }

        InheritedCollection<String, ParameterTemplate> getParameterTemplates(InheritedCollection<String, ParameterTemplate> parent) {
            return new InheritedParameterTemplateCollection(parent, this.originIDParamTemplates, this.parameterTemplates);
        }

        void setParameterTemplates(InheritedCollection<String, ParameterTemplate> parameterTemplates) {
            this.parameterTemplates = new InheritedParameterTemplateCollection(null, null, parameterTemplates);
        }

        String getStaffAssignmentRule() {
            return this.staffAssignmentRule;
        }

        void setStaffAssignmentRule(String staffAssignmentRule) {
            this.staffAssignmentRule = staffAssignmentRule;
        }
    }
}

