/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.ActivityModelImpl;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.InheritedParameterTemplateCollection;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultExecutableComponentDescription
extends SerialisablePluginDataContainer
implements ExecutableComponentDescription {
    private static final long serialVersionUID = -2840791432063171601L;
    protected String name;
    protected String developerDescription;
    protected long revision;
    protected State state;
    protected String implementationClass;
    protected ArrayList<String> classPath = new ArrayList();
    protected boolean isSingleton;
    protected byte[] systemComponentSignature;
    protected String guiContextID;
    protected ExecutionControlProperties executionControlProperties;
    protected UUID iconID;
    protected String licenceInformation;
    protected InheritedConfigurationDescription configurationDescription;
    protected InheritedCollection<String, ParameterTemplate> parameterTemplates;

    public DefaultExecutableComponentDescription(String name, String developerDescription, long revision, State state, String implementationClass, List<String> classPath, boolean isSingleton, byte[] systemComponentSignature, String guiContextID, ExecutionControlProperties executionControlProperties, UUID iconID, String licenceInformation, InheritedConfigurationDescription configurationDescription, Collection<ParameterTemplate> parameterTemplates, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNegative(revision, "revision");
        ArgChecks.checkForNull((Object)state, "state");
        this.setName(name);
        this.setDeveloperDescription(developerDescription);
        this.revision = revision;
        this.state = state;
        this.setImplementationClass(implementationClass);
        this.setClassPath(classPath);
        this.setSingleton(isSingleton);
        this.setSystemComponent(systemComponentSignature);
        this.setGUIContextID(guiContextID);
        this.setExecutionControlProperties(executionControlProperties);
        this.setIconID(iconID);
        this.setLicenceInformation(licenceInformation);
        this.setConfigurationDescription(configurationDescription);
        this.parameterTemplates = new InheritedParameterTemplateCollection(null, null, parameterTemplates);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        ArgChecks.checkForNull(name, "name");
        ActivityModelImpl.checkName(name);
        this.name = name;
    }

    @Override
    public String getDeveloperDescription() {
        return this.developerDescription;
    }

    @Override
    public void setDeveloperDescription(String developerDescription) {
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        this.developerDescription = developerDescription;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public String getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    public void setImplementationClass(String implementationClass) {
        ArgChecks.checkForNull(implementationClass, "implementationClass");
        this.implementationClass = implementationClass;
    }

    @Override
    public List<String> getClassPath() {
        return new ArrayList<String>(this.classPath);
    }

    @Override
    public void setClassPath(List<String> classPath) {
        if (classPath == null) {
            this.classPath = new ArrayList();
        } else {
            ArgChecks.checkForNulls(classPath, "classPath");
            this.classPath = new ArrayList<String>(classPath);
        }
    }

    @Override
    public boolean isSingleton() {
        return this.isSingleton;
    }

    @Override
    public void setSingleton(boolean singleton) {
        this.isSingleton = singleton;
    }

    @Override
    public byte[] getSystemComponent() {
        if (this.systemComponentSignature == null) {
            return null;
        }
        return (byte[])this.systemComponentSignature.clone();
    }

    @Override
    public void setSystemComponent(byte[] signature) {
        if (signature == null) {
            this.systemComponentSignature = null;
        } else {
            ArgChecks.checkForEmpty(signature, "signature");
            this.systemComponentSignature = (byte[])signature.clone();
        }
    }

    @Override
    public String getGUIContextID() {
        return this.guiContextID;
    }

    @Override
    public void setGUIContextID(String guiContextID) {
        ArgChecks.checkForEmpty(guiContextID, "guiContextID");
        this.guiContextID = guiContextID;
    }

    @Override
    public ExecutionControlProperties getExecutionControlProperties() {
        return this.executionControlProperties;
    }

    @Override
    public void setExecutionControlProperties(ExecutionControlProperties ecp) {
        ArgChecks.checkForNull(ecp, "ecp");
        this.executionControlProperties = ecp;
    }

    @Override
    public UUID getIconID() {
        return this.iconID;
    }

    @Override
    public void setIconID(UUID iconID) {
        this.iconID = iconID;
    }

    @Override
    public String getLicenceInformation() {
        return this.licenceInformation;
    }

    @Override
    public void setLicenceInformation(String licenceInformation) {
        ArgChecks.checkForNull(licenceInformation, "licenceInformation");
        this.licenceInformation = licenceInformation;
    }

    @Override
    public InheritedConfigurationDescription getConfigurationDescription() {
        return new DefaultInheritedConfigurationDescription(null, this.configurationDescription);
    }

    @Override
    public void setConfigurationDescription(InheritedConfigurationDescription description) {
        this.configurationDescription = new DefaultInheritedConfigurationDescription(null, description);
    }

    @Override
    public InheritedCollection<String, ParameterTemplate> getParameterTemplates() {
        return new InheritedParameterTemplateCollection(null, "ParameterTemplate of ExecutableComponentDescription", this.parameterTemplates);
    }

    @Override
    public void setParameterTemplates(InheritedCollection<String, ParameterTemplate> parameterTemplates) {
        this.parameterTemplates = new InheritedParameterTemplateCollection(null, null, parameterTemplates);
    }

    @Override
    public StorageExecutableComponentDescription getStorageECD() {
        return new DefaultStorageExecutableComponentDescription(this.getName(), this.getDeveloperDescription(), this.getRevision(), this.getState(), this.getImplementationClass(), this.getClassPath(), this.isSingleton(), this.getSystemComponent(), this.getGUIContextID(), this.getExecutionControlProperties(), this.getIconID(), this.getLicenceInformation(), ActivityModelImpl.convert(this.configurationDescription), ActivityModelImpl.convertParameterTemplates(this.parameterTemplates.getAllOwn()).values(), this, this.getUserAttributes());
    }
}

